/*
 * Decompiled with CFR 0.152.
 */
package prompto.runtime;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import prompto.compiler.CompilerUtils;
import prompto.compiler.PromptoClassLoader;
import prompto.declaration.TestMethodDeclaration;
import prompto.error.InternalError;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDict;
import prompto.runtime.Context;
import prompto.utils.CmdLineParser;

public abstract class Executor {
    public static void executeTests(Context context) {
        Collection<TestMethodDeclaration> tests = context.getTests();
        for (TestMethodDeclaration test : tests) {
            Context local = context.newLocalContext();
            Executor.executeTest(local, test.getName(), true);
        }
    }

    public static void executeTest(Context context, String testName, boolean testMode) {
        try (PromptoClassLoader loader = PromptoClassLoader.initialize(context, testMode);){
            Type classType = CompilerUtils.getTestType(testName);
            Class<?> klass = loader.loadClass(classType.getTypeName());
            Method method = klass.getDeclaredMethod("run", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new SyntaxError("Could not find a compatible \"" + testName + "\" test.");
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new InternalError(e);
        }
        finally {
            context.notifyCompleted();
        }
    }

    public static void executeTest(PromptoClassLoader loader, String testName) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Type classType = CompilerUtils.getTestType(testName);
        Class<?> klass = loader.loadClass(classType.getTypeName());
        Method method = klass.getDeclaredMethod("run", new Class[0]);
        method.invoke(null, new Object[0]);
    }

    public static void executeMainNoArgs(Context context) throws PromptoError {
        Executor.executeMainMethod(context, new Identifier("main"), "-testMode=true", null);
    }

    public static void executeMainNoArgs(Context context, File promptoDir) throws PromptoError {
        Executor.executeMainMethod(context, new Identifier("main"), "-testMode=true", promptoDir);
    }

    private static PromptoDict<String, String> parseCmdLineArgs(String cmdLineArgs) {
        PromptoDict<String, String> result = new PromptoDict<String, String>(false);
        try {
            Map<String, String> args = CmdLineParser.parse(cmdLineArgs);
            result.putAll(args);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return result;
    }

    public static void executeMainMethod(Context context, Identifier methodName, String cmdLineArgs, File promptoDir) throws PromptoError {
        Object[] objectArray;
        Class[] classArray;
        PromptoDict<String, String> options = Executor.parseCmdLineArgs(cmdLineArgs);
        boolean testMode = options.containsKey("testMode");
        if (cmdLineArgs == null) {
            classArray = new Class[]{};
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = PromptoDict.class;
        }
        Class[] argTypes = classArray;
        if (cmdLineArgs == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = options;
        }
        Object[] args = objectArray;
        try (PromptoClassLoader loader = PromptoClassLoader.initialize(context, testMode);){
            Executor.executeGlobalMethod(loader, methodName, argTypes, args);
        }
        catch (NoSuchMethodException e) {
            if (e.getCause() instanceof PromptoError) {
                throw (PromptoError)e.getCause();
            }
            throw new InternalError(e.getCause());
        }
        catch (ClassNotFoundException e) {
            if (e.getException() instanceof PromptoError) {
                throw (PromptoError)e.getCause();
            }
            throw new InternalError(e.getException());
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace(System.err);
            throw new InternalError(e);
        }
        finally {
            context.notifyCompleted();
        }
    }

    public static Object executeGlobalMethod(PromptoClassLoader loader, Identifier methodName, Class<?>[] argTypes, Object[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Type classType = CompilerUtils.getGlobalMethodType(methodName);
        Class<?> klass = loader.loadClass(classType.getTypeName());
        Method method = Executor.locateGlobalMethod(klass, argTypes);
        if (method.getParameterCount() == 0) {
            return method.invoke(null, new Object[0]);
        }
        return method.invoke(null, args);
    }

    public static Method locateGlobalMethod(Class<?> klass, Class<?> ... argTypes) throws NoSuchMethodException {
        for (Method method : klass.getDeclaredMethods()) {
            if (!Executor.identicalArguments(method.getParameterTypes(), argTypes)) continue;
            return method;
        }
        if (argTypes.length == 0) {
            argTypes = new Class[]{Map.class};
            for (Method method : klass.getDeclaredMethods()) {
                if (!Executor.identicalArguments(method.getParameterTypes(), argTypes)) continue;
                return method;
            }
        }
        for (Method method : klass.getDeclaredMethods()) {
            if (method.getParameterTypes().length != 0) continue;
            return method;
        }
        throw new NoSuchMethodException(klass.getSimpleName() + argTypes.toString());
    }

    private static boolean identicalArguments(Class<?>[] expected, Class<?>[] provided) {
        if (expected.length != provided.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == provided[i]) continue;
            return false;
        }
        return true;
    }
}

