/*
 * Decompiled with CFR 0.152.
 */
package prompto.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.MethodSelector;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.Specificity;
import prompto.param.IParameter;
import prompto.runtime.Context;
import prompto.runtime.Score;
import prompto.statement.MethodCall;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.value.IInstance;
import prompto.value.IValue;

public class MethodFinder {
    Context context;
    MethodCall methodCall;

    public MethodFinder(Context context, MethodCall methodCall) {
        this.context = context;
        this.methodCall = methodCall;
    }

    public String toString() {
        return this.methodCall.toString();
    }

    public Set<IMethodDeclaration> findCompatibleMethods(boolean checkInstance, boolean allowDerived, Predicate<Specificity> filter) {
        Set<IMethodDeclaration> methods = this.findCandidateMethods(checkInstance);
        if (methods.size() == 0) {
            this.context.getProblemListener().reportUnknownMethod(this.methodCall.getSelector().getId(), this.methodCall.toString());
            return null;
        }
        return this.filterCompatible(methods, checkInstance, allowDerived, filter);
    }

    public IMethodDeclaration findBestMethod(boolean checkInstance) {
        Set<IMethodDeclaration> methods = this.findCompatibleMethods(checkInstance, false, spec -> spec != Specificity.INCOMPATIBLE && spec != Specificity.DERIVED);
        switch (methods.size()) {
            case 0: {
                this.context.getProblemListener().reportNoMatchingPrototype(this.methodCall.getSelector().getId(), this.methodCall.toString());
                return null;
            }
            case 1: {
                return (IMethodDeclaration)methods.iterator().next();
            }
        }
        return this.findMostSpecific(methods, checkInstance);
    }

    public Set<IMethodDeclaration> findCandidateMethods(boolean checkInstance) {
        MethodSelector selector = this.methodCall.getSelector();
        return selector.getCandidates(this.context, checkInstance);
    }

    public List<IMethodDeclaration> findPotentialMethods() {
        MethodSelector selector = this.methodCall.getSelector();
        Set<IMethodDeclaration> candidates = selector.getCandidates(this.context, false);
        if (candidates.size() == 0) {
            this.context.getProblemListener().reportUnknownMethod(this.methodCall.getSelector().getId(), this.methodCall.toString());
        }
        return this.filterPotential(candidates);
    }

    public IMethodDeclaration findLessSpecific(Collection<IMethodDeclaration> candidates) {
        IMethodDeclaration candidate = null;
        ArrayList<IMethodDeclaration> ambiguous = new ArrayList<IMethodDeclaration>();
        for (IMethodDeclaration declaration : candidates) {
            if (candidate == null) {
                candidate = declaration;
                continue;
            }
            Score score = this.compareSpecifity(candidate, declaration, false, true);
            switch (score) {
                case BETTER: {
                    candidate = declaration;
                    ambiguous.clear();
                    break;
                }
                case WORSE: {
                    break;
                }
                case SIMILAR: {
                    ambiguous.add(declaration);
                }
            }
        }
        if (ambiguous.size() > 0) {
            throw new SyntaxError("Too many prototypes!");
        }
        return candidate;
    }

    public IMethodDeclaration findMostSpecific(Collection<IMethodDeclaration> candidates, boolean checkInstance) {
        IMethodDeclaration candidate = null;
        ArrayList<IMethodDeclaration> ambiguous = new ArrayList<IMethodDeclaration>();
        for (IMethodDeclaration declaration : candidates) {
            if (candidate == null) {
                candidate = declaration;
                continue;
            }
            Score score = this.compareSpecifity(candidate, declaration, checkInstance, false);
            switch (score) {
                case WORSE: {
                    candidate = declaration;
                    ambiguous.clear();
                    break;
                }
                case BETTER: {
                    break;
                }
                case SIMILAR: {
                    ambiguous.add(declaration);
                }
            }
        }
        if (ambiguous.size() > 0) {
            throw new SyntaxError("Too many prototypes!");
        }
        return candidate;
    }

    Score compareSpecifity(IMethodDeclaration d1, IMethodDeclaration d2, boolean useInstance, boolean allowDerived) {
        try {
            Context s1 = this.context.newLocalContext();
            d1.registerParameters(s1);
            Context s2 = this.context.newLocalContext();
            d2.registerParameters(s2);
            Iterator it1 = this.methodCall.makeArguments(this.context, d1).iterator();
            Iterator it2 = this.methodCall.makeArguments(this.context, d2).iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Argument as1 = (Argument)it1.next();
                Argument as2 = (Argument)it2.next();
                IParameter ar1 = d1.getParameters().find(as1.getParameterId());
                IParameter ar2 = d2.getParameters().find(as2.getParameterId());
                if (as1.getParameterId().equals(as2.getParameterId())) {
                    CategoryType actual;
                    Score score;
                    IValue value;
                    IType t1 = ar1.getType(s1);
                    IType t2 = ar2.getType(s2);
                    if (useInstance && t1 instanceof CategoryType && t2 instanceof CategoryType && (value = as1.getExpression().interpret(this.context)) instanceof IInstance && (score = (actual = ((IInstance)value).getType()).compareSpecificity(this.context, (CategoryType)t1, (CategoryType)t2)) != Score.SIMILAR) {
                        return score;
                    }
                    if (t1.isMoreSpecificThan(s2, t2)) {
                        return Score.BETTER;
                    }
                    if (!t2.isMoreSpecificThan(s1, t1)) continue;
                    return Score.WORSE;
                }
                Specificity sp1 = d1.computeSpecificity(s1, ar1, as1, useInstance, allowDerived);
                Specificity sp2 = d2.computeSpecificity(s2, ar2, as2, useInstance, allowDerived);
                if (sp1.ordinal() > sp2.ordinal()) {
                    return Score.BETTER;
                }
                if (sp2.ordinal() <= sp1.ordinal()) continue;
                return Score.WORSE;
            }
        }
        catch (PromptoError promptoError) {
            // empty catch block
        }
        return Score.SIMILAR;
    }

    Set<IMethodDeclaration> filterCompatible(Collection<IMethodDeclaration> candidates, boolean checkInstance, boolean allowDerived, Predicate<Specificity> filter) {
        HashSet<IMethodDeclaration> compatibles = new HashSet<IMethodDeclaration>();
        for (IMethodDeclaration declaration : candidates) {
            try {
                ArgumentList args = this.methodCall.makeArguments(this.context, declaration);
                if (!declaration.isAssignableTo(this.context, args, checkInstance, allowDerived, filter)) continue;
                compatibles.add(declaration);
            }
            catch (SyntaxError syntaxError) {}
        }
        return compatibles;
    }

    List<IMethodDeclaration> filterPotential(Collection<IMethodDeclaration> candidates) {
        ArrayList<IMethodDeclaration> potential = new ArrayList<IMethodDeclaration>();
        for (IMethodDeclaration declaration : candidates) {
            try {
                ArgumentList args = this.methodCall.makeArguments(this.context, declaration);
                if (!declaration.isAssignableFrom(this.context, args)) continue;
                potential.add(declaration);
            }
            catch (SyntaxError syntaxError) {}
        }
        return potential;
    }

    public List<IMethodDeclaration> sortMostSpecificFirst(Collection<IMethodDeclaration> declarations) {
        ArrayList<IMethodDeclaration> result = new ArrayList<IMethodDeclaration>(declarations);
        result.sort((d1, d2) -> {
            Score score = this.compareSpecifity((IMethodDeclaration)d2, (IMethodDeclaration)d1, false, true);
            switch (score) {
                case BETTER: {
                    return 1;
                }
                case WORSE: {
                    return -1;
                }
            }
            return 0;
        });
        return result;
    }
}

