/*
 * Decompiled with CFR 0.152.
 */
package prompto.runtime;

import prompto.declaration.IMethodDeclaration;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.grammar.ParameterList;
import prompto.param.IParameter;
import prompto.param.ITypedParameter;
import prompto.runtime.Context;
import prompto.runtime.Interpreter;
import prompto.type.DictType;
import prompto.type.IType;
import prompto.type.TextType;

public abstract class MethodLocator {
    public static IMethodDeclaration locateMethod(Context context, Identifier methodName, IExpression args) {
        Context.MethodDeclarationMap map = context.getRegisteredDeclaration(Context.MethodDeclarationMap.class, methodName);
        if (map == null) {
            throw new SyntaxError("Could not find a \"" + methodName + "\" method.");
        }
        return MethodLocator.locateMethod(map, args != null);
    }

    static IMethodDeclaration locateMethod(Context.MethodDeclarationMap map, boolean hasArgs) {
        if (hasArgs) {
            return MethodLocator.locateMethod(map, new DictType(TextType.instance()));
        }
        return MethodLocator.locateMethod(map, new IType[0]);
    }

    static IMethodDeclaration locateMethod(Context.MethodDeclarationMap map, IType ... argTypes) {
        for (IMethodDeclaration method : map.values()) {
            if (!MethodLocator.identicalParameters(method.getParameters(), argTypes)) continue;
            return method;
        }
        if (argTypes.length == 0) {
            for (IMethodDeclaration method : map.values()) {
                if (!MethodLocator.isSingleTextDictParameter(method.getParameters())) continue;
                return method;
            }
        }
        for (IMethodDeclaration method : map.values()) {
            if (method.getParameters().size() != 0) continue;
            return method;
        }
        throw new SyntaxError("Could not find a compatible \"" + map.getId() + "\" method.");
    }

    static boolean isSingleTextDictParameter(ParameterList arguments) {
        if (arguments.size() != 1) {
            return false;
        }
        IParameter arg = (IParameter)arguments.getFirst();
        if (!(arg instanceof ITypedParameter)) {
            return false;
        }
        return ((ITypedParameter)arg).getType().equals(Interpreter.argsType);
    }

    static boolean identicalParameters(ParameterList parameters, IType[] argTypes) {
        if (parameters.size() != argTypes.length) {
            return false;
        }
        int idx = 0;
        for (IParameter parameter : parameters) {
            IType argType;
            if (!(parameter instanceof ITypedParameter)) {
                return false;
            }
            if ((argType = argTypes[idx++]).equals(((ITypedParameter)parameter).getType())) continue;
            return false;
        }
        return true;
    }
}

