/*
 * Decompiled with CFR 0.152.
 */
package prompto.security;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import prompto.config.IConfigurationReader;
import prompto.config.IKeyStoreFactoryConfiguration;
import prompto.security.IKeyStoreFactory;
import prompto.utils.Logger;

public class FileKeyStoreFactory
implements IKeyStoreFactory {
    static final Logger logger = new Logger();

    @Override
    public IKeyStoreFactoryConfiguration newConfiguration(IConfigurationReader reader) {
        return new Configuration(reader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyStore newInstance(IKeyStoreFactoryConfiguration config) {
        String filePath = ((Configuration)config).getFile();
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath);
        logger.info(() -> "Loading certificate store: " + file.getAbsolutePath());
        try (FileInputStream input = new FileInputStream(filePath);){
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(input, null);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class Configuration
    implements IKeyStoreFactoryConfiguration {
        IConfigurationReader reader;

        public Configuration(IConfigurationReader reader) {
            this.reader = reader;
        }

        public String getFile() {
            return this.reader.getString("file");
        }

        @Override
        public IKeyStoreFactory getKeyStoreFactory() {
            return new FileKeyStoreFactory();
        }

        @Override
        public YamlMapping toYaml() throws YamlException {
            YamlMapping yaml = new YamlMapping();
            yaml.setEntry("factory", FileKeyStoreFactory.class.getName());
            yaml.setEntry("file", this.getFile());
            return yaml;
        }
    }
}

