/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.instance.IAssignableInstance;
import prompto.runtime.Context;
import prompto.statement.SimpleStatement;
import prompto.transpiler.Transpiler;
import prompto.type.CodeType;
import prompto.type.IType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class AssignInstanceStatement
extends SimpleStatement {
    IAssignableInstance instance;
    IExpression expression;

    public AssignInstanceStatement(IAssignableInstance instance, IExpression expression) {
        this.instance = instance;
        this.expression = expression;
    }

    public String toString() {
        return this.instance.toString() + " = " + this.expression.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.instance.toDialect(writer, this.expression);
        writer.append(" = ");
        this.expression.toDialect(writer);
    }

    public IExpression getExpression() {
        return this.expression;
    }

    @Override
    public IType check(Context context) {
        IType valueType = this.expression.check(context);
        this.instance.checkAssignValue(context, valueType, this);
        if (valueType == CodeType.instance()) {
            this.instance.assign(context, this.expression);
        }
        return VoidType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        this.instance.assign(context, this.expression);
        return null;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        return this.instance.compileAssign(context, method, flags, this.expression);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.instance.declareAssign(transpiler, this.expression);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        IType valueType = this.expression.check(transpiler.getContext());
        if (valueType == CodeType.instance()) {
            this.instance.declareAssign(transpiler, this.expression);
            return true;
        }
        this.instance.transpileAssign(transpiler, this.expression);
        return false;
    }
}

