/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicInteger;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.IntConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoTuple;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.statement.SimpleStatement;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.IType;
import prompto.type.TupleType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.TupleValue;

public class AssignTupleStatement
extends SimpleStatement {
    IdentifierList names;
    IExpression expression;

    public AssignTupleStatement(IdentifierList names, IExpression expression) {
        this.names = names;
        this.expression = expression;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.names.toDialect(writer, false);
        writer.append(" = ");
        this.expression.toDialect(writer);
    }

    public void add(Identifier i1) {
        this.names.add(i1);
    }

    public IdentifierList getNames() {
        return this.names;
    }

    public void setExpression(IExpression expression) {
        this.expression = expression;
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignTupleStatement)) {
            return false;
        }
        AssignTupleStatement other = (AssignTupleStatement)obj;
        return this.getNames().equals(other.getNames()) && this.getExpression().equals(other.getExpression());
    }

    @Override
    public IType check(Context context) {
        IType type = this.expression.check(context);
        if (type != TupleType.instance()) {
            throw new SyntaxError("Expecting a tuple expression, got " + type.getTypeName());
        }
        for (Identifier name : this.names) {
            INamed actual = context.getRegistered(name);
            if (actual == null) {
                context.registerValue(new Variable(name, AnyType.instance()));
                continue;
            }
            IType actualType = actual.getType(context);
            actualType.checkAssignableFrom(context, AnyType.instance());
        }
        return VoidType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue object = this.expression.interpret(context);
        if (!(object instanceof TupleValue)) {
            throw new SyntaxError("Expecting a tuple expression, got " + object.getClass().getSimpleName());
        }
        TupleValue tuple = (TupleValue)object;
        for (int i = 0; i < this.names.size(); ++i) {
            Identifier name = (Identifier)this.names.get(i);
            IValue value = tuple.getItem(context, new IntegerValue(i + 1));
            if (context.getRegisteredValue(INamed.class, name) == null) {
                context.registerValue(new Variable(name, value.getType()));
            }
            context.setValue(name, value);
        }
        return null;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo info = this.expression.compile(context, method, flags);
        if (PromptoTuple.class != info.getType()) {
            throw new SyntaxError("Expecting a Tuple!");
        }
        for (int i = 0; i < this.names.size(); ++i) {
            this.compileAssignTupleItem(context, method, flags, i);
        }
        method.addInstruction(Opcode.POP, new IOperand[0]);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    private void compileAssignTupleItem(Context context, MethodInfo method, Flags flags, int i) {
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        if (i < 6) {
            Opcode opcode = Opcode.values()[i + Opcode.ICONST_0.ordinal()];
            method.addInstruction(opcode, new IOperand[0]);
        } else {
            method.addInstruction(Opcode.LDC, new IntConstant(i));
        }
        MethodConstant m = new MethodConstant((Type)((Object)PromptoTuple.class), "get", new Type[]{Integer.TYPE, Object.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        Identifier name = (Identifier)this.names.get(i);
        StackLocal local = method.registerLocal(name.toString(), IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)Object.class)));
        CompilerUtils.compileASTORE(method, local);
        if (context.getRegisteredValue(INamed.class, name) == null) {
            context.registerValue(new Variable(name, AnyType.instance()));
        }
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.expression.declare(transpiler);
        this.names.forEach(name -> {
            INamed actual = transpiler.getContext().getRegistered((Identifier)name);
            if (actual == null) {
                transpiler.getContext().registerValue(new Variable((Identifier)name, AnyType.instance()));
            }
        });
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        if (transpiler.getEngine().supportsDestructuring()) {
            transpiler.append("var [");
            this.names.forEach(name -> {
                transpiler.append(name.toString()).append(", ");
                INamed actual = transpiler.getContext().getRegistered((Identifier)name);
                if (actual == null) {
                    transpiler.getContext().registerValue(new Variable((Identifier)name, AnyType.instance()));
                }
            });
            transpiler.trimLast(2);
            transpiler.append("] = ");
            this.expression.transpile(transpiler);
        } else {
            transpiler.append("var $tuple = ");
            this.expression.transpile(transpiler);
            transpiler.append(";").newLine();
            AtomicInteger idx = new AtomicInteger();
            this.names.forEach(name -> {
                transpiler.append("var ");
                transpiler.append(name.toString()).append(" = $tuple[").append(String.valueOf(idx.getAndIncrement())).append("];").newLine();
                INamed actual = transpiler.getContext().getRegistered((Identifier)name);
                if (actual == null) {
                    transpiler.getContext().registerValue(new Variable((Identifier)name, AnyType.instance()));
                }
            });
        }
        return false;
    }
}

