/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.expression.Symbol;
import prompto.expression.SymbolExpression;
import prompto.runtime.Context;
import prompto.statement.StatementList;
import prompto.statement.SwitchCase;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class AtomicSwitchCase
extends SwitchCase {
    public AtomicSwitchCase(IExpression expression, StatementList list) {
        super(expression, list);
    }

    @Override
    public void checkSwitchType(Context context, IType type) {
        IType thisType = this.expression.check(context);
        if (!type.isAssignableFrom(context, thisType)) {
            throw new SyntaxError("Cannot assign:" + thisType.getTypeName() + " to:" + type.getTypeName());
        }
    }

    @Override
    public boolean matches(Context context, IValue value) throws PromptoError {
        if (value instanceof Symbol && this.expression instanceof SymbolExpression) {
            return value == ((SymbolExpression)this.expression).getSymbol(context);
        }
        IValue thisValue = this.expression.interpret(context);
        return value.equals(thisValue);
    }

    @Override
    public void caseToPDialect(CodeWriter writer) {
        this.caseToEDialect(writer);
    }

    @Override
    public void caseToODialect(CodeWriter writer) {
        writer.append("case ");
        this.expression.toDialect(writer);
        writer.append(":\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    public void catchToODialect(CodeWriter writer) {
        writer.append("catch (");
        this.expression.toDialect(writer);
        writer.append(") {\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        writer.append("} ");
    }

    @Override
    public void caseToEDialect(CodeWriter writer) {
        writer.append("when ");
        this.expression.toDialect(writer);
        writer.append(":\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    public void catchToPDialect(CodeWriter writer) {
        writer.append("except ");
        this.expression.toDialect(writer);
        writer.append(":\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    public void catchToEDialect(CodeWriter writer) {
        this.caseToEDialect(writer);
    }

    @Override
    public void transpile(Transpiler transpiler) {
        transpiler.append("case ");
        this.expression.transpile(transpiler);
        transpiler.append(":").indent();
        this.statements.transpile(transpiler);
        transpiler.append("break;").dedent();
    }

    @Override
    public void transpileError(Transpiler transpiler) {
        transpiler.append("case \"");
        this.expression.transpile(transpiler);
        transpiler.append("\":");
        transpiler.indent();
        this.statements.transpile(transpiler);
        transpiler.append("break;");
        transpiler.dedent();
    }
}

