/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.util.LinkedList;
import java.util.Objects;
import prompto.error.ExecutionError;
import prompto.error.PromptoError;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.statement.BaseStatement;
import prompto.statement.StatementList;
import prompto.statement.SwitchCase;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.TypeMap;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public abstract class BaseSwitchStatement
extends BaseStatement {
    SwitchCaseList switchCases;
    StatementList defaultCase;

    public BaseSwitchStatement() {
        this.switchCases = new SwitchCaseList();
        this.defaultCase = null;
    }

    public BaseSwitchStatement(SwitchCaseList switchCases, StatementList defaultCase) {
        this.switchCases = switchCases != null ? switchCases : new SwitchCaseList();
        this.defaultCase = defaultCase;
    }

    public void addSwitchCase(SwitchCase switchCase) {
        this.switchCases.add(switchCase);
    }

    public void setDefaultCase(StatementList defaultCase) {
        this.defaultCase = defaultCase;
    }

    @Override
    public ISection locateSection(ISection section) {
        ISection result = this.switchCases.locateSection(section);
        if (result == null && this.defaultCase != null) {
            result = this.defaultCase.locateSection(section);
        }
        return result != null ? result : super.locateSection(section);
    }

    @Override
    public void toDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    protected abstract void toEDialect(CodeWriter var1);

    protected abstract void toODialect(CodeWriter var1);

    protected abstract void toMDialect(CodeWriter var1);

    @Override
    public IType check(Context context) {
        this.checkSwitchCasesType(context);
        return this.checkReturnType(context);
    }

    @Override
    public boolean canReturn() {
        return true;
    }

    protected void checkSwitchCasesType(Context context) {
        IType type = this.checkSwitchType(context);
        for (SwitchCase sc : this.switchCases) {
            sc.checkSwitchType(context, type);
        }
    }

    abstract IType checkSwitchType(Context var1);

    private IType checkReturnType(Context context) {
        TypeMap types = new TypeMap();
        this.collectReturnTypes(context, types);
        return types.inferType(context);
    }

    protected void collectReturnTypes(Context context, TypeMap types) {
        IType type;
        for (SwitchCase sc : this.switchCases) {
            IType type2 = sc.checkReturnType(context);
            if (type2 == VoidType.instance()) continue;
            types.put(type2.getTypeNameId(), type2);
        }
        if (this.defaultCase != null && (type = this.defaultCase.check(context, null)) != VoidType.instance()) {
            types.put(type.getTypeNameId(), type);
        }
    }

    protected IValue interpretSwitch(Context context, IValue switchValue, ExecutionError toThrow) throws PromptoError {
        for (SwitchCase sc : this.switchCases) {
            if (!sc.matches(context, switchValue)) continue;
            return sc.interpret(context);
        }
        if (this.defaultCase != null) {
            return this.defaultCase.interpret(context);
        }
        if (toThrow != null) {
            throw toThrow;
        }
        return null;
    }

    protected void declareSwitch(Transpiler transpiler) {
        this.switchCases.forEach(kase -> kase.declare(transpiler));
        if (this.defaultCase != null) {
            this.defaultCase.declare(transpiler);
        }
    }

    public static class SwitchCaseList
    extends LinkedList<SwitchCase> {
        private static final long serialVersionUID = 1L;

        public SwitchCaseList() {
        }

        public SwitchCaseList(SwitchCase item) {
            this.add(item);
        }

        public ISection locateSection(ISection section) {
            return this.stream().map(s -> s.locateSection(section)).filter(Objects::nonNull).findFirst().orElse(null);
        }
    }
}

