/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.literal.ContainerLiteral;
import prompto.runtime.Context;
import prompto.statement.StatementList;
import prompto.statement.SwitchCase;
import prompto.transpiler.Transpiler;
import prompto.type.ContainerType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.utils.ExpressionList;
import prompto.value.IContainer;
import prompto.value.IValue;
import prompto.value.ListValue;

public class CollectionSwitchCase
extends SwitchCase {
    public CollectionSwitchCase(IExpression expression, StatementList list) {
        super(expression, list);
    }

    @Override
    public void checkSwitchType(Context context, IType type) {
        IType thisType = this.expression.check(context);
        if (thisType instanceof ContainerType) {
            thisType = ((ContainerType)thisType).getItemType();
        }
        if (!type.isAssignableFrom(context, thisType)) {
            throw new SyntaxError("Cannot assign:" + thisType.getTypeName() + " to:" + type.getTypeName());
        }
    }

    @Override
    public boolean matches(Context context, IValue value) throws PromptoError {
        IValue thisValue = this.expression.interpret(context);
        if (thisValue instanceof IContainer) {
            return ((IContainer)thisValue).hasItem(context, value);
        }
        if (thisValue instanceof ListValue) {
            return ((ListValue)thisValue).hasItem(context, value);
        }
        return false;
    }

    @Override
    public void caseToPDialect(CodeWriter writer) {
        this.caseToEDialect(writer);
    }

    @Override
    public void caseToODialect(CodeWriter writer) {
        writer.append("case in ");
        this.expression.toDialect(writer);
        writer.append(":\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    public void caseToEDialect(CodeWriter writer) {
        writer.append("when in ");
        this.expression.toDialect(writer);
        writer.append(":\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    public void catchToODialect(CodeWriter writer) {
        writer.append("catch (");
        this.expression.toDialect(writer);
        writer.append(") {\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        writer.append("} ");
    }

    @Override
    public void catchToPDialect(CodeWriter writer) {
        writer.append("except in ");
        this.expression.toDialect(writer);
        writer.append(":\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    public void catchToEDialect(CodeWriter writer) {
        this.caseToEDialect(writer);
    }

    @Override
    public void transpile(Transpiler transpiler) {
        ExpressionList expressions = ((ContainerLiteral)this.expression).getExpressions();
        expressions.forEach(expression -> {
            transpiler.append("case ");
            expression.transpile(transpiler);
            transpiler.append(":").newLine();
        });
        transpiler.indent(true);
        this.statements.transpile(transpiler);
        transpiler.append("break;").dedent();
    }

    @Override
    public void transpileError(Transpiler transpiler) {
        throw new UnsupportedOperationException();
    }
}

