/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.declaration.ConcreteMethodDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.statement.BaseStatement;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.ClosureValue;
import prompto.value.IValue;

public class DeclarationStatement<T extends IDeclaration>
extends BaseStatement {
    T declaration;

    public DeclarationStatement(T declaration) {
        this.declaration = declaration;
        if (declaration instanceof IMethodDeclaration) {
            ((IMethodDeclaration)declaration).setDeclarationOf(this);
        }
    }

    public T getDeclaration() {
        return this.declaration;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.declaration instanceof ConcreteMethodDeclaration) {
            try {
                ConcreteMethodDeclaration method = (ConcreteMethodDeclaration)this.declaration;
                writer.getContext().registerDeclaration(method);
            }
            catch (SyntaxError syntaxError) {
                // empty catch block
            }
        }
        this.declaration.toDialect(writer);
    }

    @Override
    public IType check(Context context) {
        if (!(this.declaration instanceof ConcreteMethodDeclaration)) {
            throw new SyntaxError("Unsupported:" + this.declaration.getClass().getSimpleName());
        }
        ConcreteMethodDeclaration method = (ConcreteMethodDeclaration)this.declaration;
        method.checkChild(context);
        context.registerDeclaration(method);
        return VoidType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        if (this.declaration instanceof IMethodDeclaration) {
            IMethodDeclaration decl = (IMethodDeclaration)this.declaration;
            context.registerDeclarationIfMissing(decl);
            MethodType type = new MethodType(decl);
            context.registerValue(new Variable(decl.getId(), type));
            context.setValue(decl.getId(), new ClosureValue(context, type));
            return null;
        }
        throw new SyntaxError("Unsupported:" + this.declaration.getClass().getSimpleName());
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        if (this.declaration instanceof ConcreteMethodDeclaration) {
            ConcreteMethodDeclaration decl = (ConcreteMethodDeclaration)this.declaration;
            context.registerDeclarationIfMissing(decl);
            decl.compileClosureClass(context, method);
            return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
        }
        throw new SyntaxError("Unsupported:" + this.declaration.getClass().getSimpleName());
    }

    @Override
    public void declare(Transpiler transpiler) {
        if (!(this.declaration instanceof ConcreteMethodDeclaration)) {
            throw new SyntaxError("Unsupported:" + this.declaration.getClass().getSimpleName());
        }
        this.declaration.declareChild(transpiler);
        transpiler.getContext().registerDeclaration((ConcreteMethodDeclaration)this.declaration);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        if (this.declaration instanceof ConcreteMethodDeclaration) {
            this.declaration.transpile(transpiler);
            transpiler.getContext().registerDeclaration((ConcreteMethodDeclaration)this.declaration);
            if (transpiler.getContext().getClosestInstanceContext() != null) {
                String name = this.declaration.getTranspiledName(transpiler.getContext());
                transpiler.append(name).append(" = ").append(name).append(".bind(this);").newLine();
            }
            return true;
        }
        throw new SyntaxError("Unsupported:" + this.declaration.getClass().getSimpleName());
    }
}

