/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.lang.reflect.Type;
import prompto.compiler.Flags;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.statement.SimpleStatement;
import prompto.store.DataStore;
import prompto.store.IStore;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class FlushStatement
extends SimpleStatement {
    @Override
    public IType check(Context context) {
        return VoidType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        DataStore.getInstance().flush();
        return null;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        MethodConstant m = new MethodConstant((Type)((Object)DataStore.class), "getInstance", new Type[]{IStore.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        InterfaceConstant i = new InterfaceConstant((Type)((Object)IStore.class), "flush", Void.TYPE);
        method.addInstruction(Opcode.INVOKEINTERFACE, i);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append("flush");
        if (writer.getDialect() != Dialect.E) {
            writer.append("()");
        }
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("DataStore");
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("$DataStore.instance.flush()");
        return false;
    }
}

