/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import prompto.compiler.ByteOperand;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IInstructionListener;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.compiler.StackState;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.parser.ISection;
import prompto.runtime.BreakResult;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.statement.BaseStatement;
import prompto.statement.IStatement;
import prompto.statement.StatementList;
import prompto.transpiler.Transpiler;
import prompto.type.DictType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.ListType;
import prompto.utils.CodeWriter;
import prompto.value.IIterable;
import prompto.value.IValue;
import prompto.value.IntegerValue;

public class ForEachStatement
extends BaseStatement {
    Identifier v1;
    Identifier v2;
    IExpression source;
    StatementList statements;

    public ForEachStatement(Identifier v1, Identifier v2, IExpression source, StatementList instructions) {
        this.v1 = v1;
        this.v2 = v2;
        this.source = source;
        this.statements = instructions;
    }

    public StatementList getInstructions() {
        return this.statements;
    }

    @Override
    public boolean canReturn() {
        return true;
    }

    @Override
    public ISection locateSection(ISection section) {
        ISection result = this.statements.locateSection(section);
        return result != null ? result : super.locateSection(section);
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer = writer.newChildWriter();
        IType srcType = this.source.check(writer.getContext());
        IType elemType = srcType.checkIterator(writer.getContext());
        Identifier itemName = this.v2 == null ? this.v1 : this.v2;
        writer.getContext().registerValue(new Variable(itemName, elemType));
        if (this.v2 != null) {
            writer.getContext().registerValue(new Variable(this.v1, IntegerType.instance()));
        }
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    private void toODialect(CodeWriter writer) {
        boolean oneLine;
        writer.append("for each (").append(this.v1);
        if (this.v2 != null) {
            writer.append(", ").append(this.v2);
        }
        writer.append(" in ");
        this.source.toDialect(writer);
        writer.append(")");
        boolean bl = oneLine = this.statements.size() == 1 && ((IStatement)this.statements.get(0)).isSimple();
        if (!oneLine) {
            writer.append(" {");
        }
        writer.newLine().indent();
        this.statements.toDialect(writer);
        writer.dedent();
        if (!oneLine) {
            writer.append("}").newLine();
        }
    }

    private void toEDialect(CodeWriter writer) {
        writer.append("for each ").append(this.v1);
        if (this.v2 != null) {
            writer.append(", ").append(this.v2);
        }
        writer.append(" in ");
        this.source.toDialect(writer);
        writer.append(":").newLine().indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    private void toMDialect(CodeWriter writer) {
        writer.append("for ").append(this.v1);
        if (this.v2 != null) {
            writer.append(", ").append(this.v2);
        }
        writer.append(" in ");
        this.source.toDialect(writer);
        writer.append(":").newLine().indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    public IType check(Context context) {
        IType srcType = this.source.check(context);
        IType elemType = srcType.checkIterator(context);
        return this.checkItemIterator(elemType, context);
    }

    private IType checkItemIterator(IType elemType, Context context) {
        Context child = context.newChildContext();
        Identifier itemName = this.v2 == null ? this.v1 : this.v2;
        context.registerValue(new Variable(itemName, elemType));
        if (this.v2 != null) {
            context.registerValue(new Variable(this.v1, IntegerType.instance()));
        }
        return this.statements.check(child, null);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IType srcType = this.source.check(context);
        IType elemType = srcType.checkIterator(context);
        return this.interpretItemIterator(elemType, context);
    }

    private IValue interpretItemIterator(IType elemType, Context context) throws PromptoError {
        if (this.v2 == null) {
            return this.interpretItemIteratorNoIndex(elemType, context);
        }
        return this.interpretItemIteratorWithIndex(elemType, context);
    }

    private IValue interpretItemIteratorNoIndex(IType elemType, Context context) throws PromptoError {
        IValue src = this.source.interpret(context);
        Iterator<IValue> iterator = this.getIterator(context, src);
        while (iterator.hasNext()) {
            Context child = context.newChildContext();
            child.registerValue(new Variable(this.v1, elemType));
            child.setValue(this.v1, iterator.next());
            IValue value = this.statements.interpret(child);
            if (value == BreakResult.instance()) break;
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private IValue interpretItemIteratorWithIndex(IType elemType, Context context) throws PromptoError {
        IValue src = this.source.interpret(context);
        Iterator<IValue> iterator = this.getIterator(context, src);
        long index = 0L;
        while (iterator.hasNext()) {
            Context child = context.newChildContext();
            child.registerValue(new Variable(this.v2, elemType));
            child.setValue(this.v2, iterator.next());
            child.registerValue(new Variable(this.v1, IntegerType.instance()));
            child.setValue(this.v1, new IntegerValue(++index));
            IValue value = this.statements.interpret(child);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private Iterator<IValue> getIterator(Context context, Object src) {
        if (src instanceof IIterable) {
            return ((IIterable)src).getIterable(context).iterator();
        }
        if (src instanceof Iterable) {
            return ((Iterable)src).iterator();
        }
        if (src instanceof Iterator) {
            return (Iterator)src;
        }
        throw new InternalError("Should never get there!");
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        if (this.v2 == null) {
            return this.compileWithoutIndex(context, method, flags);
        }
        return this.compileWithIndex(context, method, flags);
    }

    private ResultInfo compileWithIndex(Context context, MethodInfo method, Flags flags) {
        ArrayList<IInstructionListener> breakLoopListeners = new ArrayList<IInstructionListener>();
        flags = flags.withBreakLoopListeners(breakLoopListeners);
        IType itemType = this.source.check(context).checkIterator(context);
        Type itemClass = itemType.getJavaType(context);
        StackLocal iterLocal = this.compileIterator(context, method, flags);
        StackLocal v1Local = this.compileInitCounter(method);
        StackState iteratorState = method.captureStackState();
        OffsetListenerConstant test = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(test);
        method.addInstruction(Opcode.GOTO, test);
        OffsetListenerConstant loop = method.addOffsetListener(new OffsetListenerConstant(true));
        method.activateOffsetListener(loop);
        method.restoreFullStackState(iteratorState);
        method.placeLabel(iteratorState);
        CompilerUtils.compileALOAD(method, iterLocal);
        InterfaceConstant m = new InterfaceConstant((Type)((Object)Iterator.class), "next", new Type[]{Object.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, m);
        method.addInstruction(Opcode.CHECKCAST, new ClassConstant(itemClass));
        StackLocal v2Local = method.registerLocal(this.v2.toString(), IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(itemClass));
        method.addInstruction(Opcode.ASTORE, new ByteOperand((byte)v2Local.getIndex()));
        this.compileIncrementCounter(method, v1Local);
        context = context.newChildContext();
        context.registerValue(new Variable(this.v1, IntegerType.instance()));
        context.registerValue(new Variable(this.v2, itemType));
        this.statements.compile(context, method, flags);
        method.unregisterLocal(v2Local);
        method.addInstruction(Opcode.NOP, new IOperand[0]);
        method.inhibitOffsetListener(test);
        method.restoreFullStackState(iteratorState);
        method.placeLabel(iteratorState);
        CompilerUtils.compileALOAD(method, iterLocal);
        m = new InterfaceConstant((Type)((Object)Iterator.class), "hasNext", Boolean.TYPE);
        method.addInstruction(Opcode.INVOKEINTERFACE, m);
        method.inhibitOffsetListener(loop);
        method.addInstruction(Opcode.IFNE, loop);
        method.unregisterLocal(v1Local);
        method.unregisterLocal(iterLocal);
        if (!breakLoopListeners.isEmpty()) {
            for (IInstructionListener listener : breakLoopListeners) {
                method.inhibitOffsetListener(listener);
            }
            method.restoreFullStackState(iteratorState);
            method.placeLabel(iteratorState);
        }
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    private void compileIncrementCounter(MethodInfo method, StackLocal local) {
        this.compileLoadCounter(method, local);
        method.addInstruction(Opcode.LCONST_1, new IOperand[0]);
        method.addInstruction(Opcode.LADD, new IOperand[0]);
        this.compileStoreCounter(method, local);
    }

    private void compileLoadCounter(MethodInfo method, StackLocal local) {
        CompilerUtils.compileALOAD(method, local);
        MethodConstant m = new MethodConstant((Type)((Object)Long.class), "longValue", Long.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
    }

    private StackLocal compileInitCounter(MethodInfo method) {
        StackLocal local = method.registerLocal(this.v1.toString(), IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)Long.class)));
        method.addInstruction(Opcode.LCONST_0, new IOperand[0]);
        this.compileStoreCounter(method, local);
        return local;
    }

    private void compileStoreCounter(MethodInfo method, StackLocal local) {
        MethodConstant m = new MethodConstant((Type)((Object)Long.class), "valueOf", new Type[]{Long.TYPE, Long.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.ASTORE, new ByteOperand((byte)local.getIndex()));
    }

    private ResultInfo compileWithoutIndex(Context context, MethodInfo method, Flags flags) {
        ArrayList<IInstructionListener> breakLoopListeners = new ArrayList<IInstructionListener>();
        flags = flags.withBreakLoopListeners(breakLoopListeners);
        IType itemType = this.source.check(context).checkIterator(context);
        Type itemClass = itemType.getJavaType(context);
        StackLocal iterLocal = this.compileIterator(context, method, flags);
        StackState iteratorState = method.captureStackState();
        OffsetListenerConstant test = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(test);
        method.addInstruction(Opcode.GOTO, test);
        OffsetListenerConstant loop = method.addOffsetListener(new OffsetListenerConstant(true));
        method.activateOffsetListener(loop);
        method.restoreFullStackState(iteratorState);
        method.placeLabel(iteratorState);
        CompilerUtils.compileALOAD(method, iterLocal);
        InterfaceConstant m = new InterfaceConstant((Type)((Object)Iterator.class), "next", new Type[]{Object.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, m);
        method.addInstruction(Opcode.CHECKCAST, new ClassConstant(itemClass));
        StackLocal v1Local = method.registerLocal(this.v1.toString(), IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(itemClass));
        method.addInstruction(Opcode.ASTORE, new ByteOperand((byte)v1Local.getIndex()));
        context = context.newChildContext();
        context.registerValue(new Variable(this.v1, itemType));
        this.statements.compile(context, method, flags);
        method.unregisterLocal(v1Local);
        method.addInstruction(Opcode.NOP, new IOperand[0]);
        method.inhibitOffsetListener(test);
        method.restoreFullStackState(iteratorState);
        method.placeLabel(iteratorState);
        CompilerUtils.compileALOAD(method, iterLocal);
        m = new InterfaceConstant((Type)((Object)Iterator.class), "hasNext", Boolean.TYPE);
        method.addInstruction(Opcode.INVOKEINTERFACE, m);
        method.inhibitOffsetListener(loop);
        method.addInstruction(Opcode.IFNE, loop);
        method.unregisterLocal(iterLocal);
        if (!breakLoopListeners.isEmpty()) {
            for (IInstructionListener listener : breakLoopListeners) {
                method.inhibitOffsetListener(listener);
            }
            method.restoreFullStackState(iteratorState);
            method.placeLabel(iteratorState);
        }
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    private StackLocal compileIterator(Context context, MethodInfo method, Flags flags) {
        this.source.compile(context, method, flags);
        InterfaceConstant m = new InterfaceConstant((Type)((Object)Iterable.class), "iterator", new Type[]{Iterator.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, m);
        String iterName = method.nextTransientName("iter");
        StackLocal iterLocal = method.registerLocal(iterName, IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)Iterator.class)));
        method.addInstruction(Opcode.ASTORE, new ByteOperand((byte)iterLocal.getIndex()), new ClassConstant((Type)((Object)Iterator.class)));
        return iterLocal;
    }

    @Override
    public void declare(Transpiler transpiler) {
        IType srcType = this.source.check(transpiler.getContext());
        if (srcType instanceof DictType) {
            transpiler.require("StrictSet");
        }
        IType elemType = srcType.checkIterator(transpiler.getContext());
        this.source.declare(transpiler);
        transpiler = transpiler.newChildTranspiler(null);
        if (this.v2 != null) {
            transpiler.getContext().registerValue(new Variable(this.v1, IntegerType.instance()));
            transpiler.getContext().registerValue(new Variable(this.v2, elemType));
        } else {
            transpiler.getContext().registerValue(new Variable(this.v1, elemType));
        }
        this.statements.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        if (this.v2 != null) {
            this.transpileWithIndex(transpiler);
        } else {
            this.transpileNoIndex(transpiler);
        }
        return true;
    }

    private void transpileNoIndex(Transpiler transpiler) {
        IType srcType = this.source.check(transpiler.getContext());
        if (srcType instanceof ListType) {
            this.transpileArrayNoIndex(transpiler);
        } else {
            this.transpileIteratorNoIndex(transpiler);
        }
    }

    private void transpileIteratorNoIndex(Transpiler transpiler) {
        IType srcType = this.source.check(transpiler.getContext());
        IType elemType = srcType.checkIterator(transpiler.getContext());
        String iterName = "$" + this.v1 + "_iterator";
        transpiler.append("var ").append(iterName).append(" = ");
        this.source.transpile(transpiler);
        transpiler.append(".iterator();");
        transpiler.newLine();
        transpiler.append("while(").append(iterName).append(".hasNext()) {");
        Transpiler child = transpiler.newChildTranspiler(null);
        child.indent();
        child.getContext().registerValue(new Variable(this.v1, elemType));
        child.append("var ").append(this.v1.toString()).append(" = ").append(iterName).append(".next();");
        child.newLine();
        this.statements.transpile(child);
        child.dedent();
        child.flush();
        transpiler.append("}");
        transpiler.newLine();
    }

    private void transpileArrayNoIndex(Transpiler transpiler) {
        IType srcType = this.source.check(transpiler.getContext());
        IType elemType = srcType.checkIterator(transpiler.getContext());
        String itemsName = "$" + this.v1 + "_items";
        transpiler.append("var ").append(itemsName).append(" = ");
        this.source.transpile(transpiler);
        transpiler.append(";").newLine();
        String idxName = "$" + this.v1 + "_idx";
        transpiler.append("for(var ").append(idxName).append(" = 0; ").append(idxName).append(" < ").append(itemsName).append(".length; ").append(idxName).append("++) {");
        Transpiler child = transpiler.newChildTranspiler(null);
        child.indent();
        child.getContext().registerValue(new Variable(this.v1, elemType));
        child.append("var ").append(this.v1.toString()).append(" = ").append(itemsName).append("[").append(idxName).append("];").newLine();
        this.statements.transpile(child);
        child.dedent();
        child.flush();
        transpiler.append("}");
        transpiler.newLine();
    }

    private void transpileWithIndex(Transpiler transpiler) {
        IType srcType = this.source.check(transpiler.getContext());
        if (srcType instanceof ListType) {
            this.transpileArrayWithIndex(transpiler);
        } else {
            this.transpileIteratorWithIndex(transpiler);
        }
    }

    private void transpileIteratorWithIndex(Transpiler transpiler) {
        IType srcType = this.source.check(transpiler.getContext());
        IType elemType = srcType.checkIterator(transpiler.getContext());
        transpiler.append("var ").append(this.v1.toString()).append(" = 1;").newLine();
        String iterName = "$" + this.v2 + "_iterator";
        transpiler.append("var ").append(iterName).append(" = ");
        this.source.transpile(transpiler);
        transpiler.append(".iterator();");
        transpiler.newLine();
        transpiler.append("while(").append(iterName).append(".hasNext()) {");
        Transpiler child = transpiler.newChildTranspiler(null);
        child.indent();
        child.getContext().registerValue(new Variable(this.v1, IntegerType.instance()));
        child.getContext().registerValue(new Variable(this.v2, elemType));
        child.append("var ").append(this.v2.toString()).append(" = ").append(iterName).append(".next();").newLine();
        this.statements.transpile(child);
        child.append(this.v1.toString()).append("++;").newLine();
        child.dedent();
        child.flush();
        transpiler.append("}");
        transpiler.newLine();
    }

    private void transpileArrayWithIndex(Transpiler transpiler) {
        IType srcType = this.source.check(transpiler.getContext());
        IType elemType = srcType.checkIterator(transpiler.getContext());
        String itemsName = "$" + this.v2 + "_items";
        transpiler.append("var ").append(itemsName).append(" = ");
        this.source.transpile(transpiler);
        transpiler.append(";").newLine();
        transpiler.append("for(var ").append(this.v1.toString()).append(" = 1; ").append(this.v1.toString()).append(" <= ").append(itemsName).append(".length; ").append(this.v1.toString()).append("++) {");
        Transpiler child = transpiler.newChildTranspiler(null);
        child.indent();
        child.getContext().registerValue(new Variable(this.v1, IntegerType.instance()));
        child.getContext().registerValue(new Variable(this.v2, elemType));
        child.append("var ").append(this.v2.toString()).append(" = ").append(itemsName).append("[").append(this.v1.toString()).append("-1];").newLine();
        this.statements.transpile(child);
        child.dedent();
        child.flush();
        transpiler.append("}");
        transpiler.newLine();
    }
}

