/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.declaration.AbstractMethodDeclaration;
import prompto.declaration.ArrowDeclaration;
import prompto.declaration.BuiltInMethodDeclaration;
import prompto.declaration.ClosureDeclaration;
import prompto.declaration.ConcreteMethodDeclaration;
import prompto.declaration.DispatchMethodDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.NativeMethodDeclaration;
import prompto.declaration.TestMethodDeclaration;
import prompto.error.NotMutableError;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IAssertion;
import prompto.expression.IExpression;
import prompto.expression.MethodSelector;
import prompto.expression.ThisExpression;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.grammar.Specificity;
import prompto.javascript.JavaScriptNativeCall;
import prompto.param.CodeParameter;
import prompto.param.IParameter;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.runtime.MethodFinder;
import prompto.statement.SimpleStatement;
import prompto.transpiler.Transpiler;
import prompto.type.CodeType;
import prompto.type.IType;
import prompto.type.PropertiesType;
import prompto.utils.CodeWriter;
import prompto.value.ArrowValue;
import prompto.value.BooleanValue;
import prompto.value.ClosureValue;
import prompto.value.IValue;

public class MethodCall
extends SimpleStatement
implements IAssertion {
    MethodSelector selector;
    MethodSelector fullSelector;
    ArgumentList arguments;
    String variableName;
    DispatchMethodDeclaration dispatcher;
    static AtomicLong fullDeclareCounter = new AtomicLong();

    public MethodCall(MethodSelector selector) {
        this.selector = selector;
    }

    public MethodCall(MethodSelector method, ArgumentList arguments) {
        this.selector = method;
        this.arguments = arguments;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public MethodSelector getSelector() {
        return this.selector;
    }

    public ArgumentList getArguments() {
        return this.arguments;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.requiresInvoke(writer)) {
            writer.append("invoke: ");
        }
        this.selector.toDialect(writer);
        if (this.arguments != null) {
            this.arguments.toDialect(writer);
        } else if (writer.getDialect() != Dialect.E) {
            writer.append("()");
        }
    }

    private boolean requiresInvoke(CodeWriter writer) {
        if (writer.getDialect() != Dialect.E || this.arguments != null && !this.arguments.isEmpty()) {
            return false;
        }
        try {
            MethodFinder finder = new MethodFinder(writer.getContext(), this);
            IMethodDeclaration declaration = finder.findBestMethod(false);
            return declaration instanceof AbstractMethodDeclaration || declaration.getClosureOf() != null;
        }
        catch (SyntaxError e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.selector.toString());
        sb.append('(');
        if (this.arguments != null && this.arguments.size() > 0) {
            this.arguments.forEach(ass -> {
                sb.append(ass.toString());
                sb.append(", ");
            });
            sb.setLength(sb.length() - 2);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public IType check(Context context) {
        return this.check(context, false);
    }

    public IType check(Context context, boolean updateSelectorParent) {
        MethodFinder finder = new MethodFinder(context, this);
        IMethodDeclaration declaration = finder.findBestMethod(false);
        if (declaration == null) {
            return null;
        }
        if (updateSelectorParent && declaration.getMemberOf() != null && this.selector.getParent() == null) {
            this.selector.setParent(new ThisExpression());
        }
        Context local = this.isLocalClosure(context) ? context : this.selector.newLocalCheckContext(context, declaration);
        return this.check(declaration, context, local);
    }

    private boolean isLocalClosure(Context context) {
        if (this.selector.getParent() != null) {
            return false;
        }
        IDeclaration decl = context.getLocalDeclaration(IDeclaration.class, this.selector.getId());
        return decl instanceof Context.MethodDeclarationMap;
    }

    private IType check(IMethodDeclaration declaration, Context parent, Context local) {
        if (declaration.isTemplate()) {
            return this.fullCheck((ConcreteMethodDeclaration)declaration, parent, local);
        }
        return this.lightCheck(declaration, parent, local);
    }

    private IType lightCheck(IMethodDeclaration declaration, Context parent, Context local) {
        declaration.registerParameters(local);
        return declaration.check(local, false);
    }

    private IType fullCheck(ConcreteMethodDeclaration declaration, Context parent, Context local) {
        try {
            ArgumentList arguments = this.makeArguments(parent, declaration);
            declaration.registerParameters(local);
            for (Argument argument : arguments) {
                IExpression expression = argument.resolve(local, declaration, true, false);
                IValue value = argument.getParameter().checkValue(parent, expression);
                local.setValue(argument.getParameterId(), value);
            }
            return declaration.check(local, false);
        }
        catch (PromptoError e) {
            throw new SyntaxError(e.getMessage());
        }
    }

    public ArgumentList makeArguments(Context context, IMethodDeclaration declaration) {
        ArgumentList arguments = this.arguments != null ? this.arguments : new ArgumentList();
        return arguments.makeArguments(context, declaration);
    }

    public ArgumentList makeCodeAssignments(Context context, IMethodDeclaration declaration) {
        if (this.arguments == null) {
            return new ArgumentList();
        }
        ArgumentList list = new ArgumentList();
        list.addAll(this.arguments.stream().filter(a -> a.getExpression().check(context) == CodeType.instance()).collect(Collectors.toList()));
        return list.resolveAndCheck(context, declaration);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        MethodFinder finder = new MethodFinder(context, this);
        List<IMethodDeclaration> declarations = finder.findPotentialMethods();
        switch (declarations.size()) {
            case 0: {
                throw new SyntaxError("No matching prototype for:" + this.toString());
            }
            case 1: {
                return this.compileExact(context, method, flags, (IMethodDeclaration)declarations.iterator().next());
            }
        }
        return this.compileDynamic(context, method, flags, finder.findLessSpecific(declarations));
    }

    private ResultInfo compileDynamic(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration) {
        Context local = this.selector.newLocalCheckContext(context, declaration);
        declaration.registerParameters(local);
        ArgumentList arguments = this.arguments != null ? this.arguments : new ArgumentList();
        return this.selector.compileDynamic(local, method, flags, declaration, arguments);
    }

    private ResultInfo compileExact(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration) {
        if (declaration.isTemplate()) {
            return this.compileTemplate(context, method, flags, declaration);
        }
        return this.compileConcrete(context, method, flags, declaration);
    }

    private ResultInfo compileConcrete(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration) {
        Context local = this.isLocalClosure(context) ? context : this.selector.newLocalCheckContext(context, declaration);
        declaration.registerParameters(local);
        ArgumentList arguments = this.arguments != null ? this.arguments : new ArgumentList();
        return this.selector.compileExact(local, method, flags, declaration, arguments);
    }

    private ResultInfo compileTemplate(Context context, MethodInfo method, Flags flags, IMethodDeclaration declaration) {
        Context local = context.newLocalContext();
        declaration.registerParameters(local);
        this.registerCodeAssignments(context, local, declaration);
        String methodName = declaration.compileTemplate(local, false, method.getClassFile());
        ThisExpression parent = method.isStatic() ? null : new ThisExpression();
        MethodSelector selector = new MethodSelector(parent, new Identifier(methodName));
        local = selector.newLocalContext(context, declaration);
        declaration.registerParameters(local);
        this.registerCodeAssignments(context, local, declaration);
        ArgumentList arguments = this.arguments != null ? this.arguments : new ArgumentList();
        return selector.compileTemplate(local, method, flags, declaration, arguments, methodName);
    }

    private void registerCodeAssignments(Context context, Context local, IMethodDeclaration declaration) {
        ArgumentList arguments = this.makeCodeAssignments(context, declaration);
        for (Argument argument : arguments) {
            IExpression expression = argument.resolve(local, declaration, true, false);
            IParameter parameter = argument.getParameter();
            IValue value = parameter.checkValue(context, expression);
            local.setValue(argument.getParameterId(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue interpret(Context context) throws PromptoError {
        IMethodDeclaration declaration = this.findDeclaration(context, true);
        Context local = this.selector.newLocalContext(context, declaration);
        local.enterMethod(declaration);
        try {
            declaration.registerParameters(local);
            this.registerArguments(context, local, declaration);
            IValue iValue = declaration.interpret(local);
            return iValue;
        }
        finally {
            local.leaveSection(declaration);
        }
    }

    private void registerArguments(Context context, Context local, IMethodDeclaration declaration) throws PromptoError {
        ArgumentList arguments = this.makeArguments(context, declaration);
        for (Argument argument : arguments) {
            IExpression expression = argument.resolve(local, declaration, true, false);
            IParameter parameter = argument.getParameter();
            IValue value = parameter.checkValue(context, expression);
            if (value != null && parameter.isMutable() & !value.isMutable()) {
                throw new NotMutableError();
            }
            local.setValue(argument.getParameterId(), value);
        }
    }

    @Override
    public boolean interpretAssert(Context context, TestMethodDeclaration test) throws PromptoError {
        IValue value = this.interpret(context);
        if (value instanceof BooleanValue) {
            if (((BooleanValue)value).getValue()) {
                return true;
            }
            String expected = this.buildExpectedMessage(context, test);
            String actual = value.toString();
            test.printFailedAssertion(context, expected, actual);
            return false;
        }
        CodeWriter writer = new CodeWriter(this.getDialect(), context);
        this.toDialect(writer);
        throw new SyntaxError("Cannot test '" + writer.toString() + "'");
    }

    private String buildExpectedMessage(Context context, TestMethodDeclaration test) {
        CodeWriter writer = new CodeWriter(test.getDialect(), context);
        this.toDialect(writer);
        return writer.toString();
    }

    @Override
    public void compileAssert(Context context, MethodInfo method, Flags flags, TestMethodDeclaration test) {
        StackState finalState = method.captureStackState();
        ResultInfo info = this.compile(context, method, flags.withPrimitive(true));
        if (Boolean.class == info.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        OffsetListenerConstant finalListener = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(finalListener);
        method.addInstruction(Opcode.IFNE, finalListener);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        method.addInstruction(Opcode.IADD, new IOperand[0]);
        String message = this.buildExpectedMessage(context, test);
        message = test.buildFailedAssertionMessagePrefix(message);
        method.addInstruction(Opcode.LDC, new StringConstant(message));
        method.addInstruction(Opcode.LDC, new StringConstant(BooleanValue.FALSE.toString()));
        MethodConstant concat = new MethodConstant((Type)((Object)String.class), "concat", new Type[]{String.class, String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        test.compileFailure(context, method, flags);
        method.restoreFullStackState(finalState);
        method.placeLabel(finalState);
        method.inhibitOffsetListener(finalListener);
    }

    IMethodDeclaration findDeclaration(Context context, boolean checkInstance) {
        IMethodDeclaration method = this.findRegistered(context);
        if (method != null) {
            return method;
        }
        MethodFinder finder = new MethodFinder(context, this);
        return finder.findBestMethod(checkInstance);
    }

    private IMethodDeclaration findRegistered(Context context) {
        if (this.selector.getParent() == null) {
            try {
                IValue o = context.getValue(this.selector.getId());
                if (o instanceof ClosureValue) {
                    return new ClosureDeclaration((ClosureValue)o);
                }
                if (o instanceof ArrowValue) {
                    return new ArrowDeclaration((ArrowValue)o);
                }
            }
            catch (PromptoError promptoError) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void declare(Transpiler transpiler) {
        Context context = transpiler.getContext();
        MethodFinder finder = new MethodFinder(context, this);
        Set<IMethodDeclaration> declarations = finder.findCompatibleMethods(false, true, spec -> spec != Specificity.INCOMPATIBLE);
        if (declarations.size() == 1 && declarations.iterator().next() instanceof BuiltInMethodDeclaration) {
            ((BuiltInMethodDeclaration)declarations.iterator().next()).declareCall(transpiler);
        } else {
            if (!this.isLocalClosure(context)) {
                declarations.forEach(declaration -> {
                    Context local = this.selector.newLocalCheckContext(transpiler.getContext(), (IMethodDeclaration)declaration);
                    this.declareDeclaration(transpiler, (IMethodDeclaration)declaration, local);
                });
            }
            if (declarations.size() > 1 && this.dispatcher == null) {
                IMethodDeclaration declaration2 = finder.findBestMethod(false);
                List<IMethodDeclaration> sorted = finder.sortMostSpecificFirst(declarations);
                this.dispatcher = new DispatchMethodDeclaration(transpiler.getContext(), this, declaration2, sorted);
                transpiler.declare(this.dispatcher);
            }
        }
    }

    private void declareDeclaration(Transpiler transpiler, IMethodDeclaration declaration, Context local) {
        if (this.arguments != null) {
            this.arguments.declare(transpiler, declaration);
        }
        if (declaration.isTemplate()) {
            this.fullDeclareDeclaration(declaration, transpiler, local);
        } else {
            this.lightDeclareDeclaration(declaration, transpiler, local);
        }
    }

    private void fullDeclareDeclaration(IMethodDeclaration declaration, Transpiler transpiler, Context local) {
        if (this.fullSelector == null) {
            ArgumentList arguments = this.makeArguments(transpiler.getContext(), declaration);
            declaration.registerParameters(local);
            arguments.forEach(argument -> {
                IExpression expression = argument.resolve(local, declaration, true, false);
                IValue value = argument.getParameter().checkValue(transpiler.getContext(), expression);
                local.setValue(argument.getParameter().getId(), value);
            });
            Transpiler localTranspiler = transpiler.copyTranspiler(local);
            this.fullSelector = this.selector.newFullSelector(fullDeclareCounter.incrementAndGet());
            declaration.fullDeclare(localTranspiler, this.fullSelector.getId());
        }
    }

    private void lightDeclareDeclaration(IMethodDeclaration declaration, Transpiler transpiler, Context local) {
        transpiler = transpiler.copyTranspiler(local);
        declaration.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        MethodFinder finder = new MethodFinder(transpiler.getContext(), this);
        Set<IMethodDeclaration> declarations = finder.findCompatibleMethods(false, true, spec -> spec != Specificity.INCOMPATIBLE);
        if (declarations == null || declarations.isEmpty()) {
            transpiler.getContext().getProblemListener().reportUnknownMethod(this, this.toString());
        } else if (declarations.size() == 1) {
            this.transpileSingle(transpiler, declarations.iterator().next(), false);
        } else {
            this.transpileMultiple(transpiler, declarations);
        }
        return false;
    }

    private void transpileSingle(Transpiler transpiler, IMethodDeclaration declaration, boolean allowDerived) {
        if (declaration instanceof BuiltInMethodDeclaration) {
            this.transpileBuiltin(transpiler, (BuiltInMethodDeclaration)declaration);
        } else {
            if (declaration.hasAnnotation(transpiler.getContext(), "Inlined")) {
                throw new UnsupportedOperationException("Yet!");
            }
            if (declaration.containerHasAnnotation(transpiler.getContext(), "Inlined")) {
                this.transpileInlinedMemberMethod(transpiler, declaration);
            } else {
                this.transpileSelector(transpiler, declaration);
                this.transpileArguments(transpiler, declaration, allowDerived);
            }
        }
    }

    private void transpileInlinedMemberMethod(Transpiler transpiler, IMethodDeclaration declaration) {
        if (!(declaration instanceof NativeMethodDeclaration)) {
            throw new UnsupportedOperationException("Can only inline native methods!");
        }
        this.transpileInlinedMemberMethod(transpiler, (NativeMethodDeclaration)declaration);
    }

    private void transpileInlinedMemberMethod(Transpiler transpiler, NativeMethodDeclaration declaration) {
        JavaScriptNativeCall call = declaration.findCall(JavaScriptNativeCall.class);
        if (call == null) {
            throw new UnsupportedOperationException("Missing native JavaScript call!");
        }
        call.transpileInlineMethodCall(transpiler, declaration, this);
    }

    private void transpileArguments(Transpiler transpiler, IMethodDeclaration declaration, boolean allowDerived) {
        ArgumentList arguments = this.makeArguments(transpiler.getContext(), declaration);
        this.transpileArguments(transpiler, arguments, declaration, allowDerived);
    }

    public void transpileArguments(Transpiler transpiler, List<Argument> arguments, IMethodDeclaration declaration, boolean allowDerived) {
        if (!(arguments = arguments.stream().filter(argument -> !(argument.getParameter() instanceof CodeParameter)).collect(Collectors.toList())).isEmpty()) {
            transpiler.append("(");
            arguments.forEach(argument -> {
                IParameter parameter = argument.getParameter();
                IExpression expression = argument.resolve(transpiler.getContext(), declaration, false, allowDerived);
                parameter.transpileCall(transpiler, expression);
                transpiler.append(", ");
            });
            transpiler.trimLast(2);
            transpiler.append(")");
        } else {
            transpiler.append("()");
        }
    }

    public void transpileSelector(Transpiler transpiler, IMethodDeclaration declaration) {
        MethodSelector selector = this.resolveSelector(transpiler, declaration);
        selector.transpile(transpiler);
    }

    public MethodSelector resolveSelector(Transpiler transpiler, IMethodDeclaration declaration) {
        MethodSelector selector = this.selector;
        IExpression parent = selector.resolveParent(transpiler.getContext());
        if (parent == null && declaration.getMemberOf() != null && transpiler.getContext().getClosestInstanceContext() != null) {
            parent = new ThisExpression();
        }
        String name = null;
        name = this.variableName != null ? this.variableName : (parent != null && parent.check(transpiler.getContext()) instanceof PropertiesType ? selector.getName() : declaration.getTranspiledName(transpiler.getContext()));
        return new MethodSelector(parent, new Identifier(name));
    }

    private void transpileBuiltin(Transpiler transpiler, BuiltInMethodDeclaration declaration) {
        IExpression parent = this.selector.resolveParent(transpiler.getContext());
        parent.transpileParent(transpiler);
        transpiler.append(".");
        declaration.transpileCall(transpiler, this.arguments);
    }

    private void transpileMultiple(Transpiler transpiler, Set<IMethodDeclaration> declarations) {
        String name = this.dispatcher.getTranspiledName(transpiler.getContext());
        IExpression parent = this.selector.resolveParent(transpiler.getContext());
        if (parent == null && declarations.iterator().next().getMemberOf() != null && transpiler.getContext().getClosestInstanceContext() != null) {
            parent = new ThisExpression();
        }
        MethodSelector selector = new MethodSelector(parent, new Identifier(name));
        selector.transpile(transpiler);
        this.transpileArguments(transpiler, this.dispatcher, false);
    }
}

