/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.instance.VariableInstance;
import prompto.param.IParameter;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.runtime.VoidResult;
import prompto.statement.AssignInstanceStatement;
import prompto.statement.MethodCall;
import prompto.statement.StatementList;
import prompto.statement.UnresolvedCall;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class RemoteCall
extends UnresolvedCall {
    Identifier resultName;
    StatementList andThen;

    public RemoteCall(UnresolvedCall call, Identifier resultName, StatementList andThen) {
        this(call.caller, call.arguments, resultName, andThen);
    }

    public RemoteCall(IExpression caller, ArgumentList assignments, Identifier resultName, StatementList andThen) {
        super(caller, assignments);
        this.resultName = resultName;
        this.andThen = andThen;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        super.toDialect(writer);
        writer.append(" then");
        if (this.resultName != null) {
            writer.append(" with ").append(this.resultName.toString());
        }
        if (writer.getDialect() == Dialect.O) {
            writer.append(" {");
        } else {
            writer.append(":");
        }
        writer = writer.newLine().indent();
        this.andThen.toDialect(writer);
        writer.dedent();
        if (writer.getDialect() == Dialect.O) {
            writer.append("}");
        }
    }

    @Override
    public IType check(Context context) {
        IType type = this.resolveAndCheck(context);
        if (!(this.resolved instanceof MethodCall)) {
            context.getProblemListener().reportIllegalRemoteCall(this, this.resolved.toString());
        }
        context = context.newChildContext();
        if (this.resultName != null) {
            context.registerValue(new Variable(this.resultName, type));
        }
        this.andThen.check(context, VoidType.instance());
        return VoidType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IType type = this.resolveAndCheck(context);
        IValue result = this.resolved.interpret(context);
        context = context.newChildContext();
        if (this.resultName != null) {
            context.registerValue(new Variable(this.resultName, type));
            context.setValue(this.resultName, result);
        }
        this.andThen.interpret(context);
        return VoidResult.instance();
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        this.resolveAndCheck(context);
        if (this.resultName != null) {
            AssignInstanceStatement assign = new AssignInstanceStatement(new VariableInstance(this.resultName), new UnresolvedCall(this.caller, this.arguments));
            assign.compile(context, method, flags);
        } else {
            ResultInfo result = this.resolved.compile(context, method, flags);
            if (result.getType() != Void.TYPE) {
                method.addInstruction(Opcode.POP, new IOperand[0]);
            }
        }
        this.andThen.compile(context, method, flags);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        if (transpiler.getEngine().isTestEngine()) {
            super.declare(transpiler);
        } else {
            transpiler.require("Remote");
        }
        transpiler.require("RemoteRunner");
        transpiler = transpiler.newChildTranspiler(null);
        if (this.resultName != null) {
            IType type = this.resolveAndCheck(transpiler.getContext());
            type.declare(transpiler);
            transpiler.getContext().registerValue(new Variable(this.resultName, type));
        }
        this.andThen.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        this.resolveAndCheck(transpiler.getContext());
        if (!(this.resolved instanceof MethodCall)) {
            transpiler.getContext().getProblemListener().reportIllegalRemoteCall(this, this.resolved.toString());
        } else if (transpiler.getEngine().isTestEngine()) {
            this.transpileTest(transpiler);
        } else {
            this.transpileRemote(transpiler);
        }
        return false;
    }

    private void transpileTest(Transpiler transpiler) {
        transpiler = transpiler.append("RemoteRunner.run(function() {").indent().append("return ");
        this.resolved.transpile(transpiler);
        transpiler.dedent().append("}, function(");
        if (this.resultName != null) {
            transpiler.append(this.resultName.toString());
        }
        transpiler.append(") {").indent();
        transpiler = transpiler.newChildTranspiler(null);
        if (this.resultName != null) {
            IType type = this.resolveAndCheck(transpiler.getContext());
            transpiler.getContext().registerValue(new Variable(this.resultName, type));
        }
        this.andThen.transpile(transpiler);
        transpiler.dedent().append("}, this)").flush();
    }

    private void transpileRemote(Transpiler transpiler) {
        MethodCall call = (MethodCall)this.resolved;
        transpiler.append("RemoteRunner.run('").append(call.getSelector().toString()).append("', ");
        this.transpileAssignments(transpiler, call);
        transpiler.append(", function(");
        if (this.resultName != null) {
            transpiler.append(this.resultName.toString());
        }
        transpiler.append(") {").indent();
        transpiler = transpiler.newChildTranspiler(null);
        if (this.resultName != null) {
            IType type = this.resolveAndCheck(transpiler.getContext());
            transpiler.getContext().registerValue(new Variable(this.resultName, type));
        }
        this.andThen.transpile(transpiler);
        transpiler.dedent().append("}, this)").flush();
    }

    private void transpileAssignments(Transpiler transpiler, MethodCall call) {
        transpiler.append("[");
        ArgumentList assigns = call.getArguments();
        if (assigns != null && !assigns.isEmpty()) {
            IMethodDeclaration declaration = call.findDeclaration(transpiler.getContext(), false);
            assigns = assigns.makeArguments(transpiler.getContext(), declaration);
            assigns.forEach(assign -> {
                this.transpileAssignment(transpiler, (Argument)assign, declaration);
                transpiler.append(",");
            });
            transpiler.trimLast(1);
        }
        transpiler.append("]");
    }

    private void transpileAssignment(Transpiler transpiler, Argument assign, IMethodDeclaration declaration) {
        Context ctx = transpiler.getContext();
        IParameter argument = assign.getParameter();
        IExpression expression = assign.resolve(ctx, declaration, false, false);
        transpiler.append("{name:'").append(argument.getName()).append("',type:'").append(argument.getType(ctx).toString()).append("',value:");
        argument.transpileCall(transpiler, expression);
        transpiler.append("}");
    }
}

