/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.lang.reflect.Type;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.FieldConstant;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.compiler.StringConstant;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.intrinsic.PromptoRoot;
import prompto.runtime.Context;
import prompto.runtime.VoidResult;
import prompto.statement.SimpleStatement;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;
import prompto.value.NullValue;

public class ReturnStatement
extends SimpleStatement {
    IExpression expression;

    public ReturnStatement(IExpression expression) {
        this.expression = expression;
    }

    public IExpression getExpression() {
        return this.expression;
    }

    @Override
    public boolean canReturn() {
        return true;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append("return");
        if (this.expression != null) {
            writer.append(" ");
            this.expression.toDialect(writer);
        }
    }

    public String toString() {
        return "return " + (this.expression == null ? "" : this.expression.toString());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReturnStatement)) {
            return false;
        }
        ReturnStatement other = (ReturnStatement)obj;
        return this.getExpression().equals(other.getExpression());
    }

    @Override
    public IType check(Context context) {
        return this.expression == null ? VoidType.instance() : this.expression.check(context);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        if (this.expression == null) {
            return VoidResult.instance();
        }
        IValue value = this.expression.interpret(context);
        return value == null ? NullValue.instance() : value;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        if (flags.setter() != null) {
            return this.compileSetter(context, method, flags);
        }
        if (flags.variable() != null) {
            return this.compileVariable(context, method, flags);
        }
        return this.compileReturn(context, method, flags);
    }

    private ResultInfo compileVariable(Context context, MethodInfo method, Flags flags) {
        String name = flags.variable();
        if (this.expression != null) {
            ResultInfo info = this.expression.compile(context, method, flags.withPrimitive(false));
            StackLocal result = method.registerLocal(name, IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(info.getType()));
            CompilerUtils.compileASTORE(method, result);
        }
        return new ResultInfo(Void.TYPE, ResultInfo.Flag.RETURN);
    }

    private ResultInfo compileSetter(Context context, MethodInfo method, Flags flags) {
        FieldInfo field = flags.setter();
        StackLocal local = method.getRegisteredLocal("this");
        ClassConstant c = ((StackLocal.ObjectLocal)local).getClassName();
        method.addInstruction(Opcode.ALOAD_0, c);
        this.expression.compile(context, method, flags);
        String name = field.getName().getValue();
        FieldConstant f = new FieldConstant(c, name, field.getType());
        method.addInstruction(Opcode.PUTFIELD, f);
        MethodConstant m = new MethodConstant((Type)((Object)PromptoRoot.class), "setStorable", new Type[]{String.class, Object.class, Void.TYPE});
        method.addInstruction(Opcode.ALOAD_0, c);
        method.addInstruction(Opcode.LDC, new StringConstant(name));
        method.addInstruction(Opcode.ALOAD_1, new ClassConstant((Type)((Object)Object.class)));
        method.addInstruction(Opcode.INVOKESPECIAL, m);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
        return new ResultInfo(Void.TYPE, ResultInfo.Flag.RETURN);
    }

    private ResultInfo compileReturn(Context context, MethodInfo method, Flags flags) {
        if (this.expression == null) {
            method.addInstruction(Opcode.RETURN, new IOperand[0]);
            return new ResultInfo(Void.TYPE, ResultInfo.Flag.RETURN);
        }
        ResultInfo info = this.expression.compile(context, method, flags);
        return this.compileReturn(context, method, flags, info);
    }

    private ResultInfo compileReturn(Context context, MethodInfo method, Flags flags, ResultInfo info) {
        if (flags.toReturnType() != null) {
            return this.compileReturnType(context, method, flags, info);
        }
        if (flags.toPrimitive()) {
            return this.compileReturnPrimitive(context, method, flags, info);
        }
        return this.compileReturnInstance(context, method, flags, info);
    }

    private ResultInfo compileReturnType(Context context, MethodInfo method, Flags flags, ResultInfo info) {
        if (flags.toReturnType() == Integer.TYPE && info.getType() != Integer.TYPE) {
            if (info.getType() == Long.class) {
                CompilerUtils.LongToint(method);
            } else if (info.getType() == Long.TYPE) {
                CompilerUtils.longToint(method);
            } else {
                throw new UnsupportedOperationException();
            }
            flags = flags.withReturnType(null).withPrimitive(true);
            info = new ResultInfo(Integer.TYPE, new ResultInfo.Flag[0]);
        }
        return this.compileReturn(context, method, flags, info);
    }

    private ResultInfo compileReturnPrimitive(Context context, MethodInfo method, Flags flags, ResultInfo info) {
        if (Boolean.TYPE == info.getType()) {
            method.addInstruction(Opcode.IRETURN, new IOperand[0]);
            return new ResultInfo(info.getType(), ResultInfo.Flag.RETURN);
        }
        if (Integer.TYPE == info.getType()) {
            method.addInstruction(Opcode.IRETURN, new IOperand[0]);
            return new ResultInfo(info.getType(), ResultInfo.Flag.RETURN);
        }
        if (Character.TYPE == info.getType()) {
            method.addInstruction(Opcode.IRETURN, new IOperand[0]);
            return new ResultInfo(info.getType(), ResultInfo.Flag.RETURN);
        }
        if (Long.TYPE == info.getType()) {
            method.addInstruction(Opcode.LRETURN, new IOperand[0]);
            return new ResultInfo(info.getType(), ResultInfo.Flag.RETURN);
        }
        if (Double.TYPE == info.getType()) {
            method.addInstruction(Opcode.DRETURN, new IOperand[0]);
            return new ResultInfo(info.getType(), ResultInfo.Flag.RETURN);
        }
        method.addInstruction(Opcode.ARETURN, new IOperand[0]);
        return new ResultInfo(info.getType(), ResultInfo.Flag.RETURN);
    }

    private ResultInfo compileReturnInstance(Context context, MethodInfo method, Flags flags, ResultInfo info) {
        if (Boolean.TYPE == info.getType()) {
            info = CompilerUtils.booleanToBoolean(method);
        } else if (Integer.TYPE == info.getType()) {
            info = CompilerUtils.intTolong(method);
        } else if (Character.TYPE == info.getType()) {
            info = CompilerUtils.charToCharacter(method);
        } else if (Long.TYPE == info.getType()) {
            info = CompilerUtils.longToLong(method);
        } else if (Double.TYPE == info.getType()) {
            info = CompilerUtils.doubleToDouble(method);
        }
        method.addInstruction(Opcode.ARETURN, new IOperand[0]);
        return new ResultInfo(info.getType(), ResultInfo.Flag.RETURN);
    }

    @Override
    public void declare(Transpiler transpiler) {
        if (this.expression != null) {
            this.expression.declare(transpiler);
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("return");
        if (this.expression != null) {
            transpiler.append(" ");
            this.expression.transpile(transpiler);
        }
        return false;
    }
}

