/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.util.LinkedList;
import java.util.Objects;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocals;
import prompto.error.PromptoError;
import prompto.java.JavaNativeCall;
import prompto.parser.Dialect;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.statement.CommentStatement;
import prompto.statement.IStatement;
import prompto.statement.NativeCall;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.TypeMap;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class StatementList
extends LinkedList<IStatement> {
    private static final long serialVersionUID = 1L;

    public StatementList() {
    }

    public StatementList(IStatement stmt) {
        this.add(stmt);
    }

    public ISection locateSection(ISection section) {
        return this.stream().map(s -> s.locateSection(section)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public boolean add(IStatement stmt) {
        if (stmt != null) {
            return super.add(stmt);
        }
        return false;
    }

    public IType check(Context context, IType returnType) {
        if (returnType == VoidType.instance()) {
            for (IStatement statement : this) {
                IType type = statement.check(context);
                if (type == null || type == VoidType.instance()) continue;
                context.getProblemListener().reportIllegalReturn(statement);
            }
            return returnType;
        }
        TypeMap types = new TypeMap();
        if (returnType != null) {
            types.put(returnType.getTypeNameId(), returnType);
        }
        for (IStatement statement : this) {
            IType type = statement.check(context);
            if (!statement.canReturn()) {
                type = VoidType.instance();
            }
            if (type == null || type == VoidType.instance()) continue;
            types.put(type.getTypeNameId(), type);
        }
        IType type = types.inferType(context);
        if (returnType != null) {
            return returnType;
        }
        return type;
    }

    public IType checkNative(Context context, IType returnType) {
        if (returnType == VoidType.instance()) {
            for (IStatement statement : this) {
                if (!(statement instanceof JavaNativeCall)) continue;
                IType type = ((JavaNativeCall)statement).checkNative(context, returnType);
                if (type == null) {
                    type = returnType;
                }
                if (type == VoidType.instance()) continue;
                context.getProblemListener().reportIllegalReturn(statement);
            }
            return returnType;
        }
        TypeMap types = new TypeMap();
        if (returnType != null) {
            types.put(returnType.getTypeNameId(), returnType);
        }
        for (IStatement statement : this) {
            if (!(statement instanceof JavaNativeCall)) continue;
            IType type = ((JavaNativeCall)statement).checkNative(context, returnType);
            if (type == null) {
                type = returnType;
            }
            if (type == VoidType.instance()) continue;
            types.put(type.getTypeNameId(), type);
        }
        IType type = types.inferType(context);
        if (returnType != null) {
            return returnType;
        }
        return type;
    }

    public IValue interpret(Context context) throws PromptoError {
        return this.doInterpret(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IValue doInterpret(Context context) throws PromptoError {
        for (IStatement statement : this) {
            if (statement instanceof CommentStatement) continue;
            context.enterStatement(statement);
            try {
                IValue result = statement.interpret(context);
                if (result == null || !statement.canReturn()) continue;
                IValue iValue = result;
                return iValue;
            }
            finally {
                context.leaveStatement(statement);
            }
        }
        return null;
    }

    public void toDialect(CodeWriter writer) {
        if (this.isEmpty()) {
            switch (writer.getDialect()) {
                case E: 
                case M: {
                    writer.append("pass").newLine();
                }
            }
        } else {
            for (IStatement statement : this) {
                statement.toDialect(writer);
                if (!statement.isSimple()) continue;
                if (writer.getDialect() == Dialect.O && !(statement instanceof NativeCall)) {
                    writer.append(';');
                }
                writer.newLine();
            }
        }
    }

    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        if (this.size() > 0) {
            ResultInfo info = new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
            StackLocals state = method.captureStackLocals();
            for (IStatement statement : this) {
                info = statement.compile(context, method, flags);
                if (info.getType() == Void.TYPE || info.isReturn()) continue;
                method.addInstruction(Opcode.POP, new IOperand[0]);
                info = new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
            }
            method.restoreStackLocals(state);
            return info;
        }
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    public void declare(Transpiler transpiler) {
        this.forEach(stmt -> stmt.declare(transpiler));
    }

    public void transpile(Transpiler transpiler) {
        this.forEach(stmt -> {
            boolean skip = stmt.transpile(transpiler);
            if (!skip) {
                transpiler.append(";").newLine();
            }
        });
    }
}

