/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.lang.reflect.Type;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.intrinsic.PromptoStoreQuery;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.statement.BaseStatement;
import prompto.statement.StatementList;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.IType;
import prompto.type.IterableType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.utils.ExpressionList;
import prompto.value.IValue;

public class StoreStatement
extends BaseStatement {
    ExpressionList deletables;
    ExpressionList storables;
    StatementList andThen;

    public StoreStatement(ExpressionList deletables, ExpressionList storables, StatementList andThen) {
        this.deletables = deletables;
        this.storables = storables;
        this.andThen = andThen;
    }

    @Override
    public boolean isSimple() {
        return this.andThen == null;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.deletables != null) {
            writer.append("delete ");
            if (writer.getDialect() == Dialect.E) {
                this.deletables.toDialect(writer);
            } else {
                writer.append('(');
                this.deletables.toDialect(writer);
                writer.append(')');
            }
            if (this.storables != null) {
                writer.append(" and ");
            }
        }
        if (this.storables != null) {
            writer.append("store ");
            if (writer.getDialect() == Dialect.E) {
                this.storables.toDialect(writer);
            } else {
                writer.append('(');
                this.storables.toDialect(writer);
                writer.append(')');
            }
        }
        if (this.andThen != null) {
            if (writer.getDialect() == Dialect.O) {
                writer.append(" then {").newLine().indent();
                this.andThen.toDialect(writer);
                writer.dedent().append("}");
            } else {
                writer.append(" then:").newLine().indent();
                this.andThen.toDialect(writer);
                writer.dedent();
            }
        }
    }

    public String toString() {
        return "store " + this.storables.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StoreStatement)) {
            return false;
        }
        StoreStatement other = (StoreStatement)obj;
        return this.storables.equals(other.storables);
    }

    @Override
    public IType check(Context context) {
        this.checkDeletables(context);
        this.checkStorables(context);
        this.checkFuture(context);
        return VoidType.instance();
    }

    private void checkDeletables(Context context) {
        if (this.deletables != null) {
            this.deletables.forEach(exp -> this.checkStorable(context, (IExpression)exp));
        }
    }

    private void checkStorables(Context context) {
        if (this.storables != null) {
            this.storables.forEach(exp -> this.checkStorable(context, (IExpression)exp));
        }
    }

    private void checkStorable(Context context, IExpression exp) {
        IType type = exp.check(context);
        if (type instanceof IterableType) {
            type = ((IterableType)type).getItemType();
        }
        if (type == AnyType.instance()) {
            return;
        }
        if (!type.isStorable(context)) {
            String name = exp.toString();
            if (name.contains(" ") || name.contains(",")) {
                name = type.getTypeName();
            }
            context.getProblemListener().reportNotStorable(this, name);
        }
    }

    private void checkFuture(Context context) {
        if (this.andThen != null) {
            context = context.newChildContext();
            this.andThen.check(context, VoidType.instance());
        }
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue value;
        PromptoStoreQuery query = new PromptoStoreQuery();
        if (this.deletables != null) {
            for (IExpression exp : this.deletables) {
                value = exp.interpret(context);
                query.delete(context, value);
            }
        }
        if (this.storables != null) {
            for (IExpression exp : this.storables) {
                value = exp.interpret(context);
                query.store(context, value);
            }
        }
        query.execute();
        if (this.andThen != null) {
            this.andThen.interpret(context);
        }
        return null;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        CompilerUtils.compileNewInstance(method, PromptoStoreQuery.class);
        this.compileObjectsToDelete(context, method, flags);
        this.compileStorablesToStore(context, method, flags);
        this.compileExecute(context, method, flags);
        if (this.andThen != null) {
            this.andThen.compile(context, method, flags);
        }
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    private void compileStorablesToStore(Context context, MethodInfo method, Flags flags) {
        if (this.storables != null) {
            MethodConstant m = new MethodConstant((Type)((Object)PromptoStoreQuery.class), "store", new Type[]{Object.class, Void.TYPE});
            for (IExpression exp : this.storables) {
                method.addInstruction(Opcode.DUP, new IOperand[0]);
                exp.compile(context, method, flags);
                method.addInstruction(Opcode.INVOKEVIRTUAL, m);
            }
        }
    }

    private void compileObjectsToDelete(Context context, MethodInfo method, Flags flags) {
        if (this.deletables != null) {
            MethodConstant m = new MethodConstant((Type)((Object)PromptoStoreQuery.class), "delete", new Type[]{Object.class, Void.TYPE});
            for (IExpression exp : this.deletables) {
                method.addInstruction(Opcode.DUP, new IOperand[0]);
                exp.compile(context, method, flags);
                method.addInstruction(Opcode.INVOKEVIRTUAL, m);
            }
        }
    }

    private void compileExecute(Context context, MethodInfo method, Flags flags) {
        MethodConstant m = new MethodConstant((Type)((Object)PromptoStoreQuery.class), "execute", Void.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
    }

    @Override
    public void declare(Transpiler transpiler) {
        if (!transpiler.getEngine().isTestEngine()) {
            transpiler.require("Remote");
        }
        transpiler.require("DataStore");
        if (this.andThen != null) {
            this.andThen.declare(transpiler);
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("$DataStore.instance.store").append(this.andThen == null ? "" : "Async").append("(");
        this.transpileIdsToDelete(transpiler);
        transpiler.append(", ");
        this.transpileStorablesToAdd(transpiler);
        if (this.andThen != null) {
            transpiler.append(", function() {").indent();
            this.andThen.transpile(transpiler);
            transpiler.dedent().append("}.bind(this)");
        }
        transpiler.append(")");
        return false;
    }

    private void transpileStorablesToAdd(Transpiler transpiler) {
        if (this.storables == null) {
            transpiler.append("null");
        } else {
            transpiler.append("(function() { ").indent();
            transpiler.append("var storablesToAdd = new Set();").newLine();
            this.storables.forEach(exp -> {
                exp.transpile(transpiler);
                transpiler.append(" && ");
                exp.transpile(transpiler);
                transpiler.append(".collectStorables(storablesToAdd);").newLine();
            });
            transpiler.append("return Array.from(storablesToAdd);").newLine();
            transpiler.dedent().append("})()");
        }
    }

    private void transpileIdsToDelete(Transpiler transpiler) {
        if (this.deletables == null) {
            transpiler.append("null");
        } else {
            transpiler.append("(function() { ").indent();
            transpiler.append("var idsToDelete = new Set();").newLine();
            this.deletables.forEach(exp -> {
                exp.transpile(transpiler);
                transpiler.append(" && ");
                exp.transpile(transpiler);
                transpiler.append(".collectDbIds(idsToDelete);").newLine();
            });
            transpiler.append("return Array.from(idsToDelete);").newLine();
            transpiler.dedent().append("})()");
        }
    }
}

