/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.parser.ISection;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.statement.StatementList;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public abstract class SwitchCase
extends Section
implements ISection {
    protected IExpression expression;
    StatementList statements;

    public SwitchCase(IExpression expression, StatementList statements) {
        this.expression = expression;
        this.statements = statements;
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public ISection locateSection(ISection section) {
        ISection result = this.statements.locateSection(section);
        return result != null ? result : (this.isOrContains(section) ? this : null);
    }

    public abstract void checkSwitchType(Context var1, IType var2);

    public IType checkReturnType(Context context) {
        return this.statements.check(context, null);
    }

    public abstract boolean matches(Context var1, IValue var2) throws PromptoError;

    public IValue interpret(Context context) throws PromptoError {
        return this.statements.interpret(context);
    }

    public abstract void caseToEDialect(CodeWriter var1);

    public abstract void caseToODialect(CodeWriter var1);

    public abstract void caseToPDialect(CodeWriter var1);

    public abstract void catchToEDialect(CodeWriter var1);

    public abstract void catchToODialect(CodeWriter var1);

    public abstract void catchToPDialect(CodeWriter var1);

    public void declare(Transpiler transpiler) {
        if (this.expression != null) {
            this.expression.declare(transpiler);
        }
        this.statements.declare(transpiler);
    }

    public abstract void transpile(Transpiler var1);

    public abstract void transpileError(Transpiler var1);
}

