/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.ExceptionHandler;
import prompto.compiler.FieldConstant;
import prompto.compiler.Flags;
import prompto.compiler.IInstructionListener;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.compiler.StackState;
import prompto.error.ExecutionError;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.expression.SymbolExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoException;
import prompto.literal.ListLiteral;
import prompto.runtime.Context;
import prompto.runtime.ErrorVariable;
import prompto.statement.AtomicSwitchCase;
import prompto.statement.BaseSwitchStatement;
import prompto.statement.CollectionSwitchCase;
import prompto.statement.StatementList;
import prompto.statement.SwitchCase;
import prompto.transpiler.Transpiler;
import prompto.type.EnumeratedCategoryType;
import prompto.type.IType;
import prompto.type.TypeMap;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.utils.Logger;
import prompto.value.IValue;

public class SwitchErrorStatement
extends BaseSwitchStatement {
    private static Logger logger = new Logger();
    Identifier errorId;
    StatementList statements;
    StatementList finallyStatements;

    public SwitchErrorStatement(Identifier errorName, StatementList statements) {
        this.errorId = errorName;
        this.statements = statements;
    }

    public SwitchErrorStatement(Identifier errorName, StatementList statements, BaseSwitchStatement.SwitchCaseList handlers, StatementList anyStmts, StatementList finalStmts) {
        super(handlers, anyStmts);
        this.errorId = errorName;
        this.statements = statements;
        this.finallyStatements = finalStmts;
    }

    public void setAlwaysInstructions(StatementList list) {
        this.finallyStatements = list;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer = writer.newLocalWriter();
        writer.getContext().registerValue(new ErrorVariable(this.errorId));
        super.toDialect(writer);
    }

    @Override
    protected void toODialect(CodeWriter writer) {
        writer.append("try (");
        writer.append(this.errorId);
        writer.append(") {\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        writer.append("} ");
        for (SwitchCase sc : this.switchCases) {
            sc.catchToODialect(writer);
        }
        if (this.defaultCase != null) {
            writer.append("catch(any) {\n");
            writer.indent();
            this.defaultCase.toDialect(writer);
            writer.dedent();
            writer.append("}");
        }
        if (this.finallyStatements != null) {
            writer.append("finally {\n");
            writer.indent();
            this.finallyStatements.toDialect(writer);
            writer.dedent();
            writer.append("}");
        }
        writer.newLine();
    }

    @Override
    protected void toMDialect(CodeWriter writer) {
        writer.append("try ");
        writer.append(this.errorId);
        writer.append(":\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        for (SwitchCase sc : this.switchCases) {
            sc.catchToPDialect(writer);
        }
        if (this.defaultCase != null) {
            writer.append("except:\n");
            writer.indent();
            this.defaultCase.toDialect(writer);
            writer.dedent();
        }
        if (this.finallyStatements != null) {
            writer.append("finally:\n");
            writer.indent();
            this.finallyStatements.toDialect(writer);
            writer.dedent();
        }
        writer.newLine();
    }

    @Override
    protected void toEDialect(CodeWriter writer) {
        writer.append("switch on ");
        writer.append(this.errorId);
        writer.append(" doing:\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        for (SwitchCase sc : this.switchCases) {
            sc.catchToEDialect(writer);
        }
        if (this.defaultCase != null) {
            writer.append("when any:\n");
            writer.indent();
            this.defaultCase.toDialect(writer);
            writer.dedent();
        }
        if (this.finallyStatements != null) {
            writer.append("always:\n");
            writer.indent();
            this.finallyStatements.toDialect(writer);
            writer.dedent();
        }
    }

    @Override
    protected void checkSwitchCasesType(Context context) {
        Context local = context.newLocalContext();
        local.registerValue(new ErrorVariable(this.errorId));
        super.checkSwitchCasesType(local);
    }

    @Override
    IType checkSwitchType(Context context) {
        return new EnumeratedCategoryType(new Identifier("Error"));
    }

    @Override
    protected void collectReturnTypes(Context context, TypeMap types) {
        IType type = this.statements.check(context, null);
        if (type != VoidType.instance()) {
            types.put(type.getTypeNameId(), type);
        }
        Context local = context.newLocalContext();
        local.registerValue(new ErrorVariable(this.errorId));
        super.collectReturnTypes(local, types);
        if (this.finallyStatements != null && (type = this.finallyStatements.check(context, null)) != VoidType.instance()) {
            types.put(type.getTypeNameId(), type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue result = null;
        try {
            result = this.statements.interpret(context);
        }
        catch (ExecutionError e) {
            logger.error(() -> "While interpreting try/catch body", e);
            IValue switchValue = e.interpret(context, this.errorId);
            result = this.interpretSwitch(context, switchValue, e);
        }
        catch (Throwable t) {
            logger.error(() -> "While interpreting try/catch body", t);
        }
        finally {
            if (this.finallyStatements != null) {
                this.finallyStatements.interpret(context);
            }
        }
        return result;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        List<List<ExceptionHandler>> handlers = this.installExceptionHandlers(context, method, flags);
        ResultInfo result = this.statements.compile(context, method, flags);
        if (result.isReturn() || result.isThrow()) {
            this.compileExceptionHandlers(context, method, flags, handlers, null);
        } else {
            LinkedList<OffsetListenerConstant> finalOffsets = new LinkedList<OffsetListenerConstant>();
            StackState neutral = method.captureStackState();
            OffsetListenerConstant finalOffset = method.addOffsetListener(new OffsetListenerConstant());
            method.activateOffsetListener(finalOffset);
            finalOffsets.add(finalOffset);
            method.addInstruction(Opcode.GOTO, finalOffset);
            this.compileExceptionHandlers(context, method, flags, handlers, finalOffsets);
            finalOffsets.forEach(o -> method.inhibitOffsetListener((IInstructionListener)o));
            method.restoreFullStackState(neutral);
            method.placeLabel(neutral);
        }
        return result;
    }

    private void compileExceptionHandlers(Context context, MethodInfo method, Flags flags, List<List<ExceptionHandler>> handlerList, List<OffsetListenerConstant> finalOffsets) {
        Iterator iterCases = this.switchCases.iterator();
        Iterator<List<ExceptionHandler>> iterHandler = handlerList.iterator();
        if (iterCases.hasNext()) {
            this.compileExceptionHandler(context, method, flags, (SwitchCase)iterCases.next(), iterHandler.next(), finalOffsets);
        }
        if (this.defaultCase != null) {
            this.compileExceptionHandler(context, method, flags, null, iterHandler.next(), finalOffsets);
        }
    }

    private void compileExceptionHandler(Context context, MethodInfo method, Flags flags, SwitchCase switchCase, List<ExceptionHandler> handlers, List<OffsetListenerConstant> finalOffsets) {
        ResultInfo result;
        handlers.forEach(h -> method.inhibitOffsetListener((IInstructionListener)h));
        ExceptionHandler handler = this.makeCommonExceptionHandler(handlers);
        method.placeExceptionHandler(handler);
        Type exception = this.compileConvertException(context, method, flags, handler);
        StackLocal error = method.registerLocal(this.errorId.toString(), IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(exception));
        CompilerUtils.compileASTORE(method, error);
        Context local = context.newLocalContext();
        local.registerValue(new ErrorVariable(this.errorId));
        ResultInfo resultInfo = result = switchCase != null ? switchCase.statements.compile(local, method, flags) : this.defaultCase.compile(context, method, flags);
        if (finalOffsets != null && !result.isReturn() && !result.isThrow()) {
            OffsetListenerConstant finalOffset = method.addOffsetListener(new OffsetListenerConstant());
            method.activateOffsetListener(finalOffset);
            finalOffsets.add(finalOffset);
            method.addInstruction(Opcode.GOTO, finalOffset);
        }
        method.unregisterLocal(error);
    }

    private Type compileConvertException(Context context, MethodInfo method, Flags flags, String name) {
        method.addInstruction(Opcode.POP, new IOperand[0]);
        Type classType = CompilerUtils.getCategoryEnumConcreteType("Error");
        ClassConstant cc = new ClassConstant(classType);
        Type fieldType = CompilerUtils.getExceptionType(classType, name);
        FieldConstant fc = new FieldConstant(cc, name, fieldType);
        method.addInstruction(Opcode.GETSTATIC, fc);
        return cc.getType();
    }

    private ExceptionHandler makeCommonExceptionHandler(List<ExceptionHandler> handlers) {
        if (handlers.size() == 1) {
            return handlers.get(0);
        }
        throw new UnsupportedOperationException();
    }

    private List<List<ExceptionHandler>> installExceptionHandlers(Context context, MethodInfo method, Flags flags) {
        LinkedList<List<ExceptionHandler>> handlers = new LinkedList<List<ExceptionHandler>>();
        for (SwitchCase sc : this.switchCases) {
            handlers.add(this.installExceptionHandlers(context, method, flags, sc));
        }
        if (this.defaultCase != null) {
            handlers.add(this.installDefaultExceptionHandlers(context, method, flags));
        }
        return handlers;
    }

    private List<ExceptionHandler> installDefaultExceptionHandlers(Context context, MethodInfo method, Flags flags) {
        LinkedList<ExceptionHandler> list = new LinkedList<ExceptionHandler>();
        list.add(this.installExceptionHandler(context, method, flags, (SymbolExpression)null));
        return list;
    }

    private List<ExceptionHandler> installExceptionHandlers(Context context, MethodInfo method, Flags flags, SwitchCase sc) {
        if (sc instanceof AtomicSwitchCase) {
            return this.installExceptionHandler(context, method, flags, (AtomicSwitchCase)sc);
        }
        if (sc instanceof CollectionSwitchCase) {
            return this.installExceptionHandlers(context, method, flags, (CollectionSwitchCase)sc);
        }
        throw new UnsupportedOperationException();
    }

    private List<ExceptionHandler> installExceptionHandler(Context context, MethodInfo method, Flags flags, AtomicSwitchCase sc) {
        IExpression exp = sc.getExpression();
        if (exp instanceof SymbolExpression) {
            LinkedList<ExceptionHandler> list = new LinkedList<ExceptionHandler>();
            list.add(this.installExceptionHandler(context, method, flags, (SymbolExpression)exp));
            return list;
        }
        throw new UnsupportedOperationException();
    }

    private List<ExceptionHandler> installExceptionHandlers(Context context, MethodInfo method, Flags flags, CollectionSwitchCase sc) {
        IExpression exp = sc.getExpression();
        if (exp instanceof ListLiteral) {
            LinkedList<ExceptionHandler> list = new LinkedList<ExceptionHandler>();
            for (IExpression item : ((ListLiteral)exp).getExpressions()) {
                if (item instanceof SymbolExpression) {
                    list.add(this.installExceptionHandler(context, method, flags, (SymbolExpression)item));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            return list;
        }
        throw new UnsupportedOperationException();
    }

    private Type compileConvertException(Context context, MethodInfo method, Flags flags, ExceptionHandler handler) {
        Type type = handler.getException().getType();
        if (type instanceof Class) {
            String simpleName = PromptoException.getExceptionTypeName((Class)type);
            if (type.getTypeName().endsWith(simpleName)) {
                return type;
            }
            return this.compileConvertException(context, method, flags, simpleName);
        }
        return type;
    }

    private ExceptionHandler installExceptionHandler(Context context, MethodInfo method, Flags flags, SymbolExpression symbol) {
        Type type = this.getExceptionType(context, symbol);
        ExceptionHandler handler = method.registerExceptionHandler(type);
        method.activateOffsetListener(handler);
        return handler;
    }

    private Type getExceptionType(Context context, SymbolExpression symbol) {
        if (symbol == null) {
            return CompilerUtils.getCategoryEnumConcreteType("Error");
        }
        Type type = PromptoException.getExceptionType(symbol.getName());
        if (type != null) {
            return type;
        }
        return symbol.getJavaType(context);
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("NativeError");
        this.statements.declare(transpiler);
        transpiler = transpiler.newLocalTranspiler();
        transpiler.getContext().registerValue(new ErrorVariable(this.errorId));
        this.declareSwitch(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("try {").indent();
        this.statements.transpile(transpiler);
        transpiler.dedent().append("} catch(").append(this.errorId.toString()).append(") {").indent();
        Transpiler child = transpiler.newLocalTranspiler();
        child.getContext().registerValue(new ErrorVariable(this.errorId));
        child.append("switch(translateError(").append(this.errorId.toString()).append(")) {").indent();
        this.switchCases.forEach(switchCase -> switchCase.transpileError(child));
        if (this.defaultCase != null) {
            child.append("default:").indent();
            this.defaultCase.transpile(child);
            child.dedent();
        }
        child.dedent().append("}");
        if (this.finallyStatements != null) {
            child.append(" finally {").indent();
            this.finallyStatements.transpile(child);
            child.dedent().append("}");
        }
        child.dedent().append("}");
        child.flush();
        return true;
    }
}

