/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.ConcreteCategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.TestMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.ConstructorExpression;
import prompto.expression.IAssertion;
import prompto.expression.IExpression;
import prompto.expression.MemberSelector;
import prompto.expression.MethodSelector;
import prompto.expression.SelectorExpression;
import prompto.expression.UnresolvedIdentifier;
import prompto.expression.UnresolvedSelector;
import prompto.grammar.ArgumentList;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.parser.Dialect;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.statement.BaseStatement;
import prompto.statement.MethodCall;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;
import prompto.value.NullValue;

public class UnresolvedCall
extends BaseStatement
implements IAssertion {
    IExpression caller;
    IExpression resolved;
    ArgumentList arguments;

    public UnresolvedCall(IExpression caller, ArgumentList arguments) {
        this.caller = caller;
        this.arguments = arguments;
    }

    public void setParent(IExpression parent) {
        if (parent != null) {
            if (this.caller instanceof UnresolvedIdentifier) {
                this.caller = new MethodSelector(parent, ((UnresolvedIdentifier)this.caller).getId());
            } else if (this.caller instanceof SelectorExpression) {
                ((SelectorExpression)this.caller).setParent(parent);
            } else {
                throw new IllegalStateException("Should never happen!");
            }
        }
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    public String toString() {
        return this.caller.toString();
    }

    public void setCaller(IExpression caller) {
        this.caller = caller;
    }

    public IExpression getCaller() {
        return this.caller;
    }

    public ArgumentList getAssignments() {
        return this.arguments;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        block3: {
            try {
                this.doResolve(writer.getContext());
                this.resolved.toDialect(writer);
            }
            catch (SyntaxError error) {
                this.caller.toDialect(writer);
                if (this.arguments != null) {
                    this.arguments.toDialect(writer);
                }
                if (writer.getDialect() == Dialect.E) break block3;
                writer.append("()");
            }
        }
    }

    @Override
    public IType check(Context context) {
        return this.resolveAndCheck(context);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        this.resolveAndCheck(context);
        if (this.resolved == null) {
            context.getProblemListener().reportUnknownMethod(this, this.caller.toString());
            return NullValue.instance();
        }
        return this.resolved.interpret(context);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        this.resolveAndCheck(context);
        return this.resolved.compile(context, method, flags);
    }

    @Override
    public boolean interpretAssert(Context context, TestMethodDeclaration test) throws PromptoError {
        if (this.resolved == null) {
            this.resolveAndCheck(context);
        }
        if (this.resolved instanceof IAssertion) {
            return ((IAssertion)((Object)this.resolved)).interpretAssert(context, test);
        }
        CodeWriter writer = new CodeWriter(this.getDialect(), context);
        this.resolved.toDialect(writer);
        throw new SyntaxError("Cannot test '" + writer.toString() + "'");
    }

    @Override
    public void compileAssert(Context context, MethodInfo method, Flags flags, TestMethodDeclaration test) {
        if (this.resolved == null) {
            this.resolveAndCheck(context);
        }
        if (!(this.resolved instanceof IAssertion)) {
            CodeWriter writer = new CodeWriter(this.getDialect(), context);
            this.resolved.toDialect(writer);
            throw new SyntaxError("Cannot test '" + writer.toString() + "'");
        }
        ((IAssertion)((Object)this.resolved)).compileAssert(context, method, flags, test);
    }

    public IExpression resolve(Context context) {
        this.doResolve(context);
        return this.resolved;
    }

    protected IType resolveAndCheck(Context context) {
        this.doResolve(context);
        if (this.resolved == null) {
            return null;
        }
        return this.resolved.check(context);
    }

    protected void doResolve(Context context) {
        if (this.resolved == null) {
            if (this.caller instanceof UnresolvedIdentifier) {
                this.resolved = this.resolveUnresolvedIdentifier(context, (UnresolvedIdentifier)this.caller);
            } else if (this.caller instanceof UnresolvedSelector) {
                this.resolved = this.resolveUnresolvedSelector(context, (UnresolvedSelector)this.caller);
            } else if (this.caller instanceof MemberSelector) {
                this.resolved = this.resolveMemberSelector(context, (MemberSelector)this.caller);
            }
            if (this.resolved instanceof Section) {
                ((Section)((Object)this.resolved)).setFrom(this);
            }
        }
        if (this.resolved == null) {
            context.getProblemListener().reportUnknownMethod(this, this.toString());
        }
    }

    private IExpression resolveUnresolvedSelector(Context context, UnresolvedSelector caller) {
        caller.resolveMethod(context, this.arguments);
        return caller.getResolved();
    }

    private IExpression resolveUnresolvedIdentifier(Context context, UnresolvedIdentifier caller) {
        IType type;
        INamed named;
        Identifier id = caller.getId();
        Section call = null;
        IDeclaration decl = null;
        Context.InstanceContext instance = context.getClosestInstanceContext();
        if (instance != null && (decl = this.resolveUnresolvedMember(instance, id)) != null) {
            call = new MethodCall(new MethodSelector(id), this.arguments);
        }
        if (call == null && (named = context.getRegisteredValue(INamed.class, id)) != null && (type = named.getType(context)) instanceof MethodType) {
            call = new MethodCall(new MethodSelector(id), this.arguments);
            ((MethodCall)call).setVariableName(id.toString());
        }
        if (call == null) {
            decl = context.getRegisteredDeclaration(IDeclaration.class, id);
            if (decl == null) {
                context.getProblemListener().reportUnknownMethod(id, id.toString());
                return null;
            }
            call = decl instanceof CategoryDeclaration ? new ConstructorExpression(new CategoryType(id), null, this.arguments, false) : new MethodCall(new MethodSelector(id), this.arguments);
        }
        return call;
    }

    private IDeclaration resolveUnresolvedMember(Context.InstanceContext context, Identifier name) {
        ConcreteCategoryDeclaration decl = context.getRegisteredDeclaration(ConcreteCategoryDeclaration.class, context.getInstanceType().getTypeNameId());
        Context.MethodDeclarationMap methods = decl.getMemberMethods(context, name);
        if (methods != null && methods.size() > 0) {
            return methods;
        }
        return null;
    }

    private IExpression resolveMemberSelector(Context context, MemberSelector caller) {
        IExpression parent = caller.getParent();
        Identifier id = caller.getId();
        return new MethodCall(new MethodSelector(parent, id), this.arguments);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.doResolve(transpiler.getContext());
        if (this.resolved != null) {
            this.resolved.declare(transpiler);
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        this.doResolve(transpiler.getContext());
        if (this.resolved != null) {
            this.resolved.transpile(transpiler);
        }
        return false;
    }

    @Override
    public void transpileFound(Transpiler transpiler, Dialect dialect) {
        transpiler.append("'<unknown>'");
    }
}

