/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.util.ArrayList;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IInstructionListener;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackState;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.parser.ISection;
import prompto.runtime.BreakResult;
import prompto.runtime.Context;
import prompto.statement.BaseStatement;
import prompto.statement.StatementList;
import prompto.store.InvalidValueError;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.BooleanValue;
import prompto.value.IValue;

public class WhileStatement
extends BaseStatement {
    IExpression condition;
    StatementList statements;

    public WhileStatement(IExpression condition, StatementList statements) {
        this.condition = condition;
        this.statements = statements;
    }

    public IExpression getCondition() {
        return this.condition;
    }

    public StatementList getStatements() {
        return this.statements;
    }

    @Override
    public boolean canReturn() {
        return true;
    }

    @Override
    public ISection locateSection(ISection section) {
        ISection result = this.statements.locateSection(section);
        return result != null ? result : super.locateSection(section);
    }

    @Override
    public void toDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    private void toMDialect(CodeWriter writer) {
        this.toEDialect(writer);
    }

    private void toEDialect(CodeWriter writer) {
        writer.append("while ");
        this.condition.toDialect(writer);
        writer.append(" :\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    private void toODialect(CodeWriter writer) {
        writer.append("while (");
        this.condition.toDialect(writer);
        writer.append(") {\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        writer.append("}\n");
    }

    @Override
    public IType check(Context context) {
        IType cond = this.condition.check(context);
        if (cond != BooleanType.instance()) {
            throw new SyntaxError("Expected a Boolean condition!");
        }
        Context child = context.newChildContext();
        return this.statements.check(child, null);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        Context child;
        IValue value;
        while (this.interpretCondition(context) && (value = this.statements.interpret(child = context.newChildContext())) != BreakResult.instance()) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private boolean interpretCondition(Context context) throws PromptoError {
        IValue value = this.condition.interpret(context);
        if (!(value instanceof BooleanValue)) {
            throw new InvalidValueError("Expected a Boolean, got:" + value.getClass().getSimpleName());
        }
        return ((BooleanValue)value).getValue();
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ArrayList<IInstructionListener> breakLoopListeners = new ArrayList<IInstructionListener>();
        flags = flags.withBreakLoopListeners(breakLoopListeners);
        StackState neutralState = method.captureStackState();
        method.placeLabel(neutralState);
        OffsetListenerConstant loop = method.addOffsetListener(new OffsetListenerConstant(true));
        method.activateOffsetListener(loop);
        ResultInfo info = this.condition.compile(context, method, flags.withPrimitive(true));
        if (BooleanValue.class == info.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        OffsetListenerConstant exit = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(exit);
        method.addInstruction(Opcode.IFEQ, exit);
        this.statements.compile(context, method, flags);
        method.inhibitOffsetListener(loop);
        method.addInstruction(Opcode.GOTO, loop);
        method.inhibitOffsetListener(exit);
        for (IInstructionListener listener : breakLoopListeners) {
            method.inhibitOffsetListener(listener);
        }
        method.restoreFullStackState(neutralState);
        method.placeLabel(neutralState);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.condition.declare(transpiler);
        transpiler = transpiler.newChildTranspiler(null);
        this.statements.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("while(");
        this.condition.transpile(transpiler);
        transpiler.append(") {");
        transpiler.indent();
        Transpiler child = transpiler.newChildTranspiler(null);
        this.statements.transpile(child);
        child.dedent().flush();
        transpiler.append("}").newLine();
        return true;
    }
}

