/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.lang.reflect.Type;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.error.PromptoError;
import prompto.runtime.Context;
import prompto.statement.AssignVariableStatement;
import prompto.statement.BaseStatement;
import prompto.statement.IStatement;
import prompto.statement.StatementList;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.IResource;
import prompto.value.IValue;

public class WithResourceStatement
extends BaseStatement {
    AssignVariableStatement resource;
    StatementList statements;

    public WithResourceStatement(AssignVariableStatement resource, StatementList statements) {
        this.resource = resource;
        this.statements = statements;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    private void toEDialect(CodeWriter writer) {
        writer.append("with ");
        this.resource.toDialect(writer);
        writer.append(", do:\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    private void toODialect(CodeWriter writer) {
        boolean oneLine;
        writer.append("with (");
        this.resource.toDialect(writer);
        writer.append(")");
        boolean bl = oneLine = this.statements.size() == 1 && ((IStatement)this.statements.get(0)).isSimple();
        if (!oneLine) {
            writer.append(" {");
        }
        writer.newLine();
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        if (!oneLine) {
            writer.append("}");
            writer.newLine();
        }
    }

    private void toMDialect(CodeWriter writer) {
        writer.append("with ");
        this.resource.toDialect(writer);
        writer.append(":\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    public IType check(Context context) {
        context = context.newResourceContext();
        this.resource.checkResource(context);
        return this.statements.check(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue interpret(Context context) throws PromptoError {
        context = context.newResourceContext();
        try {
            this.resource.interpret(context);
            IValue iValue = this.statements.interpret(context);
            return iValue;
        }
        finally {
            IValue res = context.getValue(this.resource.getVariableId());
            if (res instanceof IResource) {
                ((IResource)((Object)res)).close();
            }
        }
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        context = context.newResourceContext();
        this.resource.compile(context, method, flags);
        ResultInfo info = this.statements.compile(context, method, flags.withVariable("%return%"));
        StackLocal variable = method.getRegisteredLocal(this.resource.getVariableName());
        CompilerUtils.compileALOAD(method, variable);
        InterfaceConstant c = new InterfaceConstant((Type)((Object)IResource.class), "close", Void.TYPE);
        method.addInstruction(Opcode.INVOKEINTERFACE, c);
        if (info.isReturn()) {
            StackLocal result = method.getRegisteredLocal("%return%");
            if (result != null) {
                info = CompilerUtils.compileALOAD(method, result);
                method.addInstruction(Opcode.ARETURN, new IOperand[0]);
                return info;
            }
            method.addInstruction(Opcode.RETURN, new IOperand[0]);
            return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
        }
        return info;
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler = transpiler.newResourceTranspiler();
        this.resource.declare(transpiler);
        this.statements.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler = transpiler.newResourceTranspiler();
        this.resource.transpile(transpiler);
        transpiler.append(";").newLine();
        transpiler.append("try {").indent();
        this.statements.transpile(transpiler);
        transpiler.dedent().append("} finally {").indent();
        this.resource.transpileClose(transpiler);
        transpiler.dedent().append("}");
        transpiler.flush();
        return true;
    }
}

