/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.lang.reflect.Type;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StringConstant;
import prompto.error.PromptoError;
import prompto.runtime.Context;
import prompto.statement.BaseStatement;
import prompto.statement.IStatement;
import prompto.statement.StatementList;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.ConcreteInstance;
import prompto.value.IValue;

public class WithSingletonStatement
extends BaseStatement {
    CategoryType type;
    StatementList statements;

    public WithSingletonStatement(CategoryType type, StatementList statements) {
        this.type = type;
        this.statements = statements;
    }

    @Override
    public boolean canReturn() {
        return true;
    }

    @Override
    public IType check(Context context) {
        Context instanceContext = context.newInstanceContext(this.type, true);
        Context childContext = instanceContext.newChildContext();
        return this.statements.check(childContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue interpret(Context context) throws PromptoError {
        ConcreteInstance instance;
        ConcreteInstance concreteInstance = instance = context.loadSingleton(this.type);
        synchronized (concreteInstance) {
            Context instanceContext = context.newInstanceContext(instance, true);
            Context childContext = instanceContext.newChildContext();
            return this.statements.interpret(childContext);
        }
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        Type thisType = this.type.getJavaType(context);
        StringConstant s = new StringConstant(thisType.getTypeName());
        method.addInstruction(Opcode.LDC_W, s);
        MethodConstant m = new MethodConstant((Type)((Object)Class.class), "forName", new Type[]{String.class, Class.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        method.addInstruction(Opcode.MONITORENTER, new IOperand[0]);
        Context instanceContext = context.newInstanceContext(this.type, false);
        Context childContext = instanceContext.newChildContext();
        this.statements.compile(childContext, method, flags);
        method.addInstruction(Opcode.MONITOREXIT, new IOperand[0]);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    @Override
    public void toDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    private void toEDialect(CodeWriter writer) {
        writer.append("with ");
        this.type.toDialect(writer);
        writer.append(", do:\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    private void toODialect(CodeWriter writer) {
        boolean oneLine;
        writer.append("with (");
        this.type.toDialect(writer);
        writer.append(")");
        boolean bl = oneLine = this.statements.size() == 1 && ((IStatement)this.statements.get(0)).isSimple();
        if (!oneLine) {
            writer.append(" {");
        }
        writer.newLine();
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        if (!oneLine) {
            writer.append("}");
            writer.newLine();
        }
    }

    private void toMDialect(CodeWriter writer) {
        writer.append("with ");
        this.type.toDialect(writer);
        writer.append(":\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.type.declare(transpiler);
        transpiler = transpiler.newInstanceTranspiler(this.type);
        transpiler = transpiler.newChildTranspiler(null);
        this.statements.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        Transpiler instance = transpiler.newInstanceTranspiler(this.type);
        Transpiler child = instance.newChildTranspiler(null);
        this.statements.transpile(child);
        child.flush();
        instance.flush();
        return true;
    }
}

