/*
 * Decompiled with CFR 0.152.
 */
package prompto.statement;

import java.io.IOException;
import java.lang.reflect.Type;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.InvalidResourceError;
import prompto.error.NullReferenceError;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.runtime.Context;
import prompto.statement.SimpleStatement;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.ResourceType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IResource;
import prompto.value.IValue;

public class WriteStatement
extends SimpleStatement {
    IExpression content;
    IExpression resource;

    public WriteStatement(IExpression content, IExpression resource) {
        this.content = content;
        this.resource = resource;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append("write ");
        switch (writer.getDialect()) {
            case E: 
            case M: {
                this.content.toDialect(writer);
                break;
            }
            case O: {
                writer.append("(");
                this.content.toDialect(writer);
                writer.append(")");
            }
        }
        writer.append(" to ");
        this.resource.toDialect(writer);
    }

    @Override
    public IType check(Context context) {
        IType resourceType = this.resource.check(context = context instanceof Context.ResourceContext ? context : context.newResourceContext());
        if (!(resourceType instanceof ResourceType)) {
            throw new SyntaxError("Not a resource!");
        }
        return VoidType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        Context resContext = context instanceof Context.ResourceContext ? context : context.newResourceContext();
        IValue o = this.resource.interpret(resContext);
        if (o == null) {
            throw new NullReferenceError();
        }
        if (!(o instanceof IResource)) {
            throw new InternalError("Illegal write source: " + o);
        }
        IResource res = (IResource)((Object)o);
        if (!res.isWritable()) {
            throw new InvalidResourceError("Not writable");
        }
        try {
            String text = this.content.interpret(resContext).toString();
            if (context == resContext) {
                res.writeLine(text);
            } else {
                res.writeFully(text);
            }
            IValue iValue = null;
            return iValue;
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
        finally {
            if (resContext != context) {
                res.close();
            }
        }
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        Context resContext = context instanceof Context.ResourceContext ? context : context.newResourceContext();
        this.resource.compile(resContext, method, flags);
        if (resContext != context) {
            method.addInstruction(Opcode.DUP, new IOperand[0]);
        }
        this.content.compile(resContext, method, flags);
        InterfaceConstant c = new InterfaceConstant((Type)((Object)IResource.class), "writeFully", new Type[]{String.class, Void.TYPE});
        method.addInstruction(Opcode.INVOKEINTERFACE, c);
        if (resContext != context) {
            c = new InterfaceConstant((Type)((Object)IResource.class), "close", Void.TYPE);
            method.addInstruction(Opcode.INVOKEINTERFACE, c);
        }
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        if (!(transpiler.getContext() instanceof Context.ResourceContext)) {
            transpiler = transpiler.newResourceTranspiler();
        }
        this.resource.declare(transpiler);
        this.content.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        if (transpiler.getContext() instanceof Context.ResourceContext) {
            this.transpileLine(transpiler);
        } else {
            this.transpileFully(transpiler);
        }
        return false;
    }

    private void transpileFully(Transpiler transpiler) {
        transpiler = transpiler.newResourceTranspiler();
        transpiler.append("var $res = ");
        this.resource.transpile(transpiler);
        transpiler.append(";").newLine();
        transpiler.append("try {").indent();
        transpiler.append("$res.writeFully(");
        this.content.transpile(transpiler);
        transpiler.append(");");
        transpiler.dedent().append("} finally {").indent();
        transpiler.append("$res.close();").newLine();
        transpiler.dedent().append("}");
        transpiler.flush();
    }

    private void transpileLine(Transpiler transpiler) {
        this.resource.transpile(transpiler);
        transpiler.append(".writeLine(");
        this.content.transpile(transpiler);
        transpiler.append(")");
    }
}

