/*
 * Decompiled with CFR 0.152.
 */
package prompto.store;

import java.util.Collection;
import prompto.store.Family;
import prompto.store.FamilyInfo;

public class AttributeInfo
extends FamilyInfo {
    public static final AttributeInfo CATEGORY = new AttributeInfo("category", Family.TEXT, true, null);
    public static final AttributeInfo NAME = new AttributeInfo("name", Family.TEXT, false, null);
    public static final AttributeInfo STORABLE = new AttributeInfo("storable", Family.BOOLEAN, false, null);
    public static final AttributeInfo SYMBOLS = new AttributeInfo("symbols", Family.TEXT, true, null);
    public static final AttributeInfo MODULE = new AttributeInfo("module", Family.CATEGORY, false, null);
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String WORDS = "words";
    protected String name;
    protected boolean key = false;
    protected boolean value = false;
    protected boolean words = false;

    public AttributeInfo(String name, Family family, boolean collection, Collection<String> indexTypes) {
        super(family, collection);
        this.name = name;
        if (indexTypes != null) {
            this.key = indexTypes.contains(KEY);
            this.value = indexTypes.contains(VALUE);
            this.words = indexTypes.contains(WORDS);
        }
    }

    public AttributeInfo(String name, Family family, boolean collection, boolean key, boolean value, boolean words) {
        super(family, collection);
        this.name = name;
        this.key = key;
        this.value = value;
        this.words = words;
    }

    public AttributeInfo(AttributeInfo info) {
        super(info.getFamily(), info.isCollection());
        this.name = info.getName();
        this.key = info.isKey();
        this.value = info.isValue();
        this.words = info.isWords();
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isKey() {
        return this.key;
    }

    public boolean isValue() {
        return this.value;
    }

    public boolean isWords() {
        return this.words;
    }

    public boolean isIndexed() {
        return this.key || this.value || this.words;
    }

    public String toTranspiled() {
        return "new AttributeInfo('" + this.name + "', TypeFamily." + this.family.name() + ", " + this.collection + ", null)";
    }
}

