/*
 * Decompiled with CFR 0.152.
 */
package prompto.store;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import prompto.error.PromptoError;
import prompto.intrinsic.PromptoBinary;
import prompto.store.AttributeInfo;
import prompto.store.IQuery;
import prompto.store.IQueryBuilder;
import prompto.store.IStorable;
import prompto.store.IStored;
import prompto.store.IStoredIterable;

public interface IStore
extends Closeable {
    public static final String dbIdName = "dbId";

    public boolean checkConnection();

    public Class<?> getDbIdClass();

    public Object newDbId();

    public Object convertToDbId(Object var1);

    public AttributeInfo getAttributeInfo(String var1) throws PromptoError;

    public void createOrUpdateAttributes(Collection<AttributeInfo> var1) throws PromptoError;

    public IStorable newStorable(String[] var1, IStorable.IDbIdFactory var2);

    default public IStorable newStorable(List<String> categories, IStorable.IDbIdFactory dbIdFactory) {
        return this.newStorable(categories.toArray(new String[0]), dbIdFactory);
    }

    public void store(Collection<?> var1, Collection<IStorable> var2) throws PromptoError;

    default public void store(Collection<IStorable> storables) throws PromptoError {
        this.store(null, storables);
    }

    default public void store(IStorable storable) throws PromptoError {
        this.store(null, Arrays.asList(storable));
    }

    default public void delete(Collection<?> dbIds) throws PromptoError {
        this.store(dbIds, null);
    }

    default public void delete(Object dbId) throws PromptoError {
        this.store(Arrays.asList(dbId), null);
    }

    public void deleteAll() throws PromptoError;

    public PromptoBinary fetchBinary(Object var1, String var2) throws PromptoError;

    public IStored fetchUnique(Object var1) throws PromptoError;

    public IQueryBuilder newQueryBuilder();

    public IStored fetchOne(IQuery var1) throws PromptoError;

    public IStoredIterable fetchMany(IQuery var1) throws PromptoError;

    public void flush() throws PromptoError;
}

