/*
 * Decompiled with CFR 0.152.
 */
package prompto.store;

import prompto.config.IConfigurationReader;
import prompto.config.IStoreConfiguration;
import prompto.config.StoreConfiguration;
import prompto.store.IStore;
import prompto.store.memory.MemStore;

public interface IStoreFactory {
    public IStore newStore(IStoreConfiguration var1) throws Exception;

    public static IStore newStoreFromConfig(IStoreConfiguration cfg) throws Throwable {
        if (cfg == null) {
            return new MemStore();
        }
        IStoreFactory factory = IStoreFactory.newStoreFactory(cfg.getFactory());
        return factory.newStore(cfg);
    }

    public static IStoreFactory newStoreFactory(String factoryName) throws Throwable {
        Class<?> klass = Class.forName(factoryName, true, Thread.currentThread().getContextClassLoader());
        if (!IStoreFactory.class.isAssignableFrom(klass)) {
            throw new RuntimeException("Not a store factory: " + factoryName);
        }
        return (IStoreFactory)klass.newInstance();
    }

    default public IStoreConfiguration newConfiguration(IConfigurationReader reader) {
        return new StoreConfiguration(reader);
    }
}

