/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.memory;

import java.util.Collection;
import java.util.Map;
import prompto.store.AttributeInfo;
import prompto.store.IQueryBuilder;
import prompto.store.memory.IPredicate;

public class MatchesPredicate<T>
implements IPredicate {
    AttributeInfo info;
    IQueryBuilder.MatchOp match;
    T value;

    public MatchesPredicate(AttributeInfo info, IQueryBuilder.MatchOp match, T value) {
        this.info = info;
        this.match = match;
        this.value = value;
    }

    @Override
    public boolean matches(Map<String, Object> document) {
        Object data = document.get(this.info.getName());
        switch (this.match) {
            case EQUALS: {
                return this.matchesEQUALS(data);
            }
            case ROUGHLY: {
                return this.matchesROUGHLY(data);
            }
            case CONTAINS: {
                return this.matchesCONTAINS(data);
            }
            case HAS: {
                return this.matchesHAS(data);
            }
            case IN: {
                return this.matchesIN(data);
            }
            case GREATER: {
                return this.matchesGREATER(data);
            }
            case LESSER: {
                return this.matchesLESSER(data);
            }
        }
        return false;
    }

    private boolean matchesGREATER(Object data) {
        if (data instanceof Comparable && this.value instanceof Comparable) {
            return ((Comparable)data).compareTo((Comparable)this.value) > 0;
        }
        return false;
    }

    private boolean matchesLESSER(Object data) {
        if (data instanceof Comparable && this.value instanceof Comparable) {
            return ((Comparable)data).compareTo((Comparable)this.value) < 0;
        }
        return false;
    }

    private boolean matchesHAS(Object data) {
        if (data instanceof Collection) {
            return ((Collection)data).contains(this.value);
        }
        return false;
    }

    private boolean matchesCONTAINS(Object data) {
        if (data instanceof String && this.value instanceof String) {
            return ((String)data).contains((String)this.value);
        }
        if (data instanceof Collection) {
            return ((Collection)data).stream().anyMatch(this::matchesCONTAINS);
        }
        return false;
    }

    private boolean matchesIN(Object data) {
        if (data instanceof String && this.value instanceof String) {
            return ((String)this.value).contains((String)data);
        }
        if (this.value instanceof Collection) {
            return ((Collection)this.value).stream().anyMatch(item -> item.equals(data));
        }
        return false;
    }

    private boolean matchesROUGHLY(Object data) {
        if (data instanceof String && this.value instanceof String) {
            return ((String)data).equalsIgnoreCase((String)this.value);
        }
        return this.matchesEQUALS(data);
    }

    private boolean matchesEQUALS(Object data) {
        if (data == null) {
            return this.value == null;
        }
        return data.equals(this.value);
    }
}

