/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import prompto.error.PromptoError;
import prompto.intrinsic.PromptoBinary;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoTuple;
import prompto.store.AttributeInfo;
import prompto.store.IQuery;
import prompto.store.IQueryBuilder;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.store.IStoredIterable;
import prompto.store.memory.IOrderBy;
import prompto.store.memory.IPredicate;
import prompto.store.memory.Query;
import prompto.store.memory.QueryBuilder;

public final class MemStore
implements IStore {
    private Map<Long, StoredDocument> documents = new HashMap<Long, StoredDocument>();
    private AtomicLong lastDbId = new AtomicLong(0L);
    private Map<String, AttributeInfo> attributes = new HashMap<String, AttributeInfo>();

    @Override
    public boolean checkConnection() {
        return true;
    }

    @Override
    public Class<?> getDbIdClass() {
        return Long.class;
    }

    @Override
    public Object newDbId() {
        return this.lastDbId.incrementAndGet();
    }

    @Override
    public Long convertToDbId(Object dbId) {
        if (dbId instanceof Long) {
            return (Long)dbId;
        }
        return Long.decode(String.valueOf(dbId));
    }

    @Override
    public AttributeInfo getAttributeInfo(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void createOrUpdateAttributes(Collection<AttributeInfo> infos) {
        infos.forEach(i -> this.attributes.put(i.getName(), (AttributeInfo)i));
    }

    @Override
    public void store(Collection<?> toDelete, Collection<IStorable> toStore) throws PromptoError {
        if (toDelete != null) {
            this.delete(toDelete);
        }
        if (toStore != null) {
            this.store(toStore);
        }
    }

    @Override
    public void store(Collection<IStorable> storables) throws PromptoError {
        for (IStorable storable : storables) {
            if (!(storable instanceof StorableDocument)) {
                throw new IllegalStateException("Expecting a StorableDocument");
            }
            this.store((StorableDocument)storable);
        }
    }

    public void store(StorableDocument storable) throws PromptoError {
        Object dbId = storable.getData("dbId");
        if (!(dbId instanceof Long)) {
            dbId = this.lastDbId.incrementAndGet();
            storable.setData("dbId", dbId);
        }
        this.documents.put((Long)dbId, new StoredDocument(storable.getCategories(), storable.getDocument()));
    }

    @Override
    public void delete(Collection<?> dbIds) throws PromptoError {
        for (Object dbId : dbIds) {
            this.documents.remove(dbId);
        }
    }

    @Override
    public void deleteAll() throws PromptoError {
        this.documents = new HashMap<Long, StoredDocument>();
    }

    @Override
    public PromptoBinary fetchBinary(Object dbId, String attr) {
        StoredDocument doc;
        if (!(dbId instanceof Long)) {
            dbId = Long.decode(dbId.toString());
        }
        if ((doc = this.documents.get(dbId)) == null) {
            return null;
        }
        return (PromptoBinary)doc.getData(attr);
    }

    @Override
    public IStored fetchUnique(Object dbId) throws PromptoError {
        return this.documents.get(dbId);
    }

    @Override
    public IQueryBuilder newQueryBuilder() {
        return new QueryBuilder();
    }

    @Override
    public IStored fetchOne(IQuery query) throws PromptoError {
        Query q = (Query)query;
        for (StoredDocument doc : this.documents.values()) {
            if (!doc.matches(q.getPredicate())) continue;
            return doc;
        }
        return null;
    }

    @Override
    public IStoredIterable fetchMany(IQuery query) throws PromptoError {
        Query q = (Query)query;
        final List<StoredDocument> allDocs = this.fetchManyDocs(q);
        final List<StoredDocument> slicedDocs = this.slice(q, allDocs);
        return new IStoredIterable(){

            @Override
            public long count() {
                return slicedDocs.size();
            }

            @Override
            public long totalCount() {
                return allDocs.size();
            }

            @Override
            public Iterator<IStored> iterator() {
                return slicedDocs.iterator();
            }
        };
    }

    private List<StoredDocument> fetchManyDocs(Query query) throws PromptoError {
        List<StoredDocument> docs = this.filterDocs(query == null ? null : query.getPredicate());
        if (query != null) {
            docs = this.sort(query.getOrdering(), docs);
        }
        return docs;
    }

    private List<StoredDocument> filterDocs(IPredicate predicate) throws PromptoError {
        if (predicate == null) {
            return new ArrayList<StoredDocument>(this.documents.values());
        }
        return this.documents.values().stream().filter(doc -> doc.matches(predicate)).collect(Collectors.toList());
    }

    private List<StoredDocument> slice(Query query, List<StoredDocument> docs) {
        if (docs == null || docs.isEmpty() || query == null) {
            return docs;
        }
        Long first = query.getFirst();
        Long last = query.getLast();
        if (first == null && last == null) {
            return docs;
        }
        if (first == null || first < 1L) {
            first = 1L;
        }
        if (last == null || last > (long)docs.size()) {
            last = new Long(docs.size());
        }
        if (first > last) {
            return new ArrayList<StoredDocument>();
        }
        return docs.subList(first.intValue() - 1, last.intValue());
    }

    private List<StoredDocument> sort(final Collection<IOrderBy> orderBy, List<StoredDocument> docs) {
        if (orderBy == null || orderBy.isEmpty() || docs.size() < 2) {
            return docs;
        }
        final List directions = orderBy.stream().map(o -> o.isDescending()).collect(Collectors.toList());
        docs.sort(new Comparator<StoredDocument>(){

            @Override
            public int compare(StoredDocument o1, StoredDocument o2) {
                try {
                    PromptoTuple v1 = MemStore.this.readTuple(o1, orderBy);
                    PromptoTuple v2 = MemStore.this.readTuple(o2, orderBy);
                    return v1.compareTo(v2, directions);
                }
                catch (PromptoError e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return docs;
    }

    private PromptoTuple<Comparable<?>> readTuple(StoredDocument doc, Collection<IOrderBy> orderBy) throws PromptoError {
        PromptoTuple tuple = new PromptoTuple(false);
        orderBy.forEach(o -> tuple.add((Comparable)doc.getData(o.getAttributeInfo().getName())));
        return tuple;
    }

    @Override
    public IStorable newStorable(String[] categories, IStorable.IDbIdFactory dbIdFactory) {
        return new StorableDocument(categories, dbIdFactory);
    }

    public IStorable newStorable(List<String> categories, IStorable.IDbIdListener listener) {
        return this.newStorable(categories.toArray(new String[0]), listener);
    }

    public IStorable newStorable(String[] categories, final IStorable.IDbIdListener listener) {
        IStorable.IDbIdFactory factory = new IStorable.IDbIdFactory(){

            @Override
            public void accept(Object dbId) {
                listener.accept(dbId);
            }

            @Override
            public Object get() {
                return null;
            }

            @Override
            public boolean isUpdate() {
                return false;
            }
        };
        return this.newStorable(categories, factory);
    }

    @Override
    public void flush() throws PromptoError {
    }

    @Override
    public void close() throws IOException {
    }

    class StoredDocument
    implements IStored {
        final Map<String, Object> document;
        final String[] categories;

        public StoredDocument(String[] categories, Map<String, Object> document) {
            this.categories = categories;
            this.document = document;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StoredDocument) {
                return this.equals((StoredDocument)obj);
            }
            if (obj instanceof StorableDocument) {
                return this.equals((StorableDocument)obj);
            }
            return false;
        }

        public boolean equals(StoredDocument doc) {
            return Arrays.deepEquals(this.categories, doc.categories) && Objects.deepEquals(this.document, doc.document);
        }

        public boolean equals(StorableDocument doc) {
            return Arrays.deepEquals(this.categories, doc.categories) && Objects.deepEquals(this.document, doc.document);
        }

        @Override
        public String[] getCategories() {
            return this.categories;
        }

        @Override
        public Object getDbId() {
            return this.getData("dbId");
        }

        public boolean matches(IPredicate predicate) {
            if (predicate == null) {
                return true;
            }
            return predicate.matches(this.document);
        }

        @Override
        public boolean hasData(String name) {
            return this.document.containsKey(name);
        }

        @Override
        public Object getRawData(String fieldName) {
            return this.getData(fieldName);
        }

        @Override
        public Object getData(String fieldName) {
            return this.document.get(fieldName);
        }

        @Override
        public Set<String> getNames() throws PromptoError {
            Set<String> names = this.document.keySet();
            names.remove("category");
            names.remove("dbId");
            return names;
        }
    }

    class StorableDocument
    implements IStorable {
        Map<String, Object> document = null;
        IStorable.IDbIdFactory dbIdFactory;
        String[] categories;

        public StorableDocument(String[] categories, IStorable.IDbIdFactory dbIdFactory) {
            this.categories = categories;
            this.dbIdFactory = dbIdFactory;
        }

        public Map<String, Object> getDocument() {
            return this.document;
        }

        private void ensureDocument() {
            if (this.document == null) {
                this.document = this.newDocument();
                Long dbId = null;
                if (this.dbIdFactory != null) {
                    dbId = (Long)this.dbIdFactory.get();
                }
                if (dbId == null) {
                    dbId = MemStore.this.lastDbId.incrementAndGet();
                    if (this.dbIdFactory != null) {
                        this.dbIdFactory.accept(dbId);
                    }
                }
                this.setData("dbId", dbId);
            }
        }

        @Override
        public String[] getCategories() {
            return this.categories;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StoredDocument) {
                return this.equals((StoredDocument)obj);
            }
            if (obj instanceof StorableDocument) {
                return this.equals((StorableDocument)obj);
            }
            return false;
        }

        public boolean equals(StoredDocument doc) {
            return Arrays.deepEquals(this.categories, doc.categories) && Objects.deepEquals(this.document, doc.document);
        }

        public boolean equals(StorableDocument doc) {
            return Arrays.deepEquals(this.categories, doc.categories) && Objects.deepEquals(this.document, doc.document);
        }

        public Object getData(String fieldName) {
            if (this.document == null) {
                return null;
            }
            return this.document.get(fieldName);
        }

        @Override
        public void setCategories(String[] categories) throws PromptoError {
            this.categories = categories;
        }

        @Override
        public void setDbId(Object dbId) {
            if (this.document != null) {
                this.document.put("dbId", dbId);
            }
        }

        @Override
        public Object getOrCreateDbId() {
            Object dbId = this.getData("dbId");
            if (dbId == null) {
                if (this.dbIdFactory != null) {
                    dbId = this.dbIdFactory.get();
                }
                if (dbId == null) {
                    dbId = MemStore.this.lastDbId.incrementAndGet();
                    if (this.dbIdFactory != null) {
                        this.dbIdFactory.accept(dbId);
                    }
                }
                this.setData("dbId", dbId);
            }
            return dbId;
        }

        @Override
        public void clear() {
            this.document = null;
        }

        @Override
        public boolean isDirty() {
            return this.document != null;
        }

        @Override
        public void setData(String fieldName, Object value) {
            this.ensureDocument();
            this.document.put(fieldName, value);
        }

        private Map<String, Object> newDocument() {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            if (this.categories != null) {
                PromptoList value = new PromptoList(false);
                for (String name : this.categories) {
                    value.add(name);
                }
                doc.put("category", value);
            }
            return doc;
        }

        public boolean matches(IPredicate predicate) {
            if (predicate == null) {
                return true;
            }
            return predicate.matches(this.document);
        }
    }
}

