/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import prompto.store.AttributeInfo;
import prompto.store.IQuery;
import prompto.store.IQueryBuilder;
import prompto.store.memory.AndPredicate;
import prompto.store.memory.IOrderBy;
import prompto.store.memory.IPredicate;
import prompto.store.memory.MatchesPredicate;
import prompto.store.memory.NotPredicate;
import prompto.store.memory.OrPredicate;
import prompto.store.memory.OrderBy;

public class Query
implements IQuery {
    Stack<IPredicate> predicates = new Stack();
    List<IOrderBy> orderBys = new ArrayList<IOrderBy>();
    Long first;
    Long last;

    public IPredicate getPredicate() {
        if (this.predicates.isEmpty()) {
            return null;
        }
        return this.predicates.peek();
    }

    public void setFirst(Long first) {
        this.first = first;
    }

    public Long getFirst() {
        return this.first;
    }

    public void setLast(Long last) {
        this.last = last;
    }

    public Long getLast() {
        return this.last;
    }

    public Collection<IOrderBy> getOrdering() {
        if (this.orderBys.isEmpty()) {
            return null;
        }
        return this.orderBys;
    }

    public void addOrderByClause(AttributeInfo attribute, boolean descending) {
        this.orderBys.add(new OrderBy(attribute, descending));
    }

    public <T> void verify(AttributeInfo info, IQueryBuilder.MatchOp match, T fieldValue) {
        this.predicates.push(new MatchesPredicate<T>(info, match, fieldValue));
    }

    public void and() {
        IPredicate right = this.predicates.pop();
        IPredicate left = this.predicates.pop();
        this.predicates.push(new AndPredicate(left, right));
    }

    public void or() {
        IPredicate right = this.predicates.pop();
        IPredicate left = this.predicates.pop();
        this.predicates.push(new OrPredicate(left, right));
    }

    public void not() {
        this.predicates.push(new NotPredicate(this.predicates.pop()));
    }
}

