/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDocument;
import prompto.intrinsic.PromptoList;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.DocumentType;
import prompto.type.IType;
import prompto.type.NativeType;
import prompto.value.BooleanValue;
import prompto.value.DecimalValue;
import prompto.value.DocumentValue;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.ListValue;
import prompto.value.TextValue;

public class AnyType
extends NativeType {
    static AnyType instance = new AnyType();
    static Map<Class<?>, BiFunction<Context, Object, IValue>> converters = AnyType.buildConvertersMap();

    public static AnyType instance() {
        return instance;
    }

    private AnyType() {
        super(Family.ANY);
    }

    @Override
    public String getTypeName() {
        return "any";
    }

    @Override
    public Type getJavaType(Context context) {
        return Object.class;
    }

    @Override
    public IType checkItem(Context context, IType itemType) {
        return DocumentType.instance().checkItem(context, itemType);
    }

    @Override
    public IType checkMember(Context context, Identifier name) {
        return DocumentType.instance().checkMember(context, name);
    }

    @Override
    public boolean isAssignableFrom(Context context, IType other) {
        return true;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    private static Map<Class<?>, BiFunction<Context, Object, IValue>> buildConvertersMap() {
        HashMap map = new HashMap();
        map.put(Boolean.class, (c, o) -> BooleanValue.valueOf((Boolean)o));
        map.put(Long.class, (c, o) -> new IntegerValue((Long)o));
        map.put(Double.class, (c, o) -> new DecimalValue((Double)o));
        map.put(String.class, (c, o) -> new TextValue((String)o));
        map.put(PromptoDocument.class, (c, o) -> new DocumentValue((Context)c, (PromptoDocument)o, true));
        map.put(PromptoList.class, (c, o) -> new ListValue((Context)c, (PromptoList<?>)((PromptoList)o)));
        return map;
    }

    @Override
    public IValue convertJavaValueToIValue(Context context, Object value) {
        BiFunction<Context, Object, IValue> converter;
        if (value != null && (converter = converters.get(value.getClass())) != null) {
            return converter.apply(context, value);
        }
        return super.convertJavaValueToIValue(context, value);
    }

    public static ResultInfo compileEquals(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        exp.compile(context, method, flags);
        MethodConstant oper = new MethodConstant((Type)((Object)Object.class), "equals", new Type[]{Object.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        if (flags.isReverse()) {
            CompilerUtils.reverseBoolean(method);
        }
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    @Override
    public void declare(Transpiler transpiler) {
    }

    @Override
    public void declareItem(Transpiler transpiler, IType itemType, IExpression item) {
        DocumentType.instance().declareItem(transpiler, itemType, item);
    }

    @Override
    public void transpileItem(Transpiler transpiler, IType itemType, IExpression item) {
        DocumentType.instance().transpileItem(transpiler, itemType, item);
    }

    @Override
    public void declareMember(Transpiler transpiler, Identifier name) {
        DocumentType.instance().declareMember(transpiler, name);
    }

    @Override
    public void transpileMember(Transpiler transpiler, Identifier name) {
        DocumentType.instance().transpileMember(transpiler, name);
    }

    @Override
    public void transpileAssignMemberValue(Transpiler transpiler, String name, IExpression expression) {
        transpiler.append(".setMember('").append(name).append("', ");
        expression.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void transpileAssignItemValue(Transpiler transpiler, IExpression item, IExpression expression) {
        transpiler.append(".setItem(");
        item.transpile(transpiler);
        transpiler.append(", ");
        expression.transpile(transpiler);
        transpiler.append(")");
    }
}

