/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.ShortOperand;
import prompto.compiler.StackState;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.CmpOp;
import prompto.grammar.Identifier;
import prompto.parser.ISection;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.store.FamilyInfo;
import prompto.type.BooleanType;
import prompto.type.EnumeratedNativeType;
import prompto.type.IType;
import prompto.type.NullType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;
import prompto.value.RangeBase;

public abstract class BaseType
extends Section
implements IType {
    Family family;
    public static Opcode[] CMP_OPCODES = BaseType.createOpcodes();

    protected BaseType(Family family) {
        this.family = family;
    }

    @Override
    public FamilyInfo getFamilyInfo(Context context) {
        IType resolved = this.resolve(context, null);
        if (resolved == null || resolved == this) {
            return new FamilyInfo(this.family, false);
        }
        return resolved.getFamilyInfo(context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IType)) {
            return false;
        }
        IType type = (IType)obj;
        return this.getTypeName().equals(type.getTypeName());
    }

    public String toString() {
        return this.getTypeName();
    }

    @Override
    public String getTranspiledName(Context context) {
        return this.getTypeName();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append(this.getTypeName());
    }

    @Override
    public IType checkAdd(Context context, IType other, boolean tryReverse) {
        if (other instanceof EnumeratedNativeType) {
            return this.checkAdd(context, ((EnumeratedNativeType)other).getDerivedFrom(), tryReverse);
        }
        if (tryReverse) {
            return other.checkAdd(context, this, false);
        }
        throw new SyntaxError("Cannot add " + this.getTypeName() + " to " + other.getTypeName());
    }

    @Override
    public IType checkSubstract(Context context, IType other) {
        if (other instanceof EnumeratedNativeType) {
            return this.checkSubstract(context, ((EnumeratedNativeType)other).getDerivedFrom());
        }
        throw new SyntaxError("Cannot substract " + this.getTypeName() + " from " + other.getTypeName());
    }

    @Override
    public IType checkDivide(Context context, IType other) {
        if (other instanceof EnumeratedNativeType) {
            return this.checkDivide(context, ((EnumeratedNativeType)other).getDerivedFrom());
        }
        throw new SyntaxError("Cannot divide " + this.getTypeName() + " with " + other.getTypeName());
    }

    @Override
    public IType checkIntDivide(Context context, IType other) {
        if (other instanceof EnumeratedNativeType) {
            return this.checkIntDivide(context, ((EnumeratedNativeType)other).getDerivedFrom());
        }
        throw new SyntaxError("Cannot divide " + this.getTypeName() + " with " + other.getTypeName());
    }

    @Override
    public IType checkMultiply(Context context, IType other, boolean tryReverse) {
        if (other instanceof EnumeratedNativeType) {
            return this.checkMultiply(context, ((EnumeratedNativeType)other).getDerivedFrom(), tryReverse);
        }
        if (tryReverse) {
            return other.checkMultiply(context, this, false);
        }
        throw new SyntaxError("Cannot multiply " + this.getTypeName() + " with " + other.getTypeName());
    }

    @Override
    public IType checkModulo(Context context, IType other) {
        if (other instanceof EnumeratedNativeType) {
            return this.checkModulo(context, ((EnumeratedNativeType)other).getDerivedFrom());
        }
        throw new SyntaxError("Cannot modulo " + this.getTypeName() + " with " + other.getTypeName());
    }

    @Override
    public IType checkCompare(Context context, IType other, ISection section) {
        if (other instanceof EnumeratedNativeType) {
            return this.checkCompare(context, ((EnumeratedNativeType)other).getDerivedFrom(), section);
        }
        context.getProblemListener().reportIllegalComparison(section, this, other);
        return BooleanType.instance();
    }

    @Override
    public IType checkContains(Context context, IType other) {
        if (other instanceof EnumeratedNativeType) {
            return this.checkContains(context, ((EnumeratedNativeType)other).getDerivedFrom());
        }
        throw new SyntaxError(this.getTypeName() + " cannot contain " + other.getTypeName());
    }

    @Override
    public IType checkContainsAllOrAny(Context context, IType other) {
        if (other instanceof EnumeratedNativeType) {
            return this.checkContainsAllOrAny(context, ((EnumeratedNativeType)other).getDerivedFrom());
        }
        throw new SyntaxError(this.getTypeName() + " cannot contain " + other.getTypeName());
    }

    @Override
    public IType checkItem(Context context, IType itemType) {
        throw new SyntaxError("Cannot read item from " + this.getTypeName());
    }

    @Override
    public IType checkMember(Context context, Identifier name) {
        context.getProblemListener().reportUnknownMember(name, name.toString());
        return VoidType.instance();
    }

    @Override
    public IType checkStaticMember(Context context, Identifier name) {
        context.getProblemListener().reportUnknownMember(name, name.toString());
        return VoidType.instance();
    }

    @Override
    public IType checkSlice(Context context) {
        throw new SyntaxError("Cannot slice " + this.getTypeName());
    }

    @Override
    public IType checkIterator(Context context) {
        throw new SyntaxError("Cannot iterate over " + this.getTypeName());
    }

    @Override
    public abstract void checkUnique(Context var1);

    @Override
    public abstract void checkExists(Context var1);

    @Override
    public boolean isAssignableFrom(Context context, IType other) {
        return this == other || this.equals(other) || other.equals(NullType.instance());
    }

    @Override
    public abstract boolean isMoreSpecificThan(Context var1, IType var2);

    @Override
    public final void checkAssignableFrom(Context context, IType other) {
        if (!this.isAssignableFrom(context, other)) {
            throw new SyntaxError("Type: " + other.getTypeName() + " is not compatible with: " + this.getTypeName());
        }
    }

    @Override
    public IType checkRange(Context context, IType other) {
        throw new SyntaxError("Cannot create range of " + this.getTypeName() + " and " + other.getTypeName());
    }

    @Override
    public RangeBase<?> newRange(Object left, Object right) {
        throw new SyntaxError("Cannot create range of " + this.getTypeName());
    }

    @Override
    public String toString(Object value) {
        return value.toString();
    }

    @Override
    public Comparator<? extends IValue> getComparator(Context context, IExpression key, boolean descending) {
        throw new RuntimeException("Unsupported!");
    }

    @Override
    public IValue convertJavaValueToIValue(Context context, Object value) {
        throw new RuntimeException("Unsupported convertJavaValueToIValue for " + this.getClass() + " and value type " + value.getClass().getSimpleName());
    }

    @Override
    public IValue getStaticMemberValue(Context context, Identifier name) throws PromptoError {
        throw new SyntaxError("Cannot read member from " + this.getTypeName());
    }

    @Override
    public Set<IMethodDeclaration> getMemberMethods(Context context, Identifier name) throws PromptoError {
        return Collections.emptySet();
    }

    @Override
    public Set<IMethodDeclaration> getStaticMemberMethods(Context context, Identifier name) throws PromptoError {
        return Collections.emptySet();
    }

    @Override
    public IValue readJSONValue(Context context, JsonNode value, Map<String, byte[]> parts) {
        throw new InvalidParameterException(value.toString());
    }

    public static Opcode[] createOpcodes() {
        Opcode[] opcodes = new Opcode[CmpOp.values().length];
        opcodes[CmpOp.LT.ordinal()] = Opcode.IF_ICMPLT;
        opcodes[CmpOp.LTE.ordinal()] = Opcode.IF_ICMPLE;
        opcodes[CmpOp.GT.ordinal()] = Opcode.IF_ICMPGT;
        opcodes[CmpOp.GTE.ordinal()] = Opcode.IF_ICMPGE;
        return opcodes;
    }

    public static ResultInfo compileCompareToEpilogue(MethodInfo method, Flags flags) {
        method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        Opcode opcode = CMP_OPCODES[flags.cmpOp().ordinal()];
        method.addInstruction(opcode, new ShortOperand(7));
        StackState branchState = method.captureStackState();
        method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        method.addInstruction(Opcode.GOTO, new ShortOperand(4));
        method.restoreFullStackState(branchState);
        method.placeLabel(branchState);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        StackState lastState = method.captureStackState();
        method.placeLabel(lastState);
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    public static BiFunction<IValue, IValue, Integer> getValuesComparator(boolean descending) {
        return descending ? (k1, k2) -> IValue.compareValues(k2, k1) : (k1, k2) -> IValue.compareValues(k1, k2);
    }
}

