/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import prompto.error.ReadWriteError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoBinary;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.NativeType;
import prompto.type.TextType;
import prompto.value.BinaryValue;
import prompto.value.IValue;
import prompto.value.NullValue;

public abstract class BinaryType
extends NativeType {
    protected BinaryType(Family family) {
        super(family);
    }

    protected abstract IValue newInstance(PromptoBinary var1);

    @Override
    public IType checkMember(Context context, Identifier id) {
        String name = id.toString();
        if ("mimeType".equals(name)) {
            return TextType.instance();
        }
        if ("url".equals(name)) {
            return TextType.instance();
        }
        return super.checkMember(context, id);
    }

    @Override
    public void declareMember(Transpiler transpiler, Identifier name) {
        if ("mimeType".equals(name.toString()) || "url".equals(name.toString())) {
            return;
        }
        super.declareMember(transpiler, name);
    }

    @Override
    public void transpileMember(Transpiler transpiler, Identifier name) {
        if ("mimeType".equals(name.toString()) || "url".equals(name.toString())) {
            transpiler.append(name.toString());
        } else {
            super.transpileMember(transpiler, name);
        }
    }

    @Override
    public IValue convertJavaValueToIValue(Context context, Object value) {
        if (value instanceof PromptoBinary) {
            return BinaryValue.newInstance((PromptoBinary)value);
        }
        return super.convertJavaValueToIValue(context, value);
    }

    @Override
    public IValue readJSONValue(Context context, JsonNode value, Map<String, byte[]> parts) {
        if (value.isNull()) {
            return NullValue.instance();
        }
        PromptoBinary binary = BinaryType.readJSONValue(value, parts);
        return binary == null ? null : this.newInstance(binary);
    }

    public static PromptoBinary readJSONValue(JsonNode value, Map<String, byte[]> parts) {
        if (value == null || value.isNull()) {
            return null;
        }
        if (BinaryType.wasReceivedFromBrowser(value, parts)) {
            return BinaryType.readJSONValueReceivedFromBrowser(value, parts);
        }
        if (BinaryType.wasCreatedInBrowser(value, parts)) {
            return BinaryType.readJSONValueCreatedInBrowser(value, parts);
        }
        throw new ReadWriteError("Cannot read binary value from: " + value.toString());
    }

    private static PromptoBinary readJSONValueCreatedInBrowser(JsonNode value, Map<String, byte[]> parts) {
        JsonNode partNode = value.get("partName");
        String partName = partNode.asText();
        byte[] bytes = parts.get(partName);
        if (bytes == null) {
            return null;
        }
        String mimeType = value.get("mimeType").asText();
        return new PromptoBinary(mimeType, bytes);
    }

    private static boolean wasCreatedInBrowser(JsonNode value, Map<String, byte[]> parts) {
        if (!value.isObject()) {
            return false;
        }
        JsonNode partNode = value.get("partName");
        return partNode != null && partNode.isTextual();
    }

    private static PromptoBinary readJSONValueReceivedFromBrowser(JsonNode value, Map<String, byte[]> parts) {
        JsonNode urlNode = value.get("url");
        String url = urlNode.asText();
        if (url.startsWith("/ws/bin/data?")) {
            return null;
        }
        byte[] bytes = parts.get(url);
        if (bytes == null) {
            return null;
        }
        String[] segments = url.split("/");
        String mimeType = segments[segments.length - 1].replaceAll("\\.", "/");
        return new PromptoBinary(mimeType, bytes);
    }

    private static boolean wasReceivedFromBrowser(JsonNode value, Map<String, byte[]> parts) {
        if (!value.isObject()) {
            return false;
        }
        JsonNode urlNode = value.get("url");
        if (urlNode == null || !urlNode.isTextual()) {
            return false;
        }
        String url = urlNode.asText();
        return url.startsWith("/ws/bin/data?") || url.startsWith("@");
    }
}

