/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Type;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import prompto.compiler.ByteOperand;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.NamedType;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.compiler.comparator.ArrowExpressionComparatorCompiler;
import prompto.compiler.comparator.ComparatorCompiler;
import prompto.compiler.comparator.ComparatorCompilerBase;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.BaseDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.ConcreteCategoryDeclaration;
import prompto.declaration.EnumeratedCategoryDeclaration;
import prompto.declaration.EnumeratedNativeDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IEnumeratedDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.declaration.SingletonCategoryDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.ArrowExpression;
import prompto.expression.IExpression;
import prompto.expression.InstanceExpression;
import prompto.expression.MethodSelector;
import prompto.expression.UnresolvedIdentifier;
import prompto.expression.ValueExpression;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.grammar.Operator;
import prompto.instance.MemberInstance;
import prompto.instance.VariableInstance;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoRoot;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.runtime.MethodFinder;
import prompto.runtime.Score;
import prompto.runtime.Variable;
import prompto.statement.MethodCall;
import prompto.store.DataStore;
import prompto.store.Family;
import prompto.store.IStored;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.BaseType;
import prompto.type.EnumeratedCategoryType;
import prompto.type.EnumeratedNativeType;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.type.MissingType;
import prompto.type.NativeType;
import prompto.type.NullType;
import prompto.type.TextType;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;
import prompto.utils.Logger;
import prompto.utils.ObjectUtils;
import prompto.utils.TypeUtils;
import prompto.value.ConcreteInstance;
import prompto.value.IInstance;
import prompto.value.IValue;
import prompto.value.NullValue;

public class CategoryType
extends BaseType {
    static Logger logger = new Logger();
    boolean mutable = false;
    Identifier typeNameId;
    IType resolved;

    public CategoryType(Identifier typeNameId) {
        super(Family.CATEGORY);
        this.typeNameId = typeNameId;
    }

    public CategoryType(CategoryType copyFrom, boolean mutable) {
        super(copyFrom.family);
        this.typeNameId = copyFrom.typeNameId;
        this.mutable = mutable;
    }

    protected CategoryType(Family family, Identifier typeNameId) {
        super(family);
        this.typeNameId = typeNameId;
    }

    public CategoryType getSuperType(ISection section, Context context) {
        IdentifierList derived;
        IDeclaration decl = this.getDeclaration(context);
        if (decl instanceof CategoryDeclaration && (derived = ((CategoryDeclaration)decl).getDerivedFrom()) != null && !derived.isEmpty()) {
            return new CategoryType((Identifier)derived.get(0));
        }
        context.getProblemListener().reportNoSuperType(section, this);
        return this;
    }

    @Override
    public IType anyfy() {
        if ("Any".equals(this.getTypeName())) {
            return AnyType.instance();
        }
        return this;
    }

    @Override
    public IType asMutable(Context context, boolean mutable) {
        if (mutable == this.mutable) {
            return this;
        }
        return new CategoryType(this, mutable);
    }

    @Override
    public boolean isStorable(Context context) {
        IDeclaration decl = this.getDeclaration(context);
        return decl != null && decl instanceof CategoryDeclaration && ((CategoryDeclaration)decl).isStorable(context);
    }

    @Override
    public IType resolve(Context context, Consumer<IType> onError) {
        if (this.resolved == null) {
            IType type = this.anyfy();
            if (type instanceof NativeType) {
                this.resolved = type;
            } else {
                IType found;
                IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, type.getTypeNameId());
                if (decl == null) {
                    if (onError != null) {
                        onError.accept(type);
                        return null;
                    }
                    throw new SyntaxError("Unknown type:" + type.getTypeNameId());
                }
                this.resolved = decl instanceof Context.MethodDeclarationMap ? new MethodType(((Context.MethodDeclarationMap)decl).getFirst()) : ((found = decl.getType(context)).getClass() == type.getClass() ? type : found);
            }
        }
        return this.resolved;
    }

    @Override
    public String getTypeName() {
        return this.typeNameId.toString();
    }

    @Override
    public Identifier getTypeNameId() {
        return this.typeNameId;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.mutable) {
            writer.append("mutable ");
        }
        super.toDialect(writer);
    }

    @Override
    public Type getJavaType(Context context) {
        IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, this.typeNameId);
        if (decl instanceof NativeCategoryDeclaration) {
            return new NamedType(((NativeCategoryDeclaration)decl).getBoundClassName());
        }
        if (decl instanceof EnumeratedNativeDeclaration) {
            return CompilerUtils.getNativeEnumType(this.typeNameId);
        }
        if (decl instanceof EnumeratedCategoryDeclaration) {
            return CompilerUtils.getCategoryEnumConcreteType(this.typeNameId);
        }
        if (decl instanceof SingletonCategoryDeclaration) {
            return CompilerUtils.getCategorySingletonType(this.typeNameId);
        }
        return CompilerUtils.getCategoryInterfaceType(this.typeNameId);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryType)) {
            return false;
        }
        CategoryType other = (CategoryType)obj;
        return this.getTypeName().equals(other.getTypeName());
    }

    @Override
    public void checkUnique(Context context) {
        IDeclaration actual = context.getRegisteredDeclaration(IDeclaration.class, this.typeNameId);
        if (actual != null) {
            throw new SyntaxError("Duplicate name: \"" + this.typeNameId + "\"");
        }
    }

    public IDeclaration getDeclaration(Context context) {
        return CategoryType.getDeclaration(context, this.typeNameId);
    }

    private static IDeclaration getDeclaration(Context context, Identifier id) {
        BaseDeclaration actual = context.getRegisteredDeclaration(CategoryDeclaration.class, id);
        if (actual == null) {
            actual = context.getRegisteredDeclaration(EnumeratedNativeDeclaration.class, id);
        }
        if (actual == null) {
            context.getProblemListener().reportUnknownCategory(id, id.toString());
        }
        return actual;
    }

    @Override
    public IType checkMultiply(Context context, IType other, boolean tryReverse) {
        IType type = this.checkOperator(context, other, tryReverse, Operator.MULTIPLY);
        if (type != null) {
            return type;
        }
        return super.checkMultiply(context, other, tryReverse);
    }

    @Override
    public IType checkDivide(Context context, IType other) {
        IType type = this.checkOperator(context, other, false, Operator.DIVIDE);
        if (type != null) {
            return type;
        }
        return super.checkDivide(context, other);
    }

    @Override
    public IType checkIntDivide(Context context, IType other) {
        IType type = this.checkOperator(context, other, false, Operator.IDIVIDE);
        if (type != null) {
            return type;
        }
        return super.checkIntDivide(context, other);
    }

    @Override
    public IType checkModulo(Context context, IType other) {
        IType type = this.checkOperator(context, other, false, Operator.MODULO);
        if (type != null) {
            return type;
        }
        return super.checkModulo(context, other);
    }

    @Override
    public IType checkAdd(Context context, IType other, boolean tryReverse) {
        IType type = this.checkOperator(context, other, tryReverse, Operator.PLUS);
        if (type != null) {
            return type;
        }
        return super.checkAdd(context, other, tryReverse);
    }

    @Override
    public IType checkSubstract(Context context, IType other) {
        IType type = this.checkOperator(context, other, false, Operator.MINUS);
        if (type != null) {
            return type;
        }
        return super.checkSubstract(context, other);
    }

    private IType checkOperator(Context context, IType other, boolean tryReverse, Operator operator) {
        IDeclaration actual = this.getDeclaration(context);
        if (actual instanceof ConcreteCategoryDeclaration) {
            try {
                IMethodDeclaration method = ((ConcreteCategoryDeclaration)actual).findOperator(context, operator, other);
                if (method == null) {
                    return null;
                }
                context = context.newInstanceContext(this, false);
                Context local = context.newLocalContext();
                method.registerParameters(local);
                return method.check(local, false);
            }
            catch (SyntaxError syntaxError) {
                // empty catch block
            }
        }
        if (tryReverse) {
            return null;
        }
        throw new SyntaxError("Unsupported operation: " + this.typeNameId + " " + operator.getToken() + " " + other.getTypeName());
    }

    @Override
    public void checkExists(Context context) {
        this.getDeclaration(context);
    }

    @Override
    public IType checkMember(Context context, Identifier id) {
        if ("category".contentEquals(id.toString())) {
            return new CategoryType(new Identifier("Category"));
        }
        IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, this.typeNameId);
        if (decl == null) {
            throw new SyntaxError("Unknown type:" + this.typeNameId);
        }
        if (decl instanceof EnumeratedNativeDeclaration) {
            return decl.getType(context).checkMember(context, id);
        }
        if (decl instanceof CategoryDeclaration) {
            return this.checkMember(context, (CategoryDeclaration)decl, id);
        }
        throw new SyntaxError("Not a category:" + this.typeNameId);
    }

    private IType checkMember(Context context, CategoryDeclaration decl, Identifier id) {
        if (decl.isStorable(context) && "dbId".equals(id.toString())) {
            return AnyType.instance();
        }
        if (decl.hasAttribute(context, id)) {
            AttributeDeclaration ad = context.getRegisteredDeclaration(AttributeDeclaration.class, id);
            if (ad != null) {
                return ad.getType(context);
            }
            throw new SyntaxError("Missing atttribute:" + id);
        }
        if (decl.hasMethod(context, id)) {
            IMethodDeclaration method = decl.getMemberMethods(context, id).getFirst();
            return new MethodType(method);
        }
        if ("text".equals(id.toString())) {
            return TextType.instance();
        }
        throw new SyntaxError("No attribute:" + id + " in category:" + this.typeNameId);
    }

    @Override
    public IType checkStaticMember(Context context, Identifier id) {
        IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, this.typeNameId);
        if (decl == null) {
            context.getProblemListener().reportUnknownIdentifier(this, this.typeNameId.toString());
            return null;
        }
        if (decl instanceof IEnumeratedDeclaration) {
            return decl.getType(context).checkStaticMember(context, id);
        }
        if (decl instanceof SingletonCategoryDeclaration) {
            return this.checkMember(context, (SingletonCategoryDeclaration)decl, id);
        }
        context.getProblemListener().reportUnknownAttribute(this, id.toString());
        return null;
    }

    @Override
    public Set<IMethodDeclaration> getStaticMemberMethods(Context context, Identifier id) throws PromptoError {
        IDeclaration decl = this.getDeclaration(context);
        if (decl instanceof IEnumeratedDeclaration) {
            return decl.getType(context).getStaticMemberMethods(context, id);
        }
        if (decl instanceof SingletonCategoryDeclaration) {
            return decl.getType(context).getMemberMethods(context, id);
        }
        return super.getStaticMemberMethods(context, id);
    }

    @Override
    public IValue getStaticMemberValue(Context context, Identifier id) throws PromptoError {
        IDeclaration decl = this.getDeclaration(context);
        if (decl instanceof IEnumeratedDeclaration) {
            return decl.getType(context).getStaticMemberValue(context, id);
        }
        if (decl instanceof SingletonCategoryDeclaration) {
            ConcreteInstance singleton = context.loadSingleton(this);
            return singleton.getMember(context, id, false);
        }
        return super.getStaticMemberValue(context, id);
    }

    @Override
    public Set<IMethodDeclaration> getMemberMethods(Context context, Identifier id) throws PromptoError {
        Collection methods;
        IDeclaration decl = this.getDeclaration(context);
        if (!(decl instanceof ConcreteCategoryDeclaration)) {
            context.getProblemListener().reportUnknownCategory(id, id.toString());
        }
        if ((methods = ((ConcreteCategoryDeclaration)decl).getMemberMethods(context, id).values()) instanceof Set) {
            return (Set)methods;
        }
        return new HashSet<IMethodDeclaration>(methods);
    }

    @Override
    public boolean isAssignableFrom(Context context, IType other) {
        IType actual = this.resolve(context, null);
        other = other.resolve(context, null);
        if (actual == this) {
            return super.isAssignableFrom(context, other) || other instanceof CategoryType && this.isAssignableFrom(context, (CategoryType)other);
        }
        return actual.isAssignableFrom(context, other);
    }

    public boolean isAssignableFrom(Context context, CategoryType other) {
        return "Any".equals(this.getTypeName()) || other.isDerivedFrom(context, this) || other.isDerivedFromAnonymous(context, this);
    }

    public boolean isDerivedFrom(Context context, IType other) {
        if (!(other instanceof CategoryType)) {
            return false;
        }
        return this.isDerivedFrom(context, (CategoryType)other);
    }

    public boolean isDerivedFrom(Context context, CategoryType other) {
        try {
            IDeclaration thisDecl = this.getDeclaration(context);
            if (thisDecl instanceof CategoryDeclaration) {
                return this.isDerivedFrom(context, (CategoryDeclaration)thisDecl, other);
            }
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
        return false;
    }

    public boolean isDerivedFrom(Context context, CategoryDeclaration decl, CategoryType other) {
        if (decl.getDerivedFrom() == null) {
            return false;
        }
        for (Identifier derived : decl.getDerivedFrom()) {
            CategoryType ct = new CategoryType(derived);
            if (!ct.equals(other) && !ct.isDerivedFrom(context, other)) continue;
            return true;
        }
        return false;
    }

    public boolean isDerivedFromAnonymous(Context context, IType other) {
        if (!(other instanceof CategoryType)) {
            return false;
        }
        return this.isDerivedFromAnonymous(context, (CategoryType)other);
    }

    public boolean isDerivedFromAnonymous(Context context, CategoryType other) {
        if (!other.isAnonymous()) {
            return false;
        }
        try {
            IDeclaration thisDecl = this.getDeclaration(context);
            if (thisDecl instanceof CategoryDeclaration) {
                return this.isDerivedFromAnonymous(context, (CategoryDeclaration)thisDecl, other);
            }
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
        return false;
    }

    public boolean isDerivedFromAnonymous(Context context, CategoryDeclaration thisDecl, CategoryType other) {
        if (!other.isAnonymous()) {
            return false;
        }
        try {
            IDeclaration otherDecl = other.getDeclaration(context);
            if (otherDecl instanceof CategoryDeclaration) {
                return this.isDerivedFromAnonymous(context, thisDecl, (CategoryDeclaration)otherDecl);
            }
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
        return false;
    }

    public boolean isDerivedFromAnonymous(Context context, CategoryDeclaration thisDecl, CategoryDeclaration otherDecl) {
        Identifier baseName = (Identifier)otherDecl.getDerivedFrom().get(0);
        if (!"any".equals(baseName.toString()) && !thisDecl.isDerivedFrom(context, new CategoryType(baseName))) {
            return false;
        }
        for (Identifier attribute : otherDecl.getAllAttributes(context)) {
            if (thisDecl.hasAttribute(context, attribute)) continue;
            return false;
        }
        return true;
    }

    public boolean isAnonymous() {
        return Character.isLowerCase(this.getTypeName().charAt(0));
    }

    @Override
    public boolean isMoreSpecificThan(Context context, IType other) {
        if (other instanceof NullType || other instanceof AnyType || other instanceof MissingType) {
            return true;
        }
        if (!(other instanceof CategoryType)) {
            return false;
        }
        CategoryType otherCat = (CategoryType)other;
        if (otherCat.isAnonymous()) {
            return true;
        }
        CategoryDeclaration thisDecl = context.getRegisteredDeclaration(CategoryDeclaration.class, this.typeNameId);
        return thisDecl.isDerivedFrom(context, otherCat);
    }

    public Score compareSpecificity(Context context, CategoryType t1, CategoryType t2) {
        if (t1.equals(t2)) {
            return Score.SIMILAR;
        }
        if (this.equals(t1)) {
            return Score.BETTER;
        }
        if (this.equals(t2)) {
            return Score.WORSE;
        }
        if (t1.isMoreSpecificThan(context, t2)) {
            return Score.BETTER;
        }
        if (t2.isMoreSpecificThan(context, t1)) {
            return Score.WORSE;
        }
        return Score.SIMILAR;
    }

    public IInstance newInstance(Context context) throws PromptoError {
        CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, this.typeNameId);
        IInstance inst = decl.newInstance(context);
        inst.setMutable(this.mutable);
        return inst;
    }

    public IInstance newInstance(Context context, IStored stored) throws PromptoError {
        CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, this.typeNameId);
        IInstance inst = decl.newInstance(context, stored);
        inst.setMutable(this.mutable);
        return inst;
    }

    @Override
    public IValue readJSONValue(Context context, JsonNode value, Map<String, byte[]> parts) {
        if (value.isNull()) {
            return NullValue.instance();
        }
        try {
            IDeclaration declaration = this.getDeclaration(context);
            if (declaration instanceof CategoryDeclaration) {
                return this.readJSONInstance(context, (CategoryDeclaration)declaration, value, parts);
            }
            if (declaration instanceof EnumeratedNativeDeclaration) {
                return ((EnumeratedNativeDeclaration)declaration).readJSONValue(context, value);
            }
            throw new InvalidParameterException();
        }
        catch (PromptoError e) {
            throw new RuntimeException(e);
        }
    }

    private IValue readJSONInstance(Context context, CategoryDeclaration declaration, JsonNode value, Map<String, byte[]> parts) throws PromptoError {
        if (declaration instanceof IEnumeratedDeclaration) {
            return ((IEnumeratedDeclaration)((Object)declaration)).getSymbol(value.asText());
        }
        IInstance instance = this.newInstance(context);
        instance.setMutable(true);
        this.readJSONDbId(context, value, instance);
        this.readJSONFields(context, value, instance, parts);
        instance.setMutable(this.mutable);
        return instance;
    }

    private void readJSONFields(Context context, JsonNode value, IInstance instance, Map<String, byte[]> parts) throws PromptoError {
        Iterator fields = value.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            if ("dbId".equals(field.getKey())) continue;
            this.readJSONField(context, instance, (String)field.getKey(), (JsonNode)field.getValue(), parts);
        }
    }

    private void readJSONField(Context context, IInstance instance, String fieldName, JsonNode fieldData, Map<String, byte[]> parts) throws PromptoError {
        NullValue fieldValue;
        Identifier fieldId = new Identifier(fieldName);
        IType fieldType = this.readJSONFieldType(context, fieldId, fieldData);
        if (fieldData.isObject() && !(fieldType instanceof EnumeratedNativeType) && !(fieldType instanceof EnumeratedCategoryType)) {
            fieldData = fieldData.get("value");
        }
        IValue iValue = fieldValue = fieldData == null ? NullValue.instance() : fieldType.readJSONValue(context, fieldData, parts);
        if (fieldValue != null) {
            instance.setMember(context, fieldId, fieldValue);
        }
    }

    private IType readJSONFieldType(Context context, Identifier fieldId, JsonNode fieldData) {
        AttributeDeclaration attribute = context.getRegisteredDeclaration(AttributeDeclaration.class, fieldId);
        IType fieldType = attribute.getType(context);
        return this.checkDerivedType(context, fieldType, fieldData);
    }

    private IType checkDerivedType(Context context, IType fieldType, JsonNode fieldData) {
        if (fieldType instanceof CategoryType) {
            if (fieldData.isObject() && fieldData.has("type")) {
                return new CategoryType(new Identifier(fieldData.get("type").asText()));
            }
            IDeclaration declaration = CategoryType.getDeclaration(context, fieldType.getTypeNameId());
            return declaration.getType(context);
        }
        return fieldType;
    }

    private void readJSONDbId(Context context, JsonNode value, IInstance instance) throws PromptoError {
        if (value.has("dbId")) {
            IType fieldType = TypeUtils.typeToIType(DataStore.getInstance().getDbIdClass());
            JsonNode fieldData = value.get("dbId");
            if (fieldData.isObject()) {
                fieldData = fieldData.get("value");
            }
            IValue dbid = fieldType.readJSONValue(context, fieldData, null);
            instance.setMember(context, new Identifier("dbId"), dbid);
        }
    }

    @Override
    public IValue convertIValueToIValue(Context context, IValue value) {
        if (this.isAssignableFrom(context, value.getType())) {
            return value;
        }
        return super.convertIValueToIValue(context, value);
    }

    @Override
    public IValue convertJavaValueToIValue(Context context, Object value) {
        try {
            IDeclaration decl = this.getDeclaration(context);
            if (decl instanceof IEnumeratedDeclaration) {
                return context.getRegisteredSymbol(new Identifier(value.toString()), true);
            }
            if (decl instanceof CategoryDeclaration) {
                return this.convertJavaValueToPromptoValue(context, (CategoryDeclaration)decl, value);
            }
        }
        catch (Exception e) {
            logger.error(() -> "Unable to convert Java value '" + String.valueOf(value) + "' to IValue", e);
        }
        return super.convertJavaValueToIValue(context, value);
    }

    private IValue convertJavaValueToPromptoValue(Context context, CategoryDeclaration decl, Object value) throws PromptoError {
        if (DataStore.getInstance().getDbIdClass().isInstance(value)) {
            value = DataStore.getInstance().fetchUnique(value);
        }
        if (value == null) {
            return NullValue.instance();
        }
        if (value instanceof IStored) {
            return this.convertStoredToPromptoValue(context, decl, (IStored)value);
        }
        return super.convertJavaValueToIValue(context, value);
    }

    private IValue convertStoredToPromptoValue(Context context, CategoryDeclaration decl, IStored stored) {
        String[] categories = stored.getCategories();
        String actualTypeName = categories[categories.length - 1];
        if (!actualTypeName.equals(this.typeNameId.toString())) {
            decl = (CategoryDeclaration)CategoryType.getDeclaration(context, new Identifier(actualTypeName));
        }
        return decl.newInstance(context, stored);
    }

    public ResultInfo compileSetMember(Context context, MethodInfo method, Flags flags, IExpression parent, IExpression value, Identifier id) {
        IDeclaration decl = this.getDeclaration(context);
        if (decl instanceof SingletonCategoryDeclaration) {
            value.compile(context, method, flags);
            return ((SingletonCategoryDeclaration)decl).compileSetStaticMember(context, method, flags, id);
        }
        if (this.couldBeImplicitThis(decl, flags)) {
            MemberInstance instance = new MemberInstance(id);
            instance.setParent(new VariableInstance(new Identifier("this")));
            return instance.compileAssign(context, method, flags, value);
        }
        throw new SyntaxError("No static member support for non-singleton " + decl.getName());
    }

    private boolean couldBeImplicitThis(IDeclaration decl, Flags flags) {
        return decl instanceof ConcreteCategoryDeclaration && flags.isMember();
    }

    @Override
    public ResultInfo compileGetStaticMember(Context context, MethodInfo method, Flags flags, Identifier id) {
        IDeclaration decl = this.getDeclaration(context);
        if (decl instanceof SingletonCategoryDeclaration) {
            return ((SingletonCategoryDeclaration)decl).compileGetStaticMember(context, method, flags, id);
        }
        if (decl instanceof EnumeratedCategoryDeclaration) {
            return ((EnumeratedCategoryDeclaration)decl).compileGetStaticMember(context, method, flags, id);
        }
        if (decl instanceof EnumeratedNativeDeclaration) {
            return ((EnumeratedNativeDeclaration)decl).compileGetStaticMember(context, method, flags, id);
        }
        return super.compileGetStaticMember(context, method, flags, id);
    }

    @Override
    public void compileGetStorableData(Context context, MethodInfo method, Flags flags) {
        MethodConstant m = new MethodConstant((Type)((Object)PromptoRoot.class), "getStorableData", new Type[]{Object.class, Object.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
    }

    @Override
    public void compileConvertObjectToExact(Context context, MethodInfo method, Flags flags) {
        ClassConstant k = new ClassConstant(this.getJavaType(context));
        method.addInstruction(Opcode.LDC, k);
        MethodConstant m = new MethodConstant((Type)((Object)PromptoRoot.class), "convertObjectToExact", new Type[]{Object.class, Class.class, PromptoRoot.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.CHECKCAST, k);
    }

    @Override
    public void declare(Transpiler transpiler) {
        IType type = this.resolve(transpiler.getContext(), null);
        if (type == this) {
            IDeclaration decl = this.getDeclaration(transpiler.getContext());
            decl.declare(transpiler);
        } else {
            type.declare(transpiler);
        }
    }

    @Override
    public void transpile(Transpiler transpiler) {
        transpiler.append(this.getTypeName());
    }

    @Override
    public void declareSorted(Transpiler transpiler, IExpression key) {
        CategoryDeclaration cd;
        String keyname = key != null ? key.toString() : "key";
        IDeclaration decl = this.getDeclaration(transpiler.getContext());
        if (decl instanceof CategoryDeclaration && ((cd = (CategoryDeclaration)decl).hasAttribute(transpiler.getContext(), new Identifier(keyname)) || cd.hasMethod(transpiler.getContext(), new Identifier(keyname)))) {
            return;
        }
        decl = this.findGlobalMethod(transpiler.getContext(), keyname);
        if (decl != null) {
            decl.declare(transpiler);
        } else if (!(key instanceof ArrowExpression)) {
            key.declare(transpiler);
        }
    }

    @Override
    public void transpileSortedComparator(Transpiler transpiler, IExpression key, boolean descending) {
        String keyname = key != null ? key.toString() : "key";
        IDeclaration decl = this.getDeclaration(transpiler.getContext());
        if (decl instanceof CategoryDeclaration) {
            CategoryDeclaration cd = (CategoryDeclaration)decl;
            if (cd.hasAttribute(transpiler.getContext(), new Identifier(keyname))) {
                this.transpileSortedByAttribute(transpiler, descending, key);
                return;
            }
            if (cd.hasMethod(transpiler.getContext(), new Identifier(keyname))) {
                throw new UnsupportedOperationException();
            }
        }
        if ((decl = this.findGlobalMethod(transpiler.getContext(), keyname)) != null) {
            this.transpileSortedByGlobalMethod(transpiler, descending, decl.getTranspiledName(transpiler.getContext()));
            return;
        }
        if (key instanceof ArrowExpression) {
            ((ArrowExpression)key).transpileSortedComparator(transpiler, this, descending);
        } else {
            this.transpileSortedByExpression(transpiler, descending, key);
        }
    }

    private void transpileSortedByGlobalMethod(Transpiler transpiler, boolean descending, String name) {
        transpiler.append("function(o1, o2) { return ").append(name).append("(o1) === ").append(name).append("(o2)").append(" ? 0 : ").append(name).append("(o1) > ").append(name).append("(o2)").append(" ? ");
        if (descending) {
            transpiler.append("-1 : 1; }");
        } else {
            transpiler.append("1 : -1; }");
        }
    }

    private void transpileSortedByExpression(Transpiler transpiler, boolean descending, IExpression key) {
        this.transpileSortedByAttribute(transpiler, descending, key);
    }

    private void transpileSortedByAttribute(Transpiler transpiler, boolean descending, IExpression key) {
        key = key != null ? key : new InstanceExpression(new Identifier("key"));
        transpiler.append("function(o1, o2) { return ");
        this.transpileEqualAttributes(transpiler, key);
        transpiler.append(" ? 0 : ");
        this.transpileGreaterAttributes(transpiler, key);
        transpiler.append(" ? ");
        if (descending) {
            transpiler.append("-1 : 1; }");
        } else {
            transpiler.append("1 : -1; }");
        }
    }

    private void transpileGreaterAttributes(Transpiler transpiler, IExpression key) {
        transpiler.append("o1.");
        key.transpile(transpiler);
        transpiler.append(" > o2.");
        key.transpile(transpiler);
    }

    private void transpileEqualAttributes(Transpiler transpiler, IExpression key) {
        transpiler.append("o1.");
        key.transpile(transpiler);
        transpiler.append(" === o2.");
        key.transpile(transpiler);
    }

    private IDeclaration findGlobalMethod(Context context, String name) {
        try {
            ValueExpression exp = new ValueExpression(this, this.newInstance(context));
            Argument arg = new Argument(null, exp);
            ArgumentList args = new ArgumentList((Collection<Argument>)Collections.singletonList(arg));
            MethodCall proto = new MethodCall(new MethodSelector(null, new Identifier(name)), args);
            MethodFinder finder = new MethodFinder(context, proto);
            return finder.findBestMethod(true);
        }
        catch (PromptoError error) {
            return null;
        }
    }

    @Override
    public void declareMember(Transpiler transpiler, Identifier name) {
    }

    @Override
    public void transpileMember(Transpiler transpiler, Identifier name) {
        if ("text".equals(name.toString())) {
            transpiler.append("getText()");
        } else {
            transpiler.append(name);
        }
    }

    @Override
    public void declareStaticMember(Transpiler transpiler, Identifier name) {
    }

    @Override
    public void transpileStaticMember(Transpiler transpiler, Identifier name) {
        if (this.getDeclaration(transpiler.getContext()) instanceof SingletonCategoryDeclaration) {
            transpiler.append("instance.");
        }
        transpiler.append(name);
    }

    @Override
    public void transpileAssignMemberValue(Transpiler transpiler, String name, IExpression expression) {
        transpiler.append(".setMember('").append(name).append("', ");
        expression.transpile(transpiler);
        AttributeDeclaration decl = transpiler.getContext().getRegisteredDeclaration(AttributeDeclaration.class, new Identifier(name));
        transpiler.append(", ").append(decl.isStorable(transpiler.getContext())).append(", false");
        IType type = expression.check(transpiler.getContext());
        if (type instanceof EnumeratedCategoryType || type instanceof EnumeratedNativeType) {
            transpiler.append(", true");
        } else {
            transpiler.append(", false");
        }
        transpiler.append(")");
    }

    @Override
    public void transpileInstance(Transpiler transpiler) {
        IDeclaration decl = this.getDeclaration(transpiler.getContext());
        if (decl instanceof SingletonCategoryDeclaration) {
            transpiler.append(this.getTypeName()).append(".instance");
        } else {
            transpiler.append("this");
        }
    }

    @Override
    public void declareAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        IType type = this.checkOperator(transpiler.getContext(), other, tryReverse, Operator.PLUS);
        if (type != null) {
            left.declare(transpiler);
            right.declare(transpiler);
            type.declare(transpiler);
        } else {
            super.declareAdd(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void transpileAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        left.transpile(transpiler);
        transpiler.append(".operator_PLUS").append("$").append(other.getTranspiledName(transpiler.getContext())).append("(");
        right.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareSubtract(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        IType type = this.checkOperator(transpiler.getContext(), other, false, Operator.MINUS);
        if (type != null) {
            left.declare(transpiler);
            right.declare(transpiler);
            type.declare(transpiler);
        } else {
            super.declareSubtract(transpiler, other, left, right);
        }
    }

    @Override
    public void transpileSubtract(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        left.transpile(transpiler);
        transpiler.append(".operator_MINUS").append("$").append(other.getTranspiledName(transpiler.getContext())).append("(");
        right.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareMultiply(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        IType type = this.checkOperator(transpiler.getContext(), other, tryReverse, Operator.MULTIPLY);
        if (type != null) {
            left.declare(transpiler);
            right.declare(transpiler);
            type.declare(transpiler);
        } else {
            super.declareMultiply(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void transpileMultiply(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        left.transpile(transpiler);
        transpiler.append(".operator_MULTIPLY").append("$").append(other.getTranspiledName(transpiler.getContext())).append("(");
        right.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareDivide(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        IType type = this.checkOperator(transpiler.getContext(), other, false, Operator.DIVIDE);
        if (type != null) {
            transpiler.require("divide");
            left.declare(transpiler);
            right.declare(transpiler);
            type.declare(transpiler);
        } else {
            super.declareDivide(transpiler, other, left, right);
        }
    }

    @Override
    public void transpileDivide(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        left.transpile(transpiler);
        transpiler.append(".operator_DIVIDE").append("$").append(other.getTranspiledName(transpiler.getContext())).append("(");
        right.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareIntDivide(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        IType type = this.checkOperator(transpiler.getContext(), other, false, Operator.IDIVIDE);
        if (type != null) {
            transpiler.require("divide");
            left.declare(transpiler);
            right.declare(transpiler);
            type.declare(transpiler);
        } else {
            super.declareIntDivide(transpiler, other, left, right);
        }
    }

    @Override
    public void transpileIntDivide(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        left.transpile(transpiler);
        transpiler.append(".operator_IDIVIDE").append("$").append(other.getTranspiledName(transpiler.getContext())).append("(");
        right.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareModulo(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        IType type = this.checkOperator(transpiler.getContext(), other, false, Operator.MODULO);
        if (type != null) {
            transpiler.require("divide");
            left.declare(transpiler);
            right.declare(transpiler);
            type.declare(transpiler);
        } else {
            super.declareModulo(transpiler, other, left, right);
        }
    }

    @Override
    public void transpileModulo(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        left.transpile(transpiler);
        transpiler.append(".operator_MODULO").append("$").append(other.getTranspiledName(transpiler.getContext())).append("(");
        right.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public Comparator<? extends IValue> getComparator(Context context, IExpression key, boolean descending) {
        IDeclaration d;
        if (key == null) {
            key = new UnresolvedIdentifier(new Identifier("key"));
        }
        if ((d = this.getDeclaration(context)) instanceof CategoryDeclaration) {
            CategoryDeclaration decl = (CategoryDeclaration)d;
            Identifier keyAsId = new Identifier(key.toString());
            if (decl.hasAttribute(context, keyAsId)) {
                return this.newAttributeComparator(context, keyAsId, descending);
            }
            if (decl.hasMethod(context, keyAsId)) {
                return this.newMemberMethodComparator(context, keyAsId, descending);
            }
            MethodCall call = this.createGlobalMethodCallIfExists(context, keyAsId);
            if (call != null) {
                return this.newGlobalMethodComparator(context, call, descending);
            }
            if (key instanceof ArrowExpression) {
                return ((ArrowExpression)key).getComparator(context, this, descending);
            }
            return this.newExpressionComparator(context, key, descending);
        }
        throw new UnsupportedOperationException();
    }

    private Comparator<? extends IValue> newMemberMethodComparator(Context context, Identifier methodName, boolean descending) {
        throw new UnsupportedOperationException();
    }

    public MethodCall createGlobalMethodCallIfExists(Context context, Identifier methodName) {
        try {
            ValueExpression exp = new ValueExpression(this, this.newInstance(context));
            Argument arg = new Argument(null, exp);
            ArgumentList args = new ArgumentList((Collection<Argument>)Collections.singletonList(arg));
            MethodCall call = new MethodCall(new MethodSelector(methodName), args);
            MethodFinder finder = new MethodFinder(context, call);
            IMethodDeclaration decl = finder.findBestMethod(true);
            if (decl == null) {
                return null;
            }
            return call;
        }
        catch (PromptoError e) {
            return null;
        }
    }

    private Comparator<? extends IValue> newAttributeComparator(final Context context, final Identifier name, boolean descending) {
        final BiFunction<IValue, IValue, Integer> cmpValues = BaseType.getValuesComparator(descending);
        return new Comparator<IInstance>(){

            @Override
            public int compare(IInstance o1, IInstance o2) {
                try {
                    IValue key1 = o1.getMember(context, name, false);
                    IValue key2 = o2.getMember(context, name, false);
                    return (Integer)cmpValues.apply(key1, key2);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        };
    }

    private Comparator<? extends IValue> newGlobalMethodComparator(final Context context, final MethodCall call, boolean descending) throws PromptoError {
        final BiFunction<IValue, IValue, Integer> cmpValues = BaseType.getValuesComparator(descending);
        return new Comparator<IInstance>(){

            @Override
            public int compare(IInstance o1, IInstance o2) {
                try {
                    IValue key1 = this.interpret(o1);
                    IValue key2 = this.interpret(o2);
                    return (Integer)cmpValues.apply(key1, key2);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }

            private IValue interpret(IInstance o) throws PromptoError {
                Argument argument = (Argument)call.getArguments().getFirst();
                argument.setExpression(new ValueExpression(CategoryType.this, o));
                return call.interpret(context);
            }
        };
    }

    private Comparator<? extends IValue> newExpressionComparator(final Context context, final IExpression key, boolean descending) {
        final BiFunction<IValue, IValue, Integer> cmpValues = BaseType.getValuesComparator(descending);
        return new Comparator<IInstance>(){

            @Override
            public int compare(IInstance o1, IInstance o2) {
                try {
                    IValue key1 = this.interpret(o1);
                    IValue key2 = this.interpret(o2);
                    return (Integer)cmpValues.apply(key1, key2);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }

            private IValue interpret(IInstance o) throws PromptoError {
                Context co = context.newInstanceContext(o, false);
                return key.interpret(co);
            }
        };
    }

    @Override
    public ResultInfo compileSorted(Context context, MethodInfo method, Flags flags, ResultInfo srcInfo, IExpression key, boolean descending) {
        if (key == null) {
            key = new UnresolvedIdentifier(new Identifier("key"));
        }
        this.compileComparator(context, method, flags, key, descending);
        MethodConstant m = new MethodConstant(srcInfo.getType(), "sortUsing", new Type[]{Comparator.class, PromptoList.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        return new ResultInfo((Type)((Object)PromptoList.class), new ResultInfo.Flag[0]);
    }

    private ResultInfo compileComparator(Context context, MethodInfo method, Flags flags, IExpression key, boolean descending) {
        IDeclaration decl = this.getDeclaration(context);
        if (decl instanceof CategoryDeclaration) {
            Type cmpType = this.compileComparatorClass(context, method.getClassFile(), (CategoryDeclaration)decl, key, descending);
            return CompilerUtils.compileNewInstance(method, cmpType);
        }
        throw new UnsupportedOperationException();
    }

    private Type compileComparatorClass(Context context, ClassFile parentClass, CategoryDeclaration decl, IExpression key, boolean descending) {
        ComparatorCompiler compiler = this.getComparatorCompiler(context, decl, key);
        return compiler.compile(context, parentClass, this, key, descending);
    }

    private ComparatorCompiler getComparatorCompiler(Context context, CategoryDeclaration decl, IExpression key) {
        Identifier keyAsId = new Identifier(key.toString());
        if (decl.hasAttribute(context, keyAsId)) {
            return new AttributeComparatorCompiler();
        }
        if (decl.hasMethod(context, keyAsId)) {
            return new MemberMethodComparatorCompiler();
        }
        MethodCall call = this.createGlobalMethodCallIfExists(context, keyAsId);
        if (call != null) {
            return new GlobalMethodComparatorCompiler(call);
        }
        if (key instanceof ArrowExpression) {
            return new ArrowExpressionComparatorCompiler();
        }
        return new ExpressionComparatorCompiler();
    }

    class GlobalMethodComparatorCompiler
    extends ComparatorCompilerBase {
        MethodCall call;

        public GlobalMethodComparatorCompiler(MethodCall call) {
            this.call = call;
        }

        @Override
        protected void compileMethodBody(Context context, MethodInfo method, IType paramIType, IExpression key) {
            Type paramType = paramIType.getJavaType(context);
            this.compileValue(context, method, paramType, "o1");
            this.compileValue(context, method, paramType, "o2");
            MethodConstant compare = new MethodConstant((Type)((Object)ObjectUtils.class), "safeCompare", new Type[]{Object.class, Object.class, Integer.TYPE});
            method.addInstruction(Opcode.INVOKESTATIC, compare);
            method.addInstruction(Opcode.IRETURN, new IOperand[0]);
        }

        private ResultInfo compileValue(Context context, MethodInfo method, Type paramType, String paramName) {
            context.registerValue(new Variable(new Identifier(paramName), CategoryType.this));
            Argument argument = (Argument)this.call.getArguments().getFirst();
            argument.setExpression(new UnresolvedIdentifier(new Identifier(paramName)));
            return this.call.compile(context, method, new Flags());
        }
    }

    class MemberMethodComparatorCompiler
    extends ComparatorCompilerBase {
        MemberMethodComparatorCompiler() {
        }

        @Override
        protected void compileMethodBody(Context context, MethodInfo method, IType paramIType, IExpression key) {
            throw new UnsupportedOperationException();
        }
    }

    class ExpressionComparatorCompiler
    extends ComparatorCompilerBase {
        ExpressionComparatorCompiler() {
        }

        @Override
        protected void compileMethodBody(Context context, MethodInfo method, IType paramIType, IExpression key) {
            Type paramType = paramIType.getJavaType(context);
            StackLocal tmpThis = method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(paramType));
            this.compileValue(context, method, paramType, key, tmpThis, "o1");
            this.compileValue(context, method, paramType, key, tmpThis, "o2");
            MethodConstant compare = new MethodConstant((Type)((Object)ObjectUtils.class), "safeCompare", new Type[]{Object.class, Object.class, Integer.TYPE});
            method.addInstruction(Opcode.INVOKESTATIC, compare);
            method.addInstruction(Opcode.IRETURN, new IOperand[0]);
        }

        private ResultInfo compileValue(Context context, MethodInfo method, Type paramType, IExpression key, StackLocal tmpThis, String paramName) {
            StackLocal param = method.getRegisteredLocal(paramName);
            Opcode opcode = Opcode.values()[Opcode.ALOAD_0.ordinal() + param.getIndex()];
            method.addInstruction(opcode, new ClassConstant(paramType));
            method.addInstruction(Opcode.ASTORE, new ByteOperand((byte)tmpThis.getIndex()));
            return key.compile(context.newInstanceContext(CategoryType.this, false), method, new Flags());
        }
    }

    class AttributeComparatorCompiler
    extends ComparatorCompilerBase {
        AttributeComparatorCompiler() {
        }

        @Override
        protected void compileMethodBody(Context context, MethodInfo method, IType paramIType, IExpression key) {
            Type paramType = paramIType.getJavaType(context);
            method.addInstruction(Opcode.ALOAD_1, new ClassConstant(paramType));
            Type fieldType = context.findAttribute(key.toString()).getType().getJavaType(context);
            String getterName = CompilerUtils.getterName(key.toString());
            InterfaceConstant getter = new InterfaceConstant(paramType, getterName, fieldType);
            method.addInstruction(Opcode.INVOKEINTERFACE, getter);
            method.addInstruction(Opcode.ALOAD_2, new ClassConstant(paramType));
            method.addInstruction(Opcode.INVOKEINTERFACE, getter);
            MethodConstant compare = new MethodConstant((Type)((Object)ObjectUtils.class), "safeCompare", new Type[]{Object.class, Object.class, Integer.TYPE});
            method.addInstruction(Opcode.INVOKESTATIC, compare);
            method.addInstruction(Opcode.IRETURN, new IOperand[0]);
        }
    }
}

