/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Type;
import java.security.InvalidParameterException;
import java.util.Comparator;
import java.util.Map;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.ShortOperand;
import prompto.compiler.StackState;
import prompto.expression.IExpression;
import prompto.grammar.CmpOp;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoChar;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.NativeType;
import prompto.type.RangeType;
import prompto.type.TextType;
import prompto.value.CharacterRange;
import prompto.value.CharacterValue;
import prompto.value.IValue;
import prompto.value.RangeBase;

public class CharacterType
extends NativeType {
    static CharacterType instance = new CharacterType();
    public static Opcode[] CMP_OPCODES = CharacterType.createOpcodes();

    public static CharacterType instance() {
        return instance;
    }

    private CharacterType() {
        super(Family.CHARACTER);
    }

    @Override
    public Type getJavaType(Context context) {
        return Character.class;
    }

    @Override
    public IType checkAdd(Context context, IType other, boolean tryReverse) {
        return TextType.instance();
    }

    @Override
    public IType checkMultiply(Context context, IType other, boolean tryReverse) {
        if (other instanceof IntegerType) {
            return TextType.instance();
        }
        return super.checkMultiply(context, other, tryReverse);
    }

    @Override
    public IType checkCompare(Context context, IType other, ISection section) {
        if (other instanceof CharacterType || other instanceof TextType) {
            return BooleanType.instance();
        }
        return super.checkCompare(context, other, section);
    }

    @Override
    public IType checkMember(Context context, Identifier id) {
        String name = id.toString();
        if ("codePoint".equals(name)) {
            return IntegerType.instance();
        }
        return super.checkMember(context, id);
    }

    @Override
    public IType checkRange(Context context, IType other) {
        if (other instanceof CharacterType) {
            return new RangeType(this);
        }
        return super.checkRange(context, other);
    }

    @Override
    public RangeBase<?> newRange(Object left, Object right) {
        if (left instanceof CharacterValue && right instanceof CharacterValue) {
            return new CharacterRange((CharacterValue)left, (CharacterValue)right);
        }
        return super.newRange(left, right);
    }

    public Comparator<CharacterValue> getNativeComparator(boolean descending) {
        return descending ? new Comparator<CharacterValue>(){

            @Override
            public int compare(CharacterValue o1, CharacterValue o2) {
                return Character.compare(o2.getValue(), o1.getValue());
            }
        } : new Comparator<CharacterValue>(){

            @Override
            public int compare(CharacterValue o1, CharacterValue o2) {
                return Character.compare(o1.getValue(), o2.getValue());
            }
        };
    }

    @Override
    public String toString(Object value) {
        return "'" + value.toString() + "'";
    }

    @Override
    public IValue convertJavaValueToIValue(Context context, Object value) {
        if (value instanceof Character) {
            return new CharacterValue(((Character)value).charValue());
        }
        return (IValue)value;
    }

    @Override
    public IValue readJSONValue(Context context, JsonNode value, Map<String, byte[]> parts) {
        if (value.asText().length() > 1) {
            throw new InvalidParameterException(value.toString());
        }
        return new CharacterValue(value.asText().charAt(0));
    }

    @Override
    public void declare(Transpiler transpiler) {
    }

    @Override
    public void declareAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        left.declare(transpiler);
        right.declare(transpiler);
    }

    @Override
    public void transpileAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        left.transpile(transpiler);
        transpiler.append(" + ");
        right.transpile(transpiler);
    }

    @Override
    public void declareMultiply(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (other == IntegerType.instance()) {
            left.declare(transpiler);
            right.declare(transpiler);
        } else {
            super.declareMultiply(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void transpileMultiply(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (other == IntegerType.instance()) {
            left.transpile(transpiler);
            transpiler.append(".repeat(");
            right.transpile(transpiler);
            transpiler.append(")");
        } else {
            super.transpileMultiply(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void declareMember(Transpiler transpiler, Identifier name) {
        if (!"codePoint".equals(name.toString())) {
            super.declareMember(transpiler, name);
        }
    }

    @Override
    public void transpileMember(Transpiler transpiler, Identifier name) {
        if ("codePoint".equals(name.toString())) {
            transpiler.append("charCodeAt(0)");
        } else {
            super.transpileMember(transpiler, name);
        }
    }

    @Override
    public void declareRange(Transpiler transpiler, IType other) {
        if (other == CharacterType.instance()) {
            transpiler.require("Range");
            transpiler.require("IntegerRange");
            transpiler.require("CharacterRange");
        } else {
            super.declareRange(transpiler, other);
        }
    }

    @Override
    public void transpileRange(Transpiler transpiler, IExpression first, IExpression last) {
        transpiler.append("new CharacterRange(");
        first.transpile(transpiler);
        transpiler.append(",");
        last.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareCompare(Transpiler transpiler, IType other) {
    }

    @Override
    public void transpileCompare(Transpiler transpiler, IType other, CmpOp operator, IExpression left, IExpression right) {
        left.transpile(transpiler);
        transpiler.append(" ").append(operator.toString()).append(" ");
        right.transpile(transpiler);
    }

    public static Opcode[] createOpcodes() {
        Opcode[] opcodes = new Opcode[CmpOp.values().length];
        opcodes[CmpOp.LT.ordinal()] = Opcode.IF_ICMPLT;
        opcodes[CmpOp.LTE.ordinal()] = Opcode.IF_ICMPLE;
        opcodes[CmpOp.GT.ordinal()] = Opcode.IF_ICMPGT;
        opcodes[CmpOp.GTE.ordinal()] = Opcode.IF_ICMPGE;
        return opcodes;
    }

    public static ResultInfo compileMultiply(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        CompilerUtils.CharacterTochar(method);
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true));
        if (Long.class == right.getType()) {
            CompilerUtils.LongToint(method);
        } else if (Long.TYPE == right.getType()) {
            CompilerUtils.longToint(method);
        }
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoChar.class), "multiply", new Type[]{Character.TYPE, Integer.TYPE, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo compilePlus(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression right) {
        MethodConstant c = new MethodConstant((Type)((Object)Character.class), "toString", new Type[]{String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, c);
        return TextType.compilePlus(context, method, flags, left, right);
    }

    public static ResultInfo compileEquals(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        ResultInfo right;
        if (Character.class == left.getType()) {
            CompilerUtils.CharacterTochar(method);
        }
        if (Character.class == (right = exp.compile(context, method, flags)).getType()) {
            CompilerUtils.CharacterTochar(method);
        }
        Opcode opcode = flags.isReverse() ? Opcode.IF_ICMPNE : Opcode.IF_ICMPEQ;
        method.addInstruction(opcode, new ShortOperand(7));
        StackState branchState = method.captureStackState();
        method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        method.addInstruction(Opcode.GOTO, new ShortOperand(4));
        method.restoreFullStackState(branchState);
        method.placeLabel(branchState);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        StackState lastState = method.captureStackState();
        method.placeLabel(lastState);
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    public static ResultInfo compileCompareTo(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        ResultInfo right;
        if (Character.class == left.getType()) {
            CompilerUtils.CharacterTochar(method);
        }
        if (Character.class == (right = exp.compile(context, method, flags.withPrimitive(true))).getType()) {
            CompilerUtils.CharacterTochar(method);
        }
        Opcode opcode = CMP_OPCODES[flags.cmpOp().ordinal()];
        method.addInstruction(opcode, new ShortOperand(7));
        StackState branchState = method.captureStackState();
        method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        method.addInstruction(Opcode.GOTO, new ShortOperand(4));
        method.restoreFullStackState(branchState);
        method.placeLabel(branchState);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        StackState lastState = method.captureStackState();
        method.placeLabel(lastState);
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }
}

