/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.declaration.BuiltInMethodDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDict;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.ContainerType;
import prompto.type.EntryType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.IterableType;
import prompto.type.ListType;
import prompto.type.SetType;
import prompto.type.TextType;
import prompto.value.DictionaryValue;
import prompto.value.IValue;

public class DictType
extends ContainerType {
    static final IMethodDeclaration SWAP_METHOD = new BuiltInMethodDeclaration("swap"){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            DictionaryValue dict = (DictionaryValue)this.getValue(context);
            return dict.swap(context);
        }

        @Override
        public IType check(Context context) {
            return new DictType(TextType.instance());
        }

        @Override
        public boolean hasCompileExactInstanceMember() {
            return true;
        }

        @Override
        public ResultInfo compileExactInstanceMember(Context context, MethodInfo method, Flags flags, ArgumentList arguments) {
            this.compileParameters(context, method, flags, arguments);
            Descriptor.Method descriptor = new Descriptor.Method(new Type[]{PromptoDict.class});
            MethodConstant constant = new MethodConstant((Type)((Object)PromptoDict.class), "swap", descriptor);
            method.addInstruction(Opcode.INVOKEVIRTUAL, constant);
            return new ResultInfo((Type)((Object)PromptoDict.class), new ResultInfo.Flag[0]);
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("swap()");
        }
    };

    public DictType(IType itemType) {
        super(Family.DICTIONARY, itemType, itemType.getTypeName() + "<:>");
    }

    @Override
    public IterableType withItemType(IType itemType) {
        return new DictType(itemType);
    }

    @Override
    public boolean isAssignableFrom(Context context, IType other) {
        return super.isAssignableFrom(context, other) || other instanceof DictType && this.itemType.isAssignableFrom(context, ((DictType)other).getItemType());
    }

    @Override
    public Type getJavaType(Context context) {
        return PromptoDict.class;
    }

    @Override
    public String getTranspiledName(Context context) {
        return this.itemType.getTranspiledName(context) + "_dict";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DictType)) {
            return false;
        }
        DictType other = (DictType)obj;
        return this.getItemType().equals(other.getItemType());
    }

    @Override
    public IType checkAdd(Context context, IType other, boolean tryReverse) {
        if (other instanceof DictType && this.getItemType().equals(((DictType)other).getItemType())) {
            return this;
        }
        return super.checkAdd(context, other, tryReverse);
    }

    @Override
    public IType checkContains(Context context, IType other) {
        if (other == TextType.instance()) {
            return BooleanType.instance();
        }
        return super.checkContains(context, other);
    }

    @Override
    public IType checkItem(Context context, IType other) {
        if (other == TextType.instance()) {
            return this.itemType;
        }
        return super.checkItem(context, other);
    }

    @Override
    public IType checkIterator(Context context) {
        return new EntryType(this.itemType);
    }

    @Override
    public IType checkMember(Context context, Identifier id) {
        String name;
        switch (name = id.toString()) {
            case "count": {
                return IntegerType.instance();
            }
            case "keys": {
                return new SetType(TextType.instance());
            }
            case "values": {
                return new ListType(this.getItemType());
            }
        }
        return super.checkMember(context, id);
    }

    @Override
    public Set<IMethodDeclaration> getMemberMethods(Context context, Identifier id) throws PromptoError {
        if ("swap".equals(id.toString())) {
            return new HashSet<IMethodDeclaration>(Collections.singletonList(SWAP_METHOD));
        }
        return super.getMemberMethods(context, id);
    }

    @Override
    public IType checkContainsAllOrAny(Context context, IType other) {
        return BooleanType.instance();
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("Dictionary");
    }

    @Override
    public void declareAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (other instanceof DictType && this.getItemType().equals(((DictType)other).getItemType())) {
            left.declare(transpiler);
            right.declare(transpiler);
        } else {
            super.declareAdd(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void transpileAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (other instanceof DictType && this.getItemType().equals(((DictType)other).getItemType())) {
            left.transpile(transpiler);
            transpiler.append(".add(");
            right.transpile(transpiler);
            transpiler.append(")");
        } else {
            super.transpileAdd(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void declareMember(Transpiler transpiler, Identifier name) {
        switch (name.toString()) {
            case "count": {
                break;
            }
            case "keys": {
                transpiler.require("StrictSet");
                break;
            }
            case "values": {
                transpiler.require("List");
                break;
            }
            default: {
                super.declareMember(transpiler, name);
            }
        }
    }

    @Override
    public void transpileMember(Transpiler transpiler, Identifier name) {
        switch (name.toString()) {
            case "count": {
                transpiler.append("length");
                break;
            }
            case "keys": 
            case "values": {
                transpiler.append(name);
                break;
            }
            default: {
                super.transpileMember(transpiler, name);
            }
        }
    }

    @Override
    public void declareContains(Transpiler transpiler, IType other, IExpression container, IExpression item) {
        transpiler.require("StrictSet");
        container.declare(transpiler);
        item.declare(transpiler);
    }

    @Override
    public void transpileContains(Transpiler transpiler, IType other, IExpression container, IExpression item) {
        container.transpile(transpiler);
        transpiler.append(".has(");
        item.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareContainsAllOrAny(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        transpiler.require("StrictSet");
        container.declare(transpiler);
        items.declare(transpiler);
    }

    @Override
    public void transpileContainsAll(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        container.transpile(transpiler);
        transpiler.append(".hasAll(");
        items.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void transpileContainsAny(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        container.transpile(transpiler);
        transpiler.append(".hasAny(");
        items.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareItem(Transpiler transpiler, IType itemType, IExpression item) {
    }

    @Override
    public void transpileItem(Transpiler transpiler, IType itemType, IExpression item) {
        transpiler.append(".item(");
        item.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void transpileAssignItemValue(Transpiler transpiler, IExpression item, IExpression expression) {
        transpiler.append(".setItem(");
        item.transpile(transpiler);
        transpiler.append(", ");
        expression.transpile(transpiler);
        transpiler.append(")");
    }

    public static ResultInfo compilePlus(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        ResultInfo info = CompilerUtils.compileNewRawInstance(method, PromptoDict.class);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        CompilerUtils.compileCallConstructor(method, PromptoDict.class, new Type[]{Boolean.TYPE});
        method.addInstruction(Opcode.DUP_X1, new IOperand[0]);
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoDict.class), "putAll", new Type[]{Map.class, Void.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        exp.compile(context, method, flags);
        oper = new MethodConstant((Type)((Object)PromptoDict.class), "putAll", new Type[]{Map.class, Void.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        MethodConstant m = new MethodConstant((Type)((Object)PromptoDict.class), "setMutable", Boolean.TYPE, Void.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        return info;
    }

    public static ResultInfo compileItem(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        exp.compile(context, method, flags.withPrimitive(true));
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoDict.class), "get", new Type[]{Object.class, Object.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo((Type)((Object)Object.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo compileEquals(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        exp.compile(context, method, flags);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoDict.class), "equals", new Type[]{Object.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        if (flags.isReverse()) {
            CompilerUtils.reverseBoolean(method);
        }
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }
}

