/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import prompto.declaration.BuiltInMethodDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IEnumeratedDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.param.CategoryParameter;
import prompto.param.IParameter;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.type.ListType;
import prompto.type.TextType;
import prompto.value.IValue;
import prompto.value.NullValue;

public class EnumeratedCategoryType
extends CategoryType {
    static IParameter NAME_ARGUMENT = new CategoryParameter(TextType.instance(), new Identifier("name"));
    final IMethodDeclaration SYMBOL_OF_METHOD = new BuiltInMethodDeclaration("symbolOf", NAME_ARGUMENT){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, EnumeratedCategoryType.this.typeNameId);
            if (!(decl instanceof IEnumeratedDeclaration)) {
                throw new SyntaxError(EnumeratedCategoryType.this.typeNameId + " is not an enumerated type!");
            }
            String name = (String)context.getValue(new Identifier("name")).getStorableData();
            Object value = ((IEnumeratedDeclaration)decl).getSymbol(name);
            return value != null ? value : NullValue.instance();
        }

        @Override
        public IType check(Context context) {
            return EnumeratedCategoryType.this;
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("symbolOf(");
            ((Argument)arguments.get(0)).transpile(transpiler, null);
            transpiler.append(")");
        }
    };

    public EnumeratedCategoryType(Identifier id) {
        super(Family.ENUMERATED, id);
    }

    @Override
    public IType asMutable(Context context, boolean mutable) {
        if (mutable) {
            // empty if block
        }
        return this;
    }

    @Override
    public IType checkStaticMember(Context context, Identifier id) {
        String name = id.toString();
        if ("symbols".equals(name)) {
            return new ListType(this);
        }
        return super.checkStaticMember(context, id);
    }

    @Override
    public IType checkMember(Context context, Identifier id) {
        String name = id.toString();
        if ("name".equals(name)) {
            return TextType.instance();
        }
        return super.checkMember(context, id);
    }

    @Override
    public IValue getStaticMemberValue(Context context, Identifier id) {
        String name = id.toString();
        IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, this.typeNameId);
        if (!(decl instanceof IEnumeratedDeclaration)) {
            throw new SyntaxError(name + " is not an enumerated type!");
        }
        if ("symbols".equals(name)) {
            return ((IEnumeratedDeclaration)decl).getSymbolsList();
        }
        return super.getStaticMemberValue(context, id);
    }

    @Override
    public Set<IMethodDeclaration> getStaticMemberMethods(Context context, Identifier name) throws PromptoError {
        if (name.toString().equals("symbolOf")) {
            return new HashSet<IMethodDeclaration>(Collections.singletonList(this.SYMBOL_OF_METHOD));
        }
        return Collections.emptySet();
    }
}

