/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.declaration.IMethodDeclaration;
import prompto.error.InternalError;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.CmpOp;
import prompto.grammar.Identifier;
import prompto.parser.ECleverParser;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.store.FamilyInfo;
import prompto.transpiler.Transpiler;
import prompto.utils.CodeWriter;
import prompto.utils.StringUtils;
import prompto.value.IValue;
import prompto.value.RangeBase;

public interface IType
extends ISection {
    public static IType fromTypeName(Context context, String typeName) throws PromptoError {
        if (Character.isUpperCase(typeName.charAt(0))) {
            try {
                return new ECleverParser(typeName).parse_standalone_type();
            }
            catch (Throwable t) {
                throw new InternalError(t);
            }
        }
        return context.findAttribute(typeName).getType();
    }

    public FamilyInfo getFamilyInfo(Context var1);

    default public IType anyfy() {
        return this;
    }

    default public IType resolve(Context context, Consumer<IType> onError) {
        return this;
    }

    default public String getTypeName() {
        return StringUtils.capitalizeFirst(this.getFamilyInfo(null).getFamily().name());
    }

    default public Identifier getTypeNameId() {
        return new Identifier(this.getTypeName());
    }

    default public boolean isStorable(Context context) {
        return false;
    }

    public Type getJavaType(Context var1);

    public IType checkAdd(Context var1, IType var2, boolean var3);

    public IType checkSubstract(Context var1, IType var2);

    public IType checkDivide(Context var1, IType var2);

    public IType checkIntDivide(Context var1, IType var2);

    public IType checkMultiply(Context var1, IType var2, boolean var3);

    public IType checkModulo(Context var1, IType var2);

    public IType checkCompare(Context var1, IType var2, ISection var3);

    public IType checkItem(Context var1, IType var2);

    public IType checkRange(Context var1, IType var2);

    public IType checkContains(Context var1, IType var2);

    public IType checkContainsAllOrAny(Context var1, IType var2);

    public IType checkIterator(Context var1);

    public IType checkSlice(Context var1);

    public IType checkMember(Context var1, Identifier var2);

    public IType checkStaticMember(Context var1, Identifier var2);

    default public IType asMutable(Context context, boolean mutable) {
        if (mutable) {
            throw new UnsupportedOperationException("Mutable not supported for " + this.getClass());
        }
        return this;
    }

    public void checkUnique(Context var1);

    public void checkExists(Context var1);

    public void checkAssignableFrom(Context var1, IType var2);

    public boolean isAssignableFrom(Context var1, IType var2);

    public boolean isMoreSpecificThan(Context var1, IType var2);

    public RangeBase<?> newRange(Object var1, Object var2);

    public Comparator<? extends IValue> getComparator(Context var1, IExpression var2, boolean var3);

    public Set<IMethodDeclaration> getMemberMethods(Context var1, Identifier var2);

    public IValue getStaticMemberValue(Context var1, Identifier var2);

    public Set<IMethodDeclaration> getStaticMemberMethods(Context var1, Identifier var2);

    public String toString(Object var1);

    public void toDialect(CodeWriter var1);

    public IValue readJSONValue(Context var1, JsonNode var2, Map<String, byte[]> var3);

    default public IValue convertIValueToIValue(Context context, IValue value) {
        throw new UnsupportedOperationException("Cannot convertIValueToPromptoValue for " + this.getClass());
    }

    default public IValue convertJavaValueToIValue(Context context, Object value) {
        throw new UnsupportedOperationException("Cannot convertJavaValueToPromptoValue for " + this.getClass());
    }

    default public void compileConvertObjectToExact(Context context, MethodInfo method, Flags flags) {
        throw new UnsupportedOperationException("Cannot compileConvertObjectToExact for " + this.getClass());
    }

    default public void compileGetStorableData(Context context, MethodInfo method, Flags flags) {
    }

    default public void declare(Transpiler transpiler) {
        throw new UnsupportedOperationException("declare " + this.getClass().getName());
    }

    default public void transpile(Transpiler transpiler) {
        throw new UnsupportedOperationException("transpile " + this.getClass().getName());
    }

    default public void declareAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (!tryReverse) {
            throw new UnsupportedOperationException("declareAdd " + this.getClass().getName());
        }
        other.declareAdd(transpiler, this, false, right, left);
    }

    default public void transpileAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (!tryReverse) {
            throw new UnsupportedOperationException("transpileAdd " + this.getClass().getName());
        }
        other.transpileAdd(transpiler, this, false, right, left);
    }

    default public String getTranspiledName(Context context) {
        throw new UnsupportedOperationException("getTranspiledName " + this.getClass().getName());
    }

    default public void transpileInstance(Transpiler transpiler) {
        throw new UnsupportedOperationException("transpileInstance " + this.getClass().getName());
    }

    default public void declareMember(Transpiler transpiler, Identifier name) {
        if (!"text".equals(name.toString())) {
            transpiler.getContext().getProblemListener().reportUnknownMember(name, name.toString());
        }
    }

    default public void transpileMember(Transpiler transpiler, Identifier name) {
        if (!"text".equals(name.toString())) {
            throw new UnsupportedOperationException("transpileMember " + name + " for " + this.getClass().getName());
        }
        transpiler.append("getText()");
    }

    default public void declareStaticMember(Transpiler transpiler, Identifier name) {
        throw new UnsupportedOperationException("declareStaticMember " + name + " for " + this.getClass().getName());
    }

    default public void transpileStaticMember(Transpiler transpiler, Identifier name) {
        throw new UnsupportedOperationException("transpileStaticMember " + name + " for " + this.getClass().getName());
    }

    default public void declareModulo(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        throw new UnsupportedOperationException("declareModulo " + this.getClass().getName());
    }

    default public void transpileModulo(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        throw new UnsupportedOperationException("transpileModulo " + this.getClass().getName());
    }

    default public void declareDivide(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        throw new UnsupportedOperationException("declareDivide " + this.getClass().getName());
    }

    default public void transpileDivide(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        throw new UnsupportedOperationException("transpileDivide " + this.getClass().getName());
    }

    default public void declareIntDivide(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        throw new UnsupportedOperationException("declareIntDivide " + this.getClass().getName());
    }

    default public void transpileIntDivide(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        throw new UnsupportedOperationException("transpileIntDivide " + this.getClass().getName());
    }

    default public void declareMinus(Transpiler transpiler, IExpression expression) {
        throw new UnsupportedOperationException("declareMinus " + this.getClass().getName());
    }

    default public void transpileMinus(Transpiler transpiler, IExpression expression) {
        throw new UnsupportedOperationException("transpileMinus " + this.getClass().getName());
    }

    default public void declareMultiply(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (!tryReverse) {
            throw new UnsupportedOperationException("declareMultiply " + this.getClass().getName());
        }
        other.declareMultiply(transpiler, this, false, right, left);
    }

    default public void transpileMultiply(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (!tryReverse) {
            throw new UnsupportedOperationException("transpileMultiply " + this.getClass().getName());
        }
        other.transpileMultiply(transpiler, this, false, right, left);
    }

    default public void declareSubtract(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        throw new UnsupportedOperationException("declareSubtract " + this.getClass().getName());
    }

    default public void transpileSubtract(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        throw new UnsupportedOperationException("transpileSubtract " + this.getClass().getName());
    }

    default public void transpileAssignMember(Transpiler transpiler, String name) {
        throw new UnsupportedOperationException("transpileAssignMember " + this.getClass().getName());
    }

    default public void transpileAssignMemberValue(Transpiler transpiler, String name, IExpression expression) {
        throw new UnsupportedOperationException("transpileAssignMemberValue " + this.getClass().getName());
    }

    default public void transpileAssignItemValue(Transpiler transpiler, IExpression item, IExpression expression) {
        throw new UnsupportedOperationException("transpileAssignItemValue " + this.getClass().getName());
    }

    default public void declareSlice(Transpiler transpiler, IExpression first, IExpression last) {
        throw new UnsupportedOperationException("declareSlice " + this.getClass().getName());
    }

    default public void transpileSlice(Transpiler transpiler, IExpression first, IExpression last) {
        throw new UnsupportedOperationException("transpileSlice " + this.getClass().getName());
    }

    default public void declareCompare(Transpiler transpiler, IType other) {
        throw new UnsupportedOperationException("declareCompare " + this.getClass().getName());
    }

    default public void transpileCompare(Transpiler transpiler, IType other, CmpOp operator, IExpression left, IExpression right) {
        throw new UnsupportedOperationException("transpileCompare " + this.getClass().getName());
    }

    default public void declareItem(Transpiler transpiler, IType itemType, IExpression item) {
        throw new UnsupportedOperationException("declareItem " + this.getClass().getName());
    }

    default public void transpileItem(Transpiler transpiler, IType itemType, IExpression item) {
        throw new UnsupportedOperationException("transpileItem " + this.getClass().getName());
    }

    default public void declareRange(Transpiler transpiler, IType lastType) {
        throw new UnsupportedOperationException("declareRange " + this.getClass().getName());
    }

    default public void transpileRange(Transpiler transpiler, IExpression first, IExpression last) {
        throw new UnsupportedOperationException("transpileRange " + this.getClass().getName());
    }

    default public void declareContains(Transpiler transpiler, IType other, IExpression container, IExpression item) {
        throw new UnsupportedOperationException("declareContains " + this.getClass().getName());
    }

    default public void transpileContains(Transpiler transpiler, IType other, IExpression container, IExpression item) {
        throw new UnsupportedOperationException("transpileContains " + this.getClass().getName());
    }

    default public void declareContainsAllOrAny(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        throw new UnsupportedOperationException("declareContainsAllOrAny " + this.getClass().getName());
    }

    default public void transpileContainsAll(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        throw new UnsupportedOperationException("transpileContainsAll " + this.getClass().getName());
    }

    default public void transpileContainsAny(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        throw new UnsupportedOperationException("transpileContainsAny " + this.getClass().getName());
    }

    default public void declareSorted(Transpiler transpiler, IExpression key) {
        throw new UnsupportedOperationException("declareSorted " + this.getClass().getName());
    }

    default public void transpileSortedComparator(Transpiler transpiler, IExpression key, boolean descending) {
        throw new UnsupportedOperationException("transpileSorted " + this.getClass().getName());
    }

    default public void declareIterator(Transpiler transpiler, Identifier id, IExpression expression) {
        throw new UnsupportedOperationException("declareIterator " + this.getClass().getName());
    }

    default public void transpileIterator(Transpiler transpiler, Identifier id, IExpression expression) {
        throw new UnsupportedOperationException("transpileIterator " + this.getClass().getName());
    }

    default public void transpileCode(Transpiler transpiler) {
    }

    default public ResultInfo compileSorted(Context context, MethodInfo method, Flags flags, ResultInfo srcInfo, IExpression key, boolean descending) {
        throw new UnsupportedOperationException("compileSorted " + this.getClass().getName());
    }

    default public ResultInfo compileGetStaticMember(Context context, MethodInfo method, Flags flags, Identifier id) {
        throw new UnsupportedOperationException("compileGetStaticMember " + this.getClass().getName());
    }
}

