/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.NamedType;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.ShortOperand;
import prompto.compiler.StackState;
import prompto.declaration.BuiltInMethodDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.CmpOp;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoChar;
import prompto.intrinsic.PromptoLong;
import prompto.intrinsic.PromptoString;
import prompto.param.CategoryParameter;
import prompto.param.IParameter;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.BaseType;
import prompto.type.BooleanType;
import prompto.type.CharacterType;
import prompto.type.DecimalType;
import prompto.type.EnumeratedNativeType;
import prompto.type.INumberType;
import prompto.type.IType;
import prompto.type.ListType;
import prompto.type.NativeType;
import prompto.type.PeriodType;
import prompto.type.RangeType;
import prompto.type.TextType;
import prompto.utils.CodeWriter;
import prompto.value.DecimalValue;
import prompto.value.IMultiplyable;
import prompto.value.IValue;
import prompto.value.IntegerRange;
import prompto.value.IntegerValue;
import prompto.value.RangeBase;
import prompto.value.TextValue;

public class IntegerType
extends NativeType
implements INumberType {
    static IntegerType instance = new IntegerType();
    static IParameter FORMAT_ARGUMENT = new CategoryParameter(TextType.instance(), new Identifier("format"));
    static final IMethodDeclaration FORMAT_METHOD = new BuiltInMethodDeclaration("format", FORMAT_ARGUMENT){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            Long value = (Long)this.getValue(context).getStorableData();
            String format = (String)context.getValue(new Identifier("format")).getStorableData();
            String result = new DecimalFormat(format).format(value);
            return new TextValue(result);
        }

        @Override
        public IType check(Context context) {
            return TextType.instance();
        }

        @Override
        public void declarationToDialect(CodeWriter writer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasCompileExactInstanceMember() {
            return true;
        }

        @Override
        public ResultInfo compileExactInstanceMember(Context context, MethodInfo method, Flags flags, ArgumentList arguments) {
            this.compileParameters(context, method, flags, arguments);
            CompilerUtils.compileNewRawInstance(method, DecimalFormat.class);
            method.addInstruction(Opcode.DUP_X1, new IOperand[0]);
            method.addInstruction(Opcode.SWAP, new IOperand[0]);
            CompilerUtils.compileCallConstructor(method, DecimalFormat.class, new Type[]{String.class});
            method.addInstruction(Opcode.SWAP, new IOperand[0]);
            Descriptor.Method descriptor = new Descriptor.Method(new Type[]{Object.class, String.class});
            MethodConstant constant = new MethodConstant((Type)((Object)Format.class), "format", descriptor);
            method.addInstruction(Opcode.INVOKEVIRTUAL, constant);
            return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("formatInteger(");
            ((Argument)arguments.get(0)).transpile(transpiler, null);
            transpiler.append(")");
        }
    };

    public static IntegerType instance() {
        return instance;
    }

    private IntegerType() {
        super(Family.INTEGER);
    }

    @Override
    public Type getJavaType(Context context) {
        return Long.class;
    }

    @Override
    public boolean isAssignableFrom(Context context, IType other) {
        return super.isAssignableFrom(context, other) || other instanceof DecimalType;
    }

    @Override
    public IType checkAdd(Context context, IType other, boolean tryReverse) {
        if (other instanceof IntegerType) {
            return this;
        }
        if (other instanceof DecimalType) {
            return other;
        }
        return super.checkAdd(context, other, tryReverse);
    }

    @Override
    public IType checkSubstract(Context context, IType other) {
        if (other instanceof IntegerType) {
            return this;
        }
        if (other instanceof DecimalType) {
            return other;
        }
        return super.checkSubstract(context, other);
    }

    @Override
    public IType checkMultiply(Context context, IType other, boolean tryReverse) {
        if (other instanceof IntegerType) {
            return this;
        }
        if (other instanceof DecimalType) {
            return other;
        }
        if (other instanceof CharacterType) {
            return TextType.instance();
        }
        if (other instanceof TextType) {
            return other;
        }
        if (other instanceof PeriodType) {
            return other;
        }
        if (other instanceof ListType) {
            return other;
        }
        return super.checkMultiply(context, other, tryReverse);
    }

    @Override
    public IType checkDivide(Context context, IType other) {
        if (other instanceof IntegerType) {
            return DecimalType.instance();
        }
        if (other instanceof DecimalType) {
            return other;
        }
        return super.checkDivide(context, other);
    }

    @Override
    public IType checkIntDivide(Context context, IType other) {
        if (other instanceof IntegerType) {
            return this;
        }
        return super.checkIntDivide(context, other);
    }

    @Override
    public IType checkModulo(Context context, IType other) {
        if (other instanceof IntegerType) {
            return this;
        }
        return super.checkModulo(context, other);
    }

    @Override
    public IType checkMember(Context context, Identifier id) {
        if (id.toString().equals("min")) {
            return this;
        }
        if (id.toString().equals("max")) {
            return this;
        }
        return super.checkMember(context, id);
    }

    @Override
    public IValue getStaticMemberValue(Context context, Identifier id) throws PromptoError {
        if (id.toString().equals("min")) {
            return new IntegerValue(Integer.MIN_VALUE);
        }
        if (id.toString().equals("max")) {
            return new IntegerValue(Integer.MAX_VALUE);
        }
        return super.getStaticMemberValue(context, id);
    }

    @Override
    public Set<IMethodDeclaration> getMemberMethods(Context context, Identifier id) throws PromptoError {
        switch (id.toString()) {
            case "format": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(FORMAT_METHOD));
            }
        }
        return super.getMemberMethods(context, id);
    }

    @Override
    public IType checkCompare(Context context, IType other, ISection section) {
        if (other instanceof IntegerType) {
            return BooleanType.instance();
        }
        if (other instanceof DecimalType) {
            return BooleanType.instance();
        }
        return super.checkCompare(context, other, section);
    }

    @Override
    public IType checkRange(Context context, IType other) {
        if (other instanceof IntegerType) {
            return new RangeType(this);
        }
        return super.checkRange(context, other);
    }

    @Override
    public RangeBase<?> newRange(Object left, Object right) {
        if (left instanceof IntegerValue && right instanceof IntegerValue) {
            return new IntegerRange((IntegerValue)left, (IntegerValue)right);
        }
        return super.newRange(left, right);
    }

    public Comparator<IntegerValue> getNativeComparator(boolean descending) {
        return descending ? (o1, o2) -> Long.compare(o2.longValue(), o1.longValue()) : (o1, o2) -> Long.compare(o1.longValue(), o2.longValue());
    }

    @Override
    public IValue convertIValueToIValue(Context context, IValue value) {
        if (value instanceof IntegerValue) {
            return value;
        }
        if (value instanceof DecimalValue) {
            return new IntegerValue(((DecimalValue)value).longValue());
        }
        if (value instanceof TextValue) {
            return IntegerValue.Parse(value.toString());
        }
        return super.convertJavaValueToIValue(context, value);
    }

    @Override
    public IValue convertJavaValueToIValue(Context context, Object value) {
        if (value instanceof Number) {
            return new IntegerValue(((Number)value).longValue());
        }
        return (IValue)value;
    }

    @Override
    public void compileConvertObjectToExact(Context context, MethodInfo method, Flags flags) {
        MethodConstant m = new MethodConstant((Type)((Object)PromptoLong.class), "convertObjectToExact", new Type[]{Object.class, Long.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
    }

    @Override
    public IValue readJSONValue(Context context, JsonNode value, Map<String, byte[]> parts) {
        return new IntegerValue(value.asLong());
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("Utils");
    }

    @Override
    public void transpile(Transpiler transpiler) {
        transpiler.append("'Integer'");
    }

    @Override
    public void declareAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (other == IntegerType.instance() || other == DecimalType.instance()) {
            left.declare(transpiler);
            right.declare(transpiler);
        } else {
            super.declareAdd(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void transpileAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (other == IntegerType.instance() || other == DecimalType.instance()) {
            left.transpile(transpiler);
            transpiler.append(" + ");
            right.transpile(transpiler);
        } else {
            super.transpileAdd(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void declareModulo(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        if (other == IntegerType.instance()) {
            left.declare(transpiler);
            right.declare(transpiler);
        } else {
            super.declareModulo(transpiler, other, left, right);
        }
    }

    @Override
    public void transpileModulo(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        if (other == IntegerType.instance()) {
            left.transpile(transpiler);
            transpiler.append(" % ");
            right.transpile(transpiler);
        } else {
            super.transpileModulo(transpiler, other, left, right);
        }
    }

    @Override
    public void declareDivide(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        transpiler.require("divide");
        if (other == IntegerType.instance() || other == DecimalType.instance()) {
            left.declare(transpiler);
            right.declare(transpiler);
        } else {
            super.declareDivide(transpiler, other, left, right);
        }
    }

    @Override
    public void transpileDivide(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        if (other == IntegerType.instance() || other == DecimalType.instance()) {
            transpiler.append("divide(");
            left.transpile(transpiler);
            transpiler.append(", ");
            right.transpile(transpiler);
            transpiler.append(")");
        } else {
            super.transpileDivide(transpiler, other, left, right);
        }
    }

    @Override
    public void declareIntDivide(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        if (other == IntegerType.instance()) {
            transpiler.require("divide");
            left.declare(transpiler);
            right.declare(transpiler);
        } else {
            super.declareIntDivide(transpiler, other, left, right);
        }
    }

    @Override
    public void transpileIntDivide(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        if (other == IntegerType.instance()) {
            transpiler.append("Math.floor(divide(");
            left.transpile(transpiler);
            transpiler.append(", ");
            right.transpile(transpiler);
            transpiler.append("))");
        } else {
            super.transpileIntDivide(transpiler, other, left, right);
        }
    }

    @Override
    public void declareMinus(Transpiler transpiler, IExpression expression) {
    }

    @Override
    public void transpileMinus(Transpiler transpiler, IExpression expression) {
        transpiler.append(" -");
        expression.transpile(transpiler);
    }

    @Override
    public void declareMultiply(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (other == IntegerType.instance() || other == DecimalType.instance()) {
            left.declare(transpiler);
            right.declare(transpiler);
        } else {
            super.declareMultiply(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void transpileMultiply(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (other == IntegerType.instance() || other == DecimalType.instance()) {
            left.transpile(transpiler);
            transpiler.append(" * ");
            right.transpile(transpiler);
        } else {
            super.transpileMultiply(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void declareSubtract(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        if (other == IntegerType.instance() || other == DecimalType.instance()) {
            left.declare(transpiler);
            right.declare(transpiler);
        } else {
            super.declareSubtract(transpiler, other, left, right);
        }
    }

    @Override
    public void transpileSubtract(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        if (other == IntegerType.instance() || other == DecimalType.instance()) {
            left.transpile(transpiler);
            transpiler.append(" - ");
            right.transpile(transpiler);
        } else {
            super.transpileSubtract(transpiler, other, left, right);
        }
    }

    @Override
    public void declareCompare(Transpiler transpiler, IType rt) {
    }

    @Override
    public void transpileCompare(Transpiler transpiler, IType other, CmpOp operator, IExpression left, IExpression right) {
        left.transpile(transpiler);
        transpiler.append(" ").append(operator.toString()).append(" ");
        right.transpile(transpiler);
    }

    @Override
    public void declareRange(Transpiler transpiler, IType other) {
        if (other == IntegerType.instance()) {
            transpiler.require("Range");
            transpiler.require("IntegerRange");
        } else {
            super.declareRange(transpiler, other);
        }
    }

    @Override
    public void transpileRange(Transpiler transpiler, IExpression first, IExpression last) {
        transpiler.append("new IntegerRange(");
        first.transpile(transpiler);
        transpiler.append(",");
        last.transpile(transpiler);
        transpiler.append(")");
    }

    public static boolean isDecimal(Context context, IExpression exp) {
        IType other = exp.check(context);
        if (other instanceof EnumeratedNativeType) {
            other = ((EnumeratedNativeType)other).getDerivedFrom();
        }
        return other == DecimalType.instance();
    }

    public static ResultInfo compilePlus(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        boolean isDecimal = IntegerType.isDecimal(context, exp);
        CompilerUtils.numberToPrimitive(method, left, isDecimal);
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true).withDecimal(isDecimal));
        CompilerUtils.numberToPrimitive(method, right, isDecimal);
        if (isDecimal) {
            method.addInstruction(Opcode.DADD, new IOperand[0]);
            if (flags.toPrimitive()) {
                return new ResultInfo(Double.TYPE, new ResultInfo.Flag[0]);
            }
            return CompilerUtils.doubleToDouble(method);
        }
        method.addInstruction(Opcode.LADD, new IOperand[0]);
        if (flags.toPrimitive()) {
            return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.longToLong(method);
    }

    public static ResultInfo compileMinus(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        boolean isDecimal = IntegerType.isDecimal(context, exp);
        CompilerUtils.numberToPrimitive(method, left, isDecimal);
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true).withDecimal(isDecimal));
        CompilerUtils.numberToPrimitive(method, right, isDecimal);
        if (isDecimal) {
            method.addInstruction(Opcode.DSUB, new IOperand[0]);
            if (flags.toPrimitive()) {
                return new ResultInfo(Double.TYPE, new ResultInfo.Flag[0]);
            }
            return CompilerUtils.doubleToDouble(method);
        }
        method.addInstruction(Opcode.LSUB, new IOperand[0]);
        if (flags.toPrimitive()) {
            return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.longToLong(method);
    }

    public static ResultInfo compileMultiply(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        IType type = exp.check(context);
        if (type instanceof INumberType) {
            return IntegerType.compileMultiplyNumber(context, method, flags, left, exp);
        }
        if (type == CharacterType.instance()) {
            return IntegerType.compileMultiplyCharacter(context, method, flags, left, exp);
        }
        if (type == TextType.instance()) {
            return IntegerType.compileMultiplyText(context, method, flags, left, exp);
        }
        if (type.getJavaType(context) instanceof NamedType) {
            return IntegerType.compileMultiplyCategory(context, method, flags, left, exp);
        }
        if (IMultiplyable.class.isAssignableFrom((Class)type.getJavaType(context))) {
            return IntegerType.compileMultiplyMultiplyable(context, method, flags, left, exp);
        }
        throw new SyntaxError("Illegal: Integer * " + type.getClass().getSimpleName());
    }

    private static ResultInfo compileMultiplyCategory(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true));
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        return CategoryDeclaration.compileMultiply(context, method, flags, right, left);
    }

    public static ResultInfo compileMultiplyCharacter(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        if (Long.class == left.getType()) {
            CompilerUtils.LongToint(method);
        } else {
            CompilerUtils.longToint(method);
        }
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true));
        if (Character.class == right.getType()) {
            CompilerUtils.CharacterTochar(method);
        }
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoChar.class), "multiply", new Type[]{Character.TYPE, Integer.TYPE, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo compileMultiplyText(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        if (Long.class == left.getType()) {
            CompilerUtils.LongToint(method);
        } else {
            CompilerUtils.longToint(method);
        }
        exp.compile(context, method, flags);
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoString.class), "multiply", new Type[]{String.class, Integer.TYPE, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
    }

    private static ResultInfo compileMultiplyMultiplyable(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        if (Long.class == left.getType()) {
            CompilerUtils.LongToint(method);
        } else {
            CompilerUtils.longToint(method);
        }
        ResultInfo rval = exp.compile(context, method, flags);
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        try {
            Class klass = (Class)rval.getType();
            Class<?> resultType = klass.getMethod("multiply", Integer.TYPE).getReturnType();
            MethodConstant oper = new MethodConstant(rval.getType(), "multiply", Integer.TYPE, resultType);
            method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
            return new ResultInfo(resultType, new ResultInfo.Flag[0]);
        }
        catch (NoSuchMethodException e) {
            throw new SyntaxError(e.getMessage());
        }
    }

    public static ResultInfo compileMultiplyNumber(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        boolean isDecimal = IntegerType.isDecimal(context, exp);
        CompilerUtils.numberToPrimitive(method, left, isDecimal);
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true).withDecimal(isDecimal));
        CompilerUtils.numberToPrimitive(method, right, isDecimal);
        if (isDecimal) {
            method.addInstruction(Opcode.DMUL, new IOperand[0]);
            if (flags.toPrimitive()) {
                return new ResultInfo(Double.TYPE, new ResultInfo.Flag[0]);
            }
            return CompilerUtils.doubleToDouble(method);
        }
        method.addInstruction(Opcode.LMUL, new IOperand[0]);
        if (flags.toPrimitive()) {
            return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.longToLong(method);
    }

    public static ResultInfo compileDivide(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        CompilerUtils.numberToPrimitive(method, left, true);
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true).withDecimal(true));
        CompilerUtils.numberToPrimitive(method, right, true);
        method.addInstruction(Opcode.DDIV, new IOperand[0]);
        if (flags.toPrimitive()) {
            return new ResultInfo(Double.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.doubleToDouble(method);
    }

    public static ResultInfo compileIntDivide(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        CompilerUtils.numberToPrimitive(method, left, false);
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true).withDecimal(false));
        CompilerUtils.numberToPrimitive(method, right, false);
        method.addInstruction(Opcode.LDIV, new IOperand[0]);
        if (flags.toPrimitive()) {
            return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.longToLong(method);
    }

    public static ResultInfo compileModulo(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        CompilerUtils.numberToPrimitive(method, left, false);
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true).withDecimal(false));
        CompilerUtils.numberToPrimitive(method, right, false);
        method.addInstruction(Opcode.LREM, new IOperand[0]);
        if (flags.toPrimitive()) {
            return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.longToLong(method);
    }

    public static ResultInfo compileCompareTo(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        boolean isDecimal = IntegerType.isDecimal(context, exp);
        CompilerUtils.numberToPrimitive(method, left, isDecimal);
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true).withDecimal(isDecimal));
        CompilerUtils.numberToPrimitive(method, right, isDecimal);
        if (isDecimal) {
            method.addInstruction(Opcode.DCMPG, new IOperand[0]);
        } else {
            method.addInstruction(Opcode.LCMP, new IOperand[0]);
        }
        return BaseType.compileCompareToEpilogue(method, flags);
    }

    public static ResultInfo compileEquals(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        left = CompilerUtils.numberTolong(method, left);
        ResultInfo right = exp.compile(context, method, flags);
        right = CompilerUtils.numberTolong(method, right);
        method.addInstruction(Opcode.LCMP, new IOperand[0]);
        Opcode opcode = flags.isReverse() ? Opcode.IFNE : Opcode.IFEQ;
        method.addInstruction(opcode, new ShortOperand(7));
        StackState branchState = method.captureStackState();
        method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        method.addInstruction(Opcode.GOTO, new ShortOperand(4));
        method.restoreFullStackState(branchState);
        method.placeLabel(branchState);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        StackState lastState = method.captureStackState();
        method.placeLabel(lastState);
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    public static ResultInfo compileNegate(Context context, MethodInfo method, Flags flags, ResultInfo value) {
        CompilerUtils.numberToPrimitive(method, value, false);
        method.addInstruction(Opcode.LNEG, new IOperand[0]);
        if (flags.toPrimitive()) {
            return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.longToLong(method);
    }
}

