/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import prompto.runtime.Context;
import prompto.store.Family;
import prompto.store.FamilyInfo;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.IType;
import prompto.type.NativeType;

public abstract class IterableType
extends NativeType {
    IType itemType;
    String typeName;

    protected IterableType(Family family, IType itemType, String typeName) {
        super(family);
        this.itemType = itemType;
        this.typeName = typeName;
    }

    @Override
    public FamilyInfo getFamilyInfo(Context context) {
        FamilyInfo info = this.itemType.getFamilyInfo(context);
        return new FamilyInfo(info.getFamily(), true);
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public IType getItemType() {
        return this.itemType;
    }

    public void setItemType(IType itemType) {
        this.itemType = itemType;
    }

    @Override
    public IType checkContains(Context context, IType other) {
        if (this.itemType.isAssignableFrom(context, other)) {
            return BooleanType.instance();
        }
        return super.checkContains(context, other);
    }

    @Override
    public void checkExists(Context context) {
        this.itemType.checkExists(context);
    }

    @Override
    public boolean isMoreSpecificThan(Context context, IType other) {
        return other instanceof IterableType && this.itemType.isMoreSpecificThan(context, ((IterableType)other).itemType);
    }

    public abstract IterableType withItemType(IType var1);

    @Override
    public void transpileCode(Transpiler transpiler) {
        transpiler.append(".toArray()");
    }
}

