/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import java.lang.reflect.Type;
import prompto.compiler.CompilerUtils;
import prompto.compiler.NamedType;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.SyntaxError;
import prompto.expression.ArrowExpression;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.BaseType;
import prompto.type.IType;

public class MethodType
extends BaseType {
    IMethodDeclaration method;

    public MethodType(IMethodDeclaration method) {
        super(Family.METHOD);
        this.method = method;
    }

    public IMethodDeclaration getMethod() {
        return this.method;
    }

    @Override
    public String getTypeName() {
        return this.method.getName();
    }

    @Override
    public Identifier getTypeNameId() {
        return this.method.getId();
    }

    @Override
    public Type getJavaType(Context context) {
        if (this.method.getClosureOf() != null && this.method.getMemberOf() != null) {
            return this.getMemberClosureJavaType(context);
        }
        if (this.method.getMemberOf() != null) {
            return this.getMemberJavaType(context);
        }
        if (this.method.getClosureOf() != null) {
            return this.getClosureJavaType(context);
        }
        return CompilerUtils.getGlobalMethodType(this.method.getId());
    }

    private Type getMemberClosureJavaType(Context context) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    private Type getMemberJavaType(Context context) {
        Type outer = CompilerUtils.getCategoryConcreteType(this.method.getMemberOf().getId());
        return new NamedType(outer.getTypeName() + '$' + this.method.getName());
    }

    private Type getClosureJavaType(Context context) {
        IMethodDeclaration embedding = this.method.getClosureOf();
        if (embedding.getMemberOf() == null) {
            Type outer = CompilerUtils.getGlobalMethodType(embedding.getId());
            return new NamedType(outer.getTypeName() + '$' + this.method.getName());
        }
        Type outer = CompilerUtils.getCategoryConcreteType(embedding.getMemberOf().getId());
        return new NamedType(outer.getTypeName() + '$' + embedding.getName() + '$' + this.method.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        try {
            return obj instanceof MethodType && this.method.getProto().equals(((MethodType)obj).method.getProto());
        }
        catch (SyntaxError e) {
            return false;
        }
    }

    @Override
    public void checkUnique(Context context) {
        IDeclaration actual = context.getRegisteredDeclaration(IDeclaration.class, this.method.getId());
        if (actual != null) {
            throw new SyntaxError("Duplicate name: \"" + this.method.getId() + "\"");
        }
    }

    @Override
    public void checkExists(Context context) {
    }

    @Override
    public boolean isMoreSpecificThan(Context context, IType other) {
        return false;
    }

    @Override
    public IType checkMember(Context context, Identifier name) {
        INamed named;
        if (context instanceof Context.ClosureContext && (named = context.getRegistered(name)) != null) {
            return named.getType(context);
        }
        return super.checkMember(context, name);
    }

    @Override
    public void declare(Transpiler transpiler) {
    }

    public IType checkArrowExpression(Context context, ArrowExpression expression) {
        context = context.newChildContext();
        this.method.registerParameters(context);
        expression.check(context, this.method.getReturnType());
        return this;
    }

    public void declareArrowExpression(Transpiler transpiler, ArrowExpression expression) {
        transpiler = transpiler.newChildTranspiler(null);
        this.method.registerParameters(transpiler.getContext());
        expression.declare(transpiler);
    }

    public void transpileArrowExpression(Transpiler transpiler, ArrowExpression expression) {
        transpiler = transpiler.newChildTranspiler(null);
        transpiler.append("(function(");
        expression.transpileArguments(transpiler);
        transpiler.append(") {");
        this.method.registerParameters(transpiler.getContext());
        expression.transpile(transpiler);
        transpiler.append("}).bind(this)");
        transpiler.flush();
    }
}

