/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import java.lang.reflect.Type;
import java.util.Comparator;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.comparator.ArrowExpressionComparatorCompiler;
import prompto.expression.ArrowExpression;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoList;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.BaseType;
import prompto.type.BooleanType;
import prompto.type.CharacterType;
import prompto.type.CodeType;
import prompto.type.DateTimeType;
import prompto.type.DateType;
import prompto.type.DecimalType;
import prompto.type.DocumentType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.PeriodType;
import prompto.type.TextType;
import prompto.type.TimeType;
import prompto.type.TupleType;
import prompto.type.UuidType;
import prompto.value.IValue;

public abstract class NativeType
extends BaseType {
    private static NativeType[] all = null;

    public static NativeType[] getAll() {
        if (all == null) {
            all = new NativeType[]{AnyType.instance(), BooleanType.instance(), IntegerType.instance(), DecimalType.instance(), CharacterType.instance(), TextType.instance(), CodeType.instance(), DateType.instance(), TimeType.instance(), DateTimeType.instance(), PeriodType.instance(), DocumentType.instance(), TupleType.instance(), UuidType.instance()};
        }
        return all;
    }

    public NativeType(Family family) {
        super(family);
    }

    @Override
    public Comparator<? extends IValue> getComparator(Context context, IExpression key, boolean descending) {
        if (key == null) {
            return this.getNativeComparator(descending);
        }
        return this.getExpressionComparator(context, key, descending);
    }

    public Comparator<? extends IValue> getExpressionComparator(Context context, IExpression key, boolean descending) {
        if (key instanceof ArrowExpression) {
            return ((ArrowExpression)key).getComparator(context, this, descending);
        }
        throw new UnsupportedOperationException("Comparing native types with non-arrow key is not supported!");
    }

    public Comparator<? extends IValue> getNativeComparator(boolean descending) {
        throw new RuntimeException("Missing native comparator for " + this.getTypeName() + "!");
    }

    @Override
    public IType checkMember(Context context, Identifier name) {
        if ("text".equals(name.toString())) {
            return TextType.instance();
        }
        return super.checkMember(context, name);
    }

    @Override
    public void checkUnique(Context context) {
    }

    @Override
    public void checkExists(Context context) {
    }

    @Override
    public boolean isMoreSpecificThan(Context context, IType other) {
        return false;
    }

    @Override
    public void declareSorted(Transpiler transpiler, IExpression key) {
    }

    @Override
    public void transpileSortedComparator(Transpiler transpiler, IExpression key, boolean descending) {
        if (key instanceof ArrowExpression) {
            ((ArrowExpression)key).transpileSortedComparator(transpiler, this, descending);
        } else if (descending) {
            transpiler.append("function(o1, o2) { return o1 === o2 ? 0 : o1 > o2 ? -1 : 1; }");
        }
    }

    @Override
    public ResultInfo compileSorted(Context context, MethodInfo method, Flags flags, ResultInfo srcInfo, IExpression key, boolean descending) {
        if (key == null) {
            method.addInstruction(descending ? Opcode.ICONST_1 : Opcode.ICONST_0, new IOperand[0]);
            MethodConstant m = new MethodConstant(srcInfo.getType(), "sort", new Type[]{Boolean.TYPE, PromptoList.class});
            method.addInstruction(Opcode.INVOKEVIRTUAL, m);
            return new ResultInfo((Type)((Object)PromptoList.class), new ResultInfo.Flag[0]);
        }
        if (key instanceof ArrowExpression) {
            return this.compileSorted(context, method, flags, srcInfo, (ArrowExpression)key, descending);
        }
        throw new UnsupportedOperationException("Unsupported key type: " + key.getClass().getSimpleName());
    }

    public ResultInfo compileSorted(Context context, MethodInfo method, Flags flags, ResultInfo srcInfo, ArrowExpression key, boolean descending) {
        this.compileComparator(context, method, flags, key, descending);
        MethodConstant m = new MethodConstant(srcInfo.getType(), "sortUsing", new Type[]{Comparator.class, PromptoList.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        return new ResultInfo((Type)((Object)PromptoList.class), new ResultInfo.Flag[0]);
    }

    private ResultInfo compileComparator(Context context, MethodInfo method, Flags flags, ArrowExpression key, boolean descending) {
        Type cmpType = this.compileComparatorClass(context, method.getClassFile(), key, descending);
        return CompilerUtils.compileNewInstance(method, cmpType);
    }

    private Type compileComparatorClass(Context context, ClassFile parentClass, ArrowExpression key, boolean descending) {
        ArrowExpressionComparatorCompiler compiler = new ArrowExpressionComparatorCompiler();
        return compiler.compile(context, parentClass, this, key, descending);
    }
}

