/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.expression.IExpression;
import prompto.intrinsic.PromptoRange;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.CharacterType;
import prompto.type.ContainerType;
import prompto.type.DateType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.IterableType;
import prompto.type.TimeType;

public class RangeType
extends ContainerType {
    static Map<IType, Class<?>> rangeClassMap = RangeType.createRangeClassMap();

    private static Map<IType, Class<?>> createRangeClassMap() {
        HashMap map = new HashMap();
        map.put(CharacterType.instance(), PromptoRange.Character.class);
        map.put(IntegerType.instance(), PromptoRange.Long.class);
        map.put(DateType.instance(), PromptoRange.Date.class);
        map.put(TimeType.instance(), PromptoRange.Time.class);
        return map;
    }

    public RangeType(IType itemType) {
        super(Family.RANGE, itemType, itemType.getTypeName() + "[..]");
    }

    @Override
    public IterableType withItemType(IType itemType) {
        return new RangeType(itemType);
    }

    @Override
    public Type getJavaType(Context context) {
        return rangeClassMap.get(this.itemType);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RangeType)) {
            return false;
        }
        RangeType other = (RangeType)obj;
        return this.getItemType().equals(other.getItemType());
    }

    @Override
    public IType checkItem(Context context, IType other) {
        if (other == IntegerType.instance()) {
            return this.itemType;
        }
        return super.checkItem(context, other);
    }

    @Override
    public IType checkSlice(Context context) {
        return this;
    }

    @Override
    public IType checkIterator(Context context) {
        return this.itemType;
    }

    @Override
    public IType checkContainsAllOrAny(Context context, IType other) {
        return BooleanType.instance();
    }

    @Override
    public void declareContains(Transpiler transpiler, IType other, IExpression container, IExpression item) {
        transpiler.require("StrictSet");
        container.declare(transpiler);
        item.declare(transpiler);
    }

    @Override
    public void transpileContains(Transpiler transpiler, IType other, IExpression container, IExpression item) {
        container.transpile(transpiler);
        transpiler.append(".has(");
        item.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareContainsAllOrAny(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        transpiler.require("StrictSet");
        container.declare(transpiler);
        items.declare(transpiler);
    }

    @Override
    public void transpileContainsAll(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        container.transpile(transpiler);
        transpiler.append(".hasAll(");
        items.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void transpileContainsAny(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        container.transpile(transpiler);
        transpiler.append(".hasAny(");
        items.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareItem(Transpiler transpiler, IType itemType, IExpression item) {
    }

    @Override
    public void transpileItem(Transpiler transpiler, IType itemType, IExpression item) {
        transpiler.append(".item(");
        item.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareSlice(Transpiler transpiler, IExpression first, IExpression last) {
        if (first != null) {
            first.declare(transpiler);
        }
        if (last != null) {
            last.declare(transpiler);
        }
    }

    @Override
    public void transpileSlice(Transpiler transpiler, IExpression first, IExpression last) {
        transpiler.append(".slice1Based(");
        if (first != null) {
            first.transpile(transpiler);
        } else {
            transpiler.append("null");
        }
        if (last != null) {
            transpiler.append(",");
            last.transpile(transpiler);
        }
        transpiler.append(")");
    }

    public static ResultInfo compileEquals(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        exp.compile(context, method, flags);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoRange.class), "equals", new Type[]{Object.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        if (flags.isReverse()) {
            CompilerUtils.reverseBoolean(method);
        }
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    public static ResultInfo compileItem(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true));
        right = CompilerUtils.numberTolong(method, right);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoRange.class), "getItem", new Type[]{Long.TYPE, Object.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo((Type)((Object)Object.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo compileSlice(Context context, MethodInfo method, Flags flags, ResultInfo parent, IExpression first, IExpression last) {
        ContainerType.compileSliceFirst(context, method, flags, first);
        ContainerType.compileSliceLast(context, method, flags, last);
        MethodConstant m = new MethodConstant(parent.getType(), "slice", Long.TYPE, Long.TYPE, parent.getType());
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        return parent;
    }
}

