/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoSet;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.ContainerType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.IterableType;
import prompto.type.ListType;
import prompto.value.IValue;
import prompto.value.SetValue;

public class SetType
extends ContainerType {
    static final IMethodDeclaration JOIN_METHOD = new ContainerType.JoinMethod(){

        @Override
        protected Collection<IValue> getItems(Context context) {
            SetValue set = (SetValue)this.getValue(context);
            return set.getItems();
        }
    };

    public SetType(IType itemType) {
        super(Family.SET, itemType, itemType.getTypeName() + "<>");
    }

    @Override
    public IterableType withItemType(IType itemType) {
        return new SetType(itemType);
    }

    @Override
    public Type getJavaType(Context context) {
        return PromptoSet.class;
    }

    @Override
    public boolean isAssignableFrom(Context context, IType other) {
        return super.isAssignableFrom(context, other) || other instanceof SetType && ((SetType)other).getItemType().isAssignableFrom(context, this.itemType);
    }

    @Override
    public IType checkIterator(Context context) {
        return this.itemType;
    }

    @Override
    public IType checkMember(Context context, Identifier id) {
        String name = id.toString();
        if ("count".equals(name)) {
            return IntegerType.instance();
        }
        return super.checkMember(context, id);
    }

    @Override
    public IType checkAdd(Context context, IType other, boolean tryReverse) {
        if ((other instanceof ListType || other instanceof SetType) && this.getItemType().equals(((ContainerType)other).getItemType())) {
            return this;
        }
        return super.checkAdd(context, other, tryReverse);
    }

    @Override
    public IType checkSubstract(Context context, IType other) {
        if ((other instanceof ListType || other instanceof SetType) && this.getItemType().equals(((ContainerType)other).getItemType())) {
            return this;
        }
        return super.checkSubstract(context, other);
    }

    @Override
    public IType checkItem(Context context, IType other) {
        if (other == IntegerType.instance()) {
            return this.itemType;
        }
        return super.checkItem(context, other);
    }

    @Override
    public IType checkContainsAllOrAny(Context context, IType other) {
        return BooleanType.instance();
    }

    @Override
    public Set<IMethodDeclaration> getMemberMethods(Context context, Identifier id) throws PromptoError {
        switch (id.toString()) {
            case "join": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(JOIN_METHOD));
            }
        }
        return super.getMemberMethods(context, id);
    }

    @Override
    public String getTranspiledName(Context context) {
        return this.itemType.getTranspiledName(context) + "_set";
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.register("StrictSet");
        this.itemType.declare(transpiler);
    }

    @Override
    public void transpile(Transpiler transpiler) {
        transpiler.append("StrictSet");
    }

    @Override
    public void declareAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if ((other instanceof SetType || other instanceof ListType) && this.getItemType().equals(((ContainerType)other).getItemType())) {
            left.declare(transpiler);
            right.declare(transpiler);
        } else {
            super.declareAdd(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void transpileAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if ((other instanceof SetType || other instanceof ListType) && this.getItemType().equals(((ContainerType)other).getItemType())) {
            left.transpile(transpiler);
            transpiler.append(".addAll(");
            right.transpile(transpiler);
            transpiler.append(")");
        } else {
            super.transpileAdd(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void declareSubtract(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        if ((other instanceof ListType || other instanceof SetType) && this.getItemType().equals(((ContainerType)other).getItemType())) {
            left.declare(transpiler);
            right.declare(transpiler);
        } else {
            super.declareSubtract(transpiler, other, left, right);
        }
    }

    @Override
    public void transpileSubtract(Transpiler transpiler, IType other, IExpression left, IExpression right) {
        if ((other instanceof ListType || other instanceof SetType) && this.getItemType().equals(((ContainerType)other).getItemType())) {
            left.transpile(transpiler);
            transpiler.append(".remove(");
            right.transpile(transpiler);
            transpiler.append(")");
        } else {
            super.transpileSubtract(transpiler, other, left, right);
        }
    }

    @Override
    public void declareContains(Transpiler transpiler, IType other, IExpression container, IExpression item) {
        container.declare(transpiler);
        item.declare(transpiler);
    }

    @Override
    public void transpileContains(Transpiler transpiler, IType other, IExpression container, IExpression item) {
        container.transpile(transpiler);
        transpiler.append(".has(");
        item.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareContainsAllOrAny(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        transpiler.require("StrictSet");
        container.declare(transpiler);
        items.declare(transpiler);
    }

    @Override
    public void transpileContainsAll(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        container.transpile(transpiler);
        transpiler.append(".hasAll(");
        items.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void transpileContainsAny(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        container.transpile(transpiler);
        transpiler.append(".hasAny(");
        items.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareItem(Transpiler transpiler, IType itemType, IExpression item) {
    }

    @Override
    public void transpileItem(Transpiler transpiler, IType itemType, IExpression item) {
        transpiler.append(".item(");
        item.transpile(transpiler);
        transpiler.append("-1)");
    }

    public static ResultInfo compileItem(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true));
        right = CompilerUtils.numberToint(method, right);
        method.addInstruction(Opcode.ICONST_M1, new IOperand[0]);
        method.addInstruction(Opcode.IADD, new IOperand[0]);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoSet.class), "get", new Type[]{Integer.TYPE, Object.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo((Type)((Object)Object.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo compileEquals(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        exp.compile(context, method, flags);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoSet.class), "equals", new Type[]{Object.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        if (flags.isReverse()) {
            CompilerUtils.reverseBoolean(method);
        }
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    public static ResultInfo compilePlus(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        ResultInfo info = CompilerUtils.compileNewInstance(method, PromptoSet.class);
        method.addInstruction(Opcode.DUP_X1, new IOperand[0]);
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoSet.class), "addAll", new Type[]{Collection.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        exp.compile(context, method, flags);
        oper = new MethodConstant((Type)((Object)PromptoSet.class), "addAll", new Type[]{Collection.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        return info;
    }

    public static ResultInfo compileMinus(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        ResultInfo info = CompilerUtils.compileNewInstance(method, PromptoSet.class);
        method.addInstruction(Opcode.DUP_X1, new IOperand[0]);
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoSet.class), "addAll", new Type[]{Collection.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        exp.compile(context, method, flags);
        oper = new MethodConstant((Type)((Object)PromptoSet.class), "removeAll", new Type[]{Collection.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        return info;
    }
}

