/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.ShortOperand;
import prompto.compiler.StackState;
import prompto.declaration.BuiltInMethodDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.CmpOp;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoString;
import prompto.literal.IntegerLiteral;
import prompto.literal.TextLiteral;
import prompto.param.CategoryParameter;
import prompto.param.IParameter;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.BaseType;
import prompto.type.BooleanType;
import prompto.type.CharacterType;
import prompto.type.DecimalType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.ListType;
import prompto.type.NativeType;
import prompto.utils.StringUtils;
import prompto.value.BooleanValue;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.ListValue;
import prompto.value.TextValue;

public class TextType
extends NativeType {
    static TextType instance = new TextType();
    static IParameter TO_REPLACE_ARGUMENT = new CategoryParameter(TextType.instance(), new Identifier("toReplace"));
    static IParameter REPLACE_WITH_ARGUMENT = new CategoryParameter(TextType.instance(), new Identifier("replaceWith"));
    static final IMethodDeclaration REPLACE_METHOD = new BuiltInMethodDeclaration("replace", new IParameter[]{TO_REPLACE_ARGUMENT, REPLACE_WITH_ARGUMENT}){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            String value = (String)this.getValue(context).getStorableData();
            String toReplace = (String)context.getValue(new Identifier("toReplace")).getStorableData();
            String replaceWith = (String)context.getValue(new Identifier("replaceWith")).getStorableData();
            String result = StringUtils.replaceOne(value, toReplace, replaceWith);
            return new TextValue(result);
        }

        @Override
        public IType check(Context context) {
            return TextType.instance();
        }

        @Override
        public boolean hasCompileExactInstanceMember() {
            return true;
        }

        @Override
        public ResultInfo compileExactInstanceMember(Context context, MethodInfo method, Flags flags, ArgumentList arguments) {
            this.compileParameters(context, method, flags, arguments);
            Descriptor.Method descriptor = new Descriptor.Method(new Type[]{String.class, String.class, String.class, String.class});
            MethodConstant constant = new MethodConstant((Type)((Object)StringUtils.class), "replaceOne", descriptor);
            method.addInstruction(Opcode.INVOKESTATIC, constant);
            return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("replace(");
            arguments.find(new Identifier("toReplace")).transpile(transpiler, null);
            transpiler.append(",");
            arguments.find(new Identifier("replaceWith")).transpile(transpiler, null);
            transpiler.append(")");
        }
    };
    static final IMethodDeclaration REPLACE_ALL_METHOD = new BuiltInMethodDeclaration("replaceAll", new IParameter[]{TO_REPLACE_ARGUMENT, REPLACE_WITH_ARGUMENT}){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            String value = (String)this.getValue(context).getStorableData();
            String toReplace = (String)context.getValue(new Identifier("toReplace")).getStorableData();
            String replaceWith = (String)context.getValue(new Identifier("replaceWith")).getStorableData();
            String result = value.replace(toReplace, replaceWith);
            return new TextValue(result);
        }

        @Override
        public IType check(Context context) {
            return TextType.instance();
        }

        @Override
        public boolean hasCompileExactInstanceMember() {
            return true;
        }

        @Override
        public ResultInfo compileExactInstanceMember(Context context, MethodInfo method, Flags flags, ArgumentList arguments) {
            this.compileParameters(context, method, flags, arguments);
            Descriptor.Method descriptor = new Descriptor.Method(new Type[]{CharSequence.class, CharSequence.class, String.class});
            MethodConstant constant = new MethodConstant((Type)((Object)String.class), "replace", descriptor);
            method.addInstruction(Opcode.INVOKEVIRTUAL, constant);
            return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("replace(new RegExp(");
            arguments.find(new Identifier("toReplace")).transpile(transpiler, null);
            transpiler.append(", 'g'),");
            arguments.find(new Identifier("replaceWith")).transpile(transpiler, null);
            transpiler.append(")");
        }
    };
    static IParameter SINGLE_SPACE_ARGUMENT = new CategoryParameter(TextType.instance(), new Identifier("separator"), new TextLiteral("\" \""));
    static final IMethodDeclaration SPLIT_METHOD = new BuiltInMethodDeclaration("split", SINGLE_SPACE_ARGUMENT){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            String value = (String)this.getValue(context).getStorableData();
            String sep = (String)context.getValue(new Identifier("separator")).getStorableData();
            String[] parts = value.split(sep);
            PromptoList list = new PromptoList(false);
            for (String part : parts) {
                list.add(new TextValue(part));
            }
            return new ListValue((IType)TextType.instance(), list);
        }

        @Override
        public IType check(Context context) {
            return new ListType(TextType.instance());
        }

        @Override
        public boolean hasCompileExactInstanceMember() {
            return true;
        }

        @Override
        public ResultInfo compileExactInstanceMember(Context context, MethodInfo method, Flags flags, ArgumentList arguments) {
            this.compileParameters(context, method, flags, arguments);
            Descriptor.Method descriptor = new Descriptor.Method(new Type[]{String.class, String[].class});
            MethodConstant constant = new MethodConstant((Type)((Object)String.class), "split", descriptor);
            method.addInstruction(Opcode.INVOKEVIRTUAL, constant);
            method.addInstruction(Opcode.NEW, new ClassConstant((Type)((Object)PromptoList.class)));
            method.addInstruction(Opcode.DUP_X1, new IOperand[0]);
            method.addInstruction(Opcode.SWAP, new IOperand[0]);
            descriptor = new Descriptor.Method(new Type[]{Object[].class, Void.TYPE});
            MethodConstant oper = new MethodConstant((Type)((Object)PromptoList.class), "<init>", descriptor);
            method.addInstruction(Opcode.INVOKESPECIAL, oper);
            return new ResultInfo((Type)((Object)PromptoList.class), new ResultInfo.Flag[0]);
        }

        @Override
        public void declareCall(Transpiler transpiler) {
            transpiler.require("List");
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("splitToList(");
            if (arguments != null) {
                ((Argument)arguments.get(0)).transpile(transpiler, null);
            } else {
                transpiler.append("' '");
            }
            transpiler.append(")");
        }
    };
    static final IMethodDeclaration TO_CAPITALIZED_METHOD = new BuiltInMethodDeclaration("toCapitalized"){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            String value = (String)this.getValue(context).getStorableData();
            String result = StringUtils.capitalizeAll(value);
            return new TextValue(result);
        }

        @Override
        public IType check(Context context) {
            return TextType.instance();
        }

        @Override
        public boolean hasCompileExactInstanceMember() {
            return true;
        }

        @Override
        public ResultInfo compileExactInstanceMember(Context context, MethodInfo method, Flags flags, ArgumentList arguments) {
            this.compileParameters(context, method, flags, arguments);
            Descriptor.Method descriptor = new Descriptor.Method(new Type[]{String.class, String.class});
            MethodConstant constant = new MethodConstant((Type)((Object)StringUtils.class), "capitalizeAll", descriptor);
            method.addInstruction(Opcode.INVOKESTATIC, constant);
            return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("replace( /(^|\\s)([a-z])/g , function(m, p1, p2){ return p1 + p2.toUpperCase(); } )");
        }
    };
    static final IMethodDeclaration TO_LOWERCASE_METHOD = new BuiltInMethodDeclaration("toLowerCase"){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            TextValue text = (TextValue)this.getValue(context);
            String lower = text.getStorableData().toLowerCase();
            return new TextValue(lower);
        }

        @Override
        public IType check(Context context) {
            return TextType.instance();
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("toLowerCase()");
        }
    };
    static final IMethodDeclaration TO_UPPERCASE_METHOD = new BuiltInMethodDeclaration("toUpperCase"){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            TextValue text = (TextValue)this.getValue(context);
            String lower = text.getStorableData().toUpperCase();
            return new TextValue(lower);
        }

        @Override
        public IType check(Context context) {
            return TextType.instance();
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("toUpperCase()");
        }
    };
    static final IMethodDeclaration TRIM_METHOD = new BuiltInMethodDeclaration("trim"){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            TextValue text = (TextValue)this.getValue(context);
            String trimmed = text.getStorableData().trim();
            return new TextValue(trimmed);
        }

        @Override
        public IType check(Context context) {
            return TextType.instance();
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("trim()");
        }
    };
    static IParameter TEXT_VALUE_ARGUMENT = new CategoryParameter(TextType.instance(), new Identifier("value"));
    static final IMethodDeclaration STARTS_WITH_METHOD = new BuiltInMethodDeclaration("startsWith", TEXT_VALUE_ARGUMENT){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            TextValue text = (TextValue)this.getValue(context);
            String value = (String)context.getValue(new Identifier("value")).getStorableData();
            boolean startsWith = text.getStorableData().startsWith(value);
            return BooleanValue.valueOf(startsWith);
        }

        @Override
        public IType check(Context context) {
            return BooleanType.instance();
        }

        @Override
        public boolean hasCompileExactInstanceMember() {
            return true;
        }

        @Override
        public ResultInfo compileExactInstanceMember(Context context, MethodInfo method, Flags flags, ArgumentList arguments) {
            this.compileParameters(context, method, flags, arguments);
            Descriptor.Method descriptor = new Descriptor.Method(new Type[]{String.class, Boolean.TYPE});
            MethodConstant constant = new MethodConstant((Type)((Object)String.class), "startsWith", descriptor);
            method.addInstruction(Opcode.INVOKEVIRTUAL, constant);
            if (flags.toPrimitive()) {
                return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
            }
            return CompilerUtils.booleanToBoolean(method);
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("startsWith(");
            ((Argument)arguments.get(0)).transpile(transpiler, null);
            transpiler.append(")");
        }
    };
    static final IMethodDeclaration ENDS_WITH_METHOD = new BuiltInMethodDeclaration("endsWith", TEXT_VALUE_ARGUMENT){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            TextValue text = (TextValue)this.getValue(context);
            String value = (String)context.getValue(new Identifier("value")).getStorableData();
            boolean endsWith = text.getStorableData().endsWith(value);
            return BooleanValue.valueOf(endsWith);
        }

        @Override
        public IType check(Context context) {
            return BooleanType.instance();
        }

        @Override
        public boolean hasCompileExactInstanceMember() {
            return true;
        }

        @Override
        public ResultInfo compileExactInstanceMember(Context context, MethodInfo method, Flags flags, ArgumentList arguments) {
            this.compileParameters(context, method, flags, arguments);
            Descriptor.Method descriptor = new Descriptor.Method(new Type[]{String.class, Boolean.TYPE});
            MethodConstant constant = new MethodConstant((Type)((Object)String.class), "endsWith", descriptor);
            method.addInstruction(Opcode.INVOKEVIRTUAL, constant);
            if (flags.toPrimitive()) {
                return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
            }
            return CompilerUtils.booleanToBoolean(method);
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("endsWith(");
            ((Argument)arguments.get(0)).transpile(transpiler, null);
            transpiler.append(")");
        }
    };
    static IParameter FROM_INDEX_ARGUMENT = new CategoryParameter(IntegerType.instance(), new Identifier("fromIndex"), new IntegerLiteral("1"));
    static final IMethodDeclaration INDEX_OF_METHOD = new BuiltInMethodDeclaration("indexOf", new IParameter[]{TEXT_VALUE_ARGUMENT, FROM_INDEX_ARGUMENT}){

        @Override
        public IValue interpret(Context context) throws PromptoError {
            TextValue text = (TextValue)this.getValue(context);
            String value = (String)context.getValue(new Identifier("value")).getStorableData();
            Long fromIndex = (Long)context.getValue(new Identifier("fromIndex")).getStorableData();
            int indexOf = text.getStorableData().indexOf(value, fromIndex.intValue() - 1);
            return new IntegerValue(indexOf + 1);
        }

        @Override
        public IType check(Context context) {
            return IntegerType.instance();
        }

        @Override
        public boolean hasCompileExactInstanceMember() {
            return true;
        }

        @Override
        public ResultInfo compileExactInstanceMember(Context context, MethodInfo method, Flags flags, ArgumentList arguments) {
            this.compileParameters(context, method, flags, arguments);
            CompilerUtils.LongTolong(method);
            Descriptor.Method descriptor = new Descriptor.Method(new Type[]{String.class, String.class, Long.TYPE, Long.TYPE});
            MethodConstant constant = new MethodConstant((Type)((Object)PromptoString.class), "indexOf", descriptor);
            method.addInstruction(Opcode.INVOKESTATIC, constant);
            if (flags.toPrimitive()) {
                return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
            }
            return CompilerUtils.longToLong(method);
        }

        @Override
        public void transpileCall(Transpiler transpiler, ArgumentList arguments) {
            transpiler.append("indexOf1Based(");
            ((Argument)arguments.get(0)).transpile(transpiler, null);
            if (arguments.size() > 1) {
                transpiler.append(",");
                ((Argument)arguments.get(1)).transpile(transpiler, null);
                transpiler.append(")");
            } else {
                transpiler.append(",0)");
            }
        }
    };

    public static TextType instance() {
        return instance;
    }

    private TextType() {
        super(Family.TEXT);
    }

    @Override
    public Type getJavaType(Context context) {
        return String.class;
    }

    @Override
    public boolean isAssignableFrom(Context context, IType other) {
        return super.isAssignableFrom(context, other) || other == CharacterType.instance();
    }

    @Override
    public IType checkAdd(Context context, IType other, boolean tryReverse) {
        if (tryReverse) {
            return this;
        }
        return super.checkAdd(context, other, tryReverse);
    }

    @Override
    public IType checkMultiply(Context context, IType other, boolean tryReverse) {
        if (other instanceof IntegerType) {
            return this;
        }
        return super.checkMultiply(context, other, tryReverse);
    }

    @Override
    public IType checkCompare(Context context, IType other, ISection section) {
        if (other instanceof TextType || other instanceof CharacterType) {
            return BooleanType.instance();
        }
        return super.checkCompare(context, other, section);
    }

    @Override
    public IType checkItem(Context context, IType other) {
        if (other == IntegerType.instance()) {
            return CharacterType.instance();
        }
        return super.checkItem(context, other);
    }

    @Override
    public IType checkMember(Context context, Identifier id) {
        String name = id.toString();
        if ("count".equals(name)) {
            return IntegerType.instance();
        }
        return super.checkMember(context, id);
    }

    @Override
    public IType checkContains(Context context, IType other) {
        if (other instanceof TextType || other instanceof CharacterType) {
            return BooleanType.instance();
        }
        return super.checkContains(context, other);
    }

    @Override
    public IType checkContainsAllOrAny(Context context, IType other) {
        return BooleanType.instance();
    }

    @Override
    public IType checkSlice(Context context) {
        return this;
    }

    @Override
    public Set<IMethodDeclaration> getMemberMethods(Context context, Identifier id) throws PromptoError {
        switch (id.toString()) {
            case "startsWith": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(STARTS_WITH_METHOD));
            }
            case "endsWith": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(ENDS_WITH_METHOD));
            }
            case "toLowerCase": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(TO_LOWERCASE_METHOD));
            }
            case "toUpperCase": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(TO_UPPERCASE_METHOD));
            }
            case "toCapitalized": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(TO_CAPITALIZED_METHOD));
            }
            case "replace": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(REPLACE_METHOD));
            }
            case "replaceAll": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(REPLACE_ALL_METHOD));
            }
            case "split": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(SPLIT_METHOD));
            }
            case "trim": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(TRIM_METHOD));
            }
            case "indexOf": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(INDEX_OF_METHOD));
            }
        }
        return super.getMemberMethods(context, id);
    }

    public Comparator<TextValue> getNativeComparator(boolean descending) {
        return descending ? (o1, o2) -> o2.getStorableData().compareTo(o1.getStorableData()) : (o1, o2) -> o1.getStorableData().compareTo(o2.getStorableData());
    }

    @Override
    public IValue convertIValueToIValue(Context context, IValue value) {
        if (value instanceof TextValue) {
            return value;
        }
        return super.convertJavaValueToIValue(context, value);
    }

    @Override
    public IValue convertJavaValueToIValue(Context context, Object value) {
        if (value instanceof String) {
            return new TextValue((String)value);
        }
        return super.convertJavaValueToIValue(context, value);
    }

    @Override
    public void compileConvertObjectToExact(Context context, MethodInfo method, Flags flags) {
        MethodConstant m = new MethodConstant((Type)((Object)PromptoString.class), "convertObjectToExact", new Type[]{Object.class, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
    }

    @Override
    public IValue readJSONValue(Context context, JsonNode value, Map<String, byte[]> parts) {
        return new TextValue(value.asText());
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("Utils");
    }

    @Override
    public void transpile(Transpiler transpiler) {
        transpiler.append("'Text'");
    }

    @Override
    public void declareAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        left.declare(transpiler);
        right.declare(transpiler);
    }

    @Override
    public void transpileAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        left.transpile(transpiler);
        transpiler.append(" + ");
        right.transpile(transpiler);
        if (other == DecimalType.instance()) {
            transpiler.append(".toDecimalString()");
        }
    }

    @Override
    public void declareMultiply(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (other == IntegerType.instance()) {
            left.declare(transpiler);
            right.declare(transpiler);
        } else {
            super.declareMultiply(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void transpileMultiply(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (other == IntegerType.instance()) {
            left.transpile(transpiler);
            transpiler.append(".repeat(");
            right.transpile(transpiler);
            transpiler.append(")");
        } else {
            super.transpileMultiply(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void declareMember(Transpiler transpiler, Identifier name) {
        if (!"count".equals(name.toString())) {
            super.declareMember(transpiler, name);
        }
    }

    @Override
    public void transpileMember(Transpiler transpiler, Identifier name) {
        if ("count".equals(name.toString())) {
            transpiler.append("length");
        } else {
            super.transpileMember(transpiler, name);
        }
    }

    @Override
    public void declareSlice(Transpiler transpiler, IExpression first, IExpression last) {
        if (first != null) {
            first.declare(transpiler);
        }
        if (last != null) {
            last.declare(transpiler);
        }
    }

    @Override
    public void transpileSlice(Transpiler transpiler, IExpression first, IExpression last) {
        transpiler.append(".slice1Based(");
        if (first != null) {
            first.transpile(transpiler);
        } else {
            transpiler.append("null");
        }
        if (last != null) {
            transpiler.append(",");
            last.transpile(transpiler);
        }
        transpiler.append(")");
    }

    @Override
    public void declareContains(Transpiler transpiler, IType other, IExpression container, IExpression item) {
        container.declare(transpiler);
        item.declare(transpiler);
    }

    @Override
    public void transpileContains(Transpiler transpiler, IType other, IExpression container, IExpression item) {
        container.transpile(transpiler);
        transpiler.append(".includes(");
        item.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareContainsAllOrAny(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        container.declare(transpiler);
        items.declare(transpiler);
    }

    @Override
    public void transpileContainsAll(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        container.transpile(transpiler);
        transpiler.append(".hasAll(");
        items.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void transpileContainsAny(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        container.transpile(transpiler);
        transpiler.append(".hasAny(");
        items.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareCompare(Transpiler transpiler, IType other) {
    }

    @Override
    public void transpileCompare(Transpiler transpiler, IType other, CmpOp operator, IExpression left, IExpression right) {
        left.transpile(transpiler);
        transpiler.append(" ").append(operator.toString()).append(" ");
        right.transpile(transpiler);
    }

    @Override
    public void declareItem(Transpiler transpiler, IType itemType, IExpression item) {
    }

    @Override
    public void transpileItem(Transpiler transpiler, IType itemType, IExpression item) {
        transpiler.append("[");
        item.transpile(transpiler);
        transpiler.append("-1]");
    }

    public static ResultInfo compilePlus(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        exp.compile(context, method, flags.withPrimitive(false));
        MethodConstant oper = new MethodConstant((Type)((Object)String.class), "valueOf", new Type[]{Object.class, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        oper = new MethodConstant((Type)((Object)String.class), "concat", new Type[]{String.class, String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo compileMultiply(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        ResultInfo right = exp.compile(context, method, flags);
        if (Long.class == right.getType()) {
            CompilerUtils.LongToint(method);
        } else if (Long.TYPE == right.getType()) {
            CompilerUtils.longToint(method);
        }
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoString.class), "multiply", new Type[]{String.class, Integer.TYPE, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)String.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo compileCompareTo(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        exp.compile(context, method, flags);
        MethodConstant oper = new MethodConstant((Type)((Object)String.class), "compareTo", new Type[]{String.class, Integer.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return BaseType.compileCompareToEpilogue(method, flags);
    }

    public static ResultInfo compileItem(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        ResultInfo right = exp.compile(context, method, flags);
        if (Long.class == right.getType()) {
            CompilerUtils.LongToint(method);
        } else if (Long.TYPE == right.getType()) {
            CompilerUtils.longToint(method);
        }
        MethodConstant oper = new MethodConstant((Type)((Object)String.class), "charAt", Integer.TYPE, Character.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        if (flags.toPrimitive()) {
            return new ResultInfo(Character.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.charToCharacter(method);
    }

    public static ResultInfo compileSlice(Context context, MethodInfo method, Flags flags, ResultInfo parent, IExpression first, IExpression last) {
        TextType.compileTextSliceFirst(context, method, flags, first);
        TextType.compileTextSliceLast(context, method, flags, last);
        MethodConstant m = new MethodConstant((Type)((Object)String.class), "substring", new Type[]{Integer.TYPE, Integer.TYPE, String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        return parent;
    }

    public static void compileTextSliceFirst(Context context, MethodInfo method, Flags flags, IExpression first) {
        if (first == null) {
            method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        } else {
            ResultInfo finfo = first.compile(context, method, flags.withPrimitive(true));
            finfo = CompilerUtils.numberToint(method, finfo);
            method.addInstruction(Opcode.ICONST_M1, new IOperand[0]);
            method.addInstruction(Opcode.IADD, new IOperand[0]);
        }
    }

    private static void compileTextSliceLast(Context context, MethodInfo method, Flags flags, IExpression last) {
        TextType.compileSliceMaxIndex(method);
        if (last != null) {
            ResultInfo linfo = last.compile(context, method, flags.withPrimitive(true));
            linfo = CompilerUtils.numberToint(method, linfo);
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            method.addInstruction(Opcode.IFGE, new ShortOperand(9));
            StackState branchState = method.captureStackState();
            method.addInstruction(Opcode.IADD, new IOperand[0]);
            method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
            method.addInstruction(Opcode.IADD, new IOperand[0]);
            method.addInstruction(Opcode.GOTO, new ShortOperand(5));
            method.restoreFullStackState(branchState);
            method.placeLabel(branchState);
            method.addInstruction(Opcode.SWAP, new IOperand[0]);
            method.addInstruction(Opcode.POP, new IOperand[0]);
            StackState lastState = method.captureStackState();
            method.placeLabel(lastState);
        }
    }

    public static void compileSliceMaxIndex(MethodInfo method) {
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        method.addInstruction(Opcode.DUP_X1, new IOperand[0]);
        MethodConstant m = new MethodConstant((Type)((Object)String.class), "length", Integer.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
    }

    public static ResultInfo compileEquals(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        exp.compile(context, method, flags);
        MethodConstant oper = flags.isRoughly() ? new MethodConstant((Type)((Object)String.class), "equalsIgnoreCase", new Type[]{String.class, Boolean.TYPE}) : new MethodConstant((Type)((Object)String.class), "equals", new Type[]{Object.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        if (flags.isReverse()) {
            CompilerUtils.reverseBoolean(method);
        }
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    public static ResultInfo compileContains(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        MethodConstant m;
        ResultInfo right = exp.compile(context, method, flags);
        if (right.getType() != String.class) {
            m = new MethodConstant((Type)((Object)String.class), "valueOf", new Type[]{Object.class, String.class});
            method.addInstruction(Opcode.INVOKESTATIC, m);
        }
        m = new MethodConstant((Type)((Object)String.class), "contains", new Type[]{CharSequence.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        if (flags.isReverse()) {
            CompilerUtils.reverseBoolean(method);
        }
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }
}

