/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoTuple;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.BooleanType;
import prompto.type.ContainerType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.IterableType;
import prompto.type.ListType;
import prompto.type.SetType;
import prompto.value.IValue;
import prompto.value.TupleValue;

public class TupleType
extends ContainerType {
    static TupleType instance = new TupleType();
    static final IMethodDeclaration JOIN_METHOD = new ContainerType.JoinMethod(){

        @Override
        protected Collection<IValue> getItems(Context context) {
            TupleValue tuple = (TupleValue)this.getValue(context);
            return tuple.getItems();
        }
    };

    public static TupleType instance() {
        return instance;
    }

    private TupleType() {
        super(Family.TUPLE, AnyType.instance(), "any");
    }

    @Override
    public IterableType withItemType(IType itemType) {
        return this;
    }

    @Override
    public Type getJavaType(Context context) {
        return PromptoTuple.class;
    }

    @Override
    public boolean isAssignableFrom(Context context, IType other) {
        return super.isAssignableFrom(context, other) || other instanceof ListType || other instanceof SetType;
    }

    @Override
    public IType checkItem(Context context, IType other) {
        if (other == IntegerType.instance()) {
            return AnyType.instance();
        }
        return super.checkItem(context, other);
    }

    @Override
    public IType checkMember(Context context, Identifier id) {
        String name = id.toString();
        if ("count".equals(name)) {
            return IntegerType.instance();
        }
        return super.checkMember(context, id);
    }

    @Override
    public IType checkAdd(Context context, IType other, boolean tryReverse) {
        if (other instanceof TupleType || other instanceof ListType || other instanceof SetType) {
            return this;
        }
        return super.checkAdd(context, other, tryReverse);
    }

    @Override
    public IType checkContains(Context context, IType other) {
        return BooleanType.instance();
    }

    @Override
    public IType checkContainsAllOrAny(Context context, IType other) {
        return BooleanType.instance();
    }

    @Override
    public Set<IMethodDeclaration> getMemberMethods(Context context, Identifier id) throws PromptoError {
        switch (id.toString()) {
            case "join": {
                return new HashSet<IMethodDeclaration>(Collections.singletonList(JOIN_METHOD));
            }
        }
        return super.getMemberMethods(context, id);
    }

    @Override
    public void declareAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (other == TupleType.instance() || other instanceof ListType || other instanceof SetType) {
            left.declare(transpiler);
            right.declare(transpiler);
        } else {
            super.declareAdd(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void transpileAdd(Transpiler transpiler, IType other, boolean tryReverse, IExpression left, IExpression right) {
        if (other == TupleType.instance() || other instanceof ListType || other instanceof SetType) {
            left.transpile(transpiler);
            transpiler.append(".add(");
            right.transpile(transpiler);
            transpiler.append(")");
        } else {
            super.transpileAdd(transpiler, other, tryReverse, left, right);
        }
    }

    @Override
    public void declareItem(Transpiler transpiler, IType itemType, IExpression item) {
        if (itemType == IntegerType.instance) {
            item.declare(transpiler);
        } else {
            super.declareItem(transpiler, itemType, item);
        }
    }

    @Override
    public void transpileItem(Transpiler transpiler, IType itemType, IExpression item) {
        if (itemType == IntegerType.instance()) {
            transpiler.append("[");
            item.transpile(transpiler);
            transpiler.append("-1]");
        } else {
            super.transpileItem(transpiler, itemType, item);
        }
    }

    @Override
    public void transpileAssignItemValue(Transpiler transpiler, IExpression item, IExpression expression) {
        transpiler.append(".setItem(");
        item.transpile(transpiler);
        transpiler.append(", ");
        expression.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareContains(Transpiler transpiler, IType other, IExpression container, IExpression item) {
        container.declare(transpiler);
        item.declare(transpiler);
    }

    @Override
    public void transpileContains(Transpiler transpiler, IType other, IExpression container, IExpression item) {
        container.transpile(transpiler);
        transpiler.append(".includes(");
        item.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareContainsAllOrAny(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        transpiler.require("StrictSet");
        container.declare(transpiler);
        items.declare(transpiler);
    }

    @Override
    public void transpileContainsAll(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        container.transpile(transpiler);
        transpiler.append(".hasAll(");
        items.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void transpileContainsAny(Transpiler transpiler, IType other, IExpression container, IExpression items) {
        container.transpile(transpiler);
        transpiler.append(".hasAny(");
        items.transpile(transpiler);
        transpiler.append(")");
    }

    public static ResultInfo compileSlice(Context context, MethodInfo method, Flags flags, ResultInfo parent, IExpression first, IExpression last) {
        ContainerType.compileSliceFirst(context, method, flags, first);
        ContainerType.compileSliceLast(context, method, flags, last);
        MethodConstant m = new MethodConstant((Type)((Object)PromptoTuple.class), "slice", new Type[]{Long.TYPE, Long.TYPE, PromptoTuple.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        return parent;
    }

    public static ResultInfo compileItem(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        ResultInfo right = exp.compile(context, method, flags.withPrimitive(true));
        right = CompilerUtils.numberToint(method, right);
        method.addInstruction(Opcode.ICONST_M1, new IOperand[0]);
        method.addInstruction(Opcode.IADD, new IOperand[0]);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoTuple.class), "get", new Type[]{Integer.TYPE, Object.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return new ResultInfo((Type)((Object)Object.class), new ResultInfo.Flag[0]);
    }

    public static ResultInfo compilePlus(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        ResultInfo info = CompilerUtils.compileNewRawInstance(method, PromptoTuple.class);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        CompilerUtils.compileCallConstructor(method, PromptoTuple.class, new Type[]{Boolean.TYPE});
        method.addInstruction(Opcode.DUP_X1, new IOperand[0]);
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoTuple.class), "addAll", new Type[]{Collection.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        exp.compile(context, method, flags);
        oper = new MethodConstant((Type)((Object)PromptoTuple.class), "addAll", new Type[]{Collection.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        return info;
    }
}

