/*
 * Decompiled with CFR 0.152.
 */
package prompto.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Map;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.expression.IExpression;
import prompto.grammar.CmpOp;
import prompto.intrinsic.PromptoVersion;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.transpiler.Transpiler;
import prompto.type.BaseType;
import prompto.type.BooleanType;
import prompto.type.IType;
import prompto.type.NativeType;
import prompto.value.IValue;
import prompto.value.VersionValue;

public class VersionType
extends NativeType {
    static VersionType instance = new VersionType();

    public static VersionType instance() {
        return instance;
    }

    private VersionType() {
        super(Family.VERSION);
    }

    @Override
    public Type getJavaType(Context context) {
        return PromptoVersion.class;
    }

    @Override
    public boolean isAssignableFrom(Context context, IType other) {
        return super.isAssignableFrom(context, other) || other == VersionType.instance();
    }

    @Override
    public IValue convertJavaValueToIValue(Context context, Object value) {
        if (value instanceof PromptoVersion) {
            return new VersionValue((PromptoVersion)value);
        }
        return super.convertJavaValueToIValue(context, value);
    }

    @Override
    public IType checkCompare(Context context, IType other, ISection section) {
        if (other instanceof VersionType) {
            return BooleanType.instance();
        }
        return super.checkCompare(context, other, section);
    }

    public Comparator<VersionValue> getNativeComparator(boolean descending) {
        return descending ? new Comparator<VersionValue>(){

            @Override
            public int compare(VersionValue o1, VersionValue o2) {
                return o2.getStorableData().compareTo(o1.getStorableData());
            }
        } : new Comparator<VersionValue>(){

            @Override
            public int compare(VersionValue o1, VersionValue o2) {
                return o1.getStorableData().compareTo(o2.getStorableData());
            }
        };
    }

    @Override
    public String toString(Object value) {
        return "'" + value.toString() + "'";
    }

    @Override
    public IValue readJSONValue(Context context, JsonNode value, Map<String, byte[]> parts) {
        PromptoVersion version = PromptoVersion.parse(value.asText());
        return new VersionValue(version);
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.register("Version");
    }

    @Override
    public void transpile(Transpiler transpiler) {
        transpiler.append("Version");
    }

    @Override
    public void declareCompare(Transpiler transpiler, IType other) {
    }

    @Override
    public void transpileCompare(Transpiler transpiler, IType other, CmpOp operator, IExpression left, IExpression right) {
        left.transpile(transpiler);
        transpiler.append(".");
        operator.transpile(transpiler);
        transpiler.append("(");
        right.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void transpileCode(Transpiler transpiler) {
        transpiler.append(".toString()");
    }

    public static ResultInfo compileCompareTo(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        exp.compile(context, method, flags);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoVersion.class), "compareTo", new Type[]{PromptoVersion.class, Integer.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        return BaseType.compileCompareToEpilogue(method, flags);
    }

    public static ResultInfo compileEquals(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression exp) {
        exp.compile(context, method, flags);
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoVersion.class), "equals", new Type[]{Object.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, oper);
        if (flags.isReverse()) {
            CompilerUtils.reverseBoolean(method);
        }
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }
}

