/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public abstract class ClassPathVisitor {
    public abstract void visitClass(Class<?> var1);

    public void visitClassesInClassPath() {
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources("");
            while (urls.hasMoreElements()) {
                this.visitClassesInURL(urls.nextElement());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void visitClassesInURL(URL url) {
        String protocol;
        switch (protocol = url.getProtocol()) {
            case "file": {
                this.visitClassesInDirectory(url);
                break;
            }
            case "jar": {
                this.visitClassesInJar(url);
            }
            default: {
                throw new RuntimeException("Unknown protocol:" + protocol);
            }
        }
    }

    private void visitClassesInDirectory(URL url) {
        File file = new File(url.getPath());
        this.visitClassesInDirectory(file, "");
    }

    private void visitClassesInDirectory(File dir, String packagePath) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.visitClassesInDirectory(file, packagePath + "/" + file.getName());
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            this.visitClassInFile(file, packagePath);
        }
    }

    private void visitClassInFile(File file, String packagePath) {
        packagePath = packagePath.substring(1).replace('/', '.');
        String simpleName = file.getName().substring(0, file.getName().indexOf(".class"));
        String className = packagePath + '.' + simpleName;
        this.visitClass(className);
    }

    private void visitClass(String className) {
        try {
            Class<?> klass = Class.forName(className);
            this.visitClass(klass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void visitClassesInJar(URL url) {
        try (InputStream stream = url.openStream();){
            this.visitClassesInJarInputStream(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void visitClassesInJarInputStream(InputStream stream) {
        try (JarInputStream jar = new JarInputStream(stream);){
            this.visitClassesInJarInputStream(jar);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void visitClassesInJarInputStream(JarInputStream jar) {
        try {
            JarEntry entry = jar.getNextJarEntry();
            while (entry != null) {
                this.visitClassInJarEntry(entry);
                entry = jar.getNextJarEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void visitClassInJarEntry(JarEntry entry) {
        String name = entry.getName();
        if (!name.endsWith(".class")) {
            return;
        }
        String className = name.substring(1).substring(0, name.indexOf(".class") - 1).replace('/', '.');
        this.visitClass(className);
    }
}

