/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import prompto.utils.ArgsLexer;
import prompto.utils.ArgsParser;
import prompto.utils.ArgsParserBaseListener;

public class CmdLineParser {
    public static Map<String, String> read(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        int max = args.length;
        for (int i = 0; i < max; ++i) {
            String key = args[i];
            if (i == 0 && key.endsWith(".jar")) {
                map.put("jar", key);
                continue;
            }
            if (!key.startsWith("-") || i >= args.length - 1) continue;
            key = key.substring(1);
            map.put(key, args[++i]);
        }
        return map;
    }

    public static Map<String, String> parse(String input) throws Exception {
        if (input == null) {
            input = "";
        }
        try {
            CodePointCharStream stream = CharStreams.fromString((String)input);
            ArgsLexer lexer = new ArgsLexer((CharStream)stream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            ArgsParser parser = new ArgsParser((TokenStream)tokens);
            ArgsParser.ParseContext tree = parser.parse();
            CmdLineBuilder builder = new CmdLineBuilder();
            ParseTreeWalker walker = new ParseTreeWalker();
            walker.walk((ParseTreeListener)builder, (ParseTree)tree);
            return builder.getCmdLineArgs();
        }
        catch (RecognitionException e) {
            e.printStackTrace(System.err);
            throw new Exception(e);
        }
    }

    static class CmdLineBuilder
    extends ArgsParserBaseListener {
        Map<String, String> args = new HashMap<String, String>();
        ParseTreeProperty<String> values = new ParseTreeProperty();

        CmdLineBuilder() {
        }

        public Map<String, String> getCmdLineArgs() {
            return this.args;
        }

        @Override
        public void exitEntry(ArgsParser.EntryContext ctx) {
            String key = (String)this.values.get((ParseTree)ctx.k);
            String value = (String)this.values.get((ParseTree)ctx.v);
            this.args.put(key, value);
        }

        @Override
        public void exitKey(ArgsParser.KeyContext ctx) {
            this.values.put((ParseTree)ctx, (Object)ctx.getText());
        }

        @Override
        public void exitSTRING(ArgsParser.STRINGContext ctx) {
            String s = ctx.getText();
            this.values.put((ParseTree)ctx, (Object)s.substring(1, s.length() - 1));
        }

        @Override
        public void exitELEMENT(ArgsParser.ELEMENTContext ctx) {
            this.values.put((ParseTree)ctx, (Object)ctx.getText());
        }
    }
}

