/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import prompto.grammar.Identifier;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.type.CategoryType;

public class CodeWriter {
    Dialect dialect;
    Context context;
    StringBuilder sb;
    Indenter indenter;
    int escapeMode;

    public CodeWriter(Dialect dialect, Context context) {
        this(dialect, context, 0);
    }

    public CodeWriter(Dialect dialect, Context context, int escapeMode) {
        this.dialect = dialect;
        this.context = context;
        this.escapeMode = escapeMode;
        this.sb = new StringBuilder();
        this.indenter = new Indenter();
    }

    public CodeWriter(Dialect dialect, Context context, int escapeMode, StringBuilder sb, Indenter indenter) {
        this.dialect = dialect;
        this.context = context;
        this.escapeMode = escapeMode;
        this.sb = sb;
        this.indenter = indenter;
    }

    public Context getContext() {
        return this.context;
    }

    public int getEscapeMode() {
        return this.escapeMode;
    }

    public CodeWriter append(Identifier id) {
        this.append(id.toString());
        return this;
    }

    public CodeWriter append(String s) {
        this.indenter.appendTabsIfRequired(s);
        this.sb.append(s);
        return this;
    }

    public CodeWriter appendRaw(String s) {
        this.sb.append(s);
        return this;
    }

    public CodeWriter append(char c) {
        this.indenter.appendTabsIfRequired(c);
        this.sb.append(c);
        return this;
    }

    public CodeWriter trimLast(int count) {
        this.sb.setLength(this.sb.length() - count);
        return this;
    }

    public CodeWriter indent() {
        this.indenter.indent();
        return this;
    }

    public CodeWriter dedent() {
        this.indenter.dedent();
        return this;
    }

    public CodeWriter newLine() {
        this.append('\n');
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public boolean isGlobalContext() {
        return this.context.isGlobalsContext();
    }

    public CodeWriter newLocalWriter() {
        return new CodeWriter(this.dialect, this.context.newLocalContext(), this.escapeMode, this.sb, this.indenter);
    }

    public CodeWriter newChildWriter() {
        return this.newChildWriter(this.context.newChildContext());
    }

    public CodeWriter newChildWriter(Context context) {
        return new CodeWriter(this.dialect, context, this.escapeMode, this.sb, this.indenter);
    }

    public CodeWriter newMemberWriter() {
        Context context = this.context.newLocalContext();
        context.setParentContext(this.context);
        return new CodeWriter(this.dialect, context, this.escapeMode, this.sb, this.indenter);
    }

    public CodeWriter newInstanceWriter(CategoryType type) {
        return new CodeWriter(this.dialect, this.context.newInstanceContext(type, false), this.escapeMode, this.sb, this.indenter);
    }

    public CodeWriter newDocumentWriter() {
        return new CodeWriter(this.dialect, this.context.newDocumentContext(false), this.escapeMode, this.sb, this.indenter);
    }

    class Indenter {
        public String indents = "";
        public boolean isStartOfLine = true;

        Indenter() {
        }

        public void appendTabsIfRequired(String s) {
            this.appendTabsIfRequired(s.charAt(s.length() - 1));
        }

        public void appendTabsIfRequired(char c) {
            if (this.isStartOfLine) {
                CodeWriter.this.sb.append(this.indents);
            }
            this.isStartOfLine = c == '\n';
        }

        public void indent() {
            this.indents = this.indents + '\t';
        }

        public void dedent() {
            if (this.indents.isEmpty()) {
                throw new RuntimeException("Illegal dedent!");
            }
            this.indents = this.indents.substring(1);
        }
    }
}

